/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.common;

import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.HashMap;

public class ImageParser
extends BaseParser {
    private String mThemeDir;
    private ImageData mImageData;

    public ImageParser(Object context) {
        super(context);
        this.mFileName = "image.ini";
    }

    @Override
    public ImageData getParserResult(String tag) {
        String bitmapTag = String.valueOf(this.mFileName) + this.mLandscape + this.mThemeDir;
        HashMap<String, ImageData> bitmapDataPool = (HashMap<String, ImageData>)mAllDataPool.get(bitmapTag);
        if (bitmapDataPool != null) {
            this.mImageData = (ImageData)bitmapDataPool.get(tag);
        } else {
            this.mImageData = null;
            bitmapDataPool = new HashMap<String, ImageData>();
        }
        if (this.mImageData == null) {
            this.mImageData = new ImageData();
            this.mImageData.setTag(tag);
            this.parserProperties(tag);
            bitmapDataPool.put(tag, this.mImageData);
            mAllDataPool.put(bitmapTag, bitmapDataPool);
        }
        return this.mImageData;
    }

    public void setThemeDir(String themeDir) {
        this.mThemeDir = themeDir;
    }

    public ImageData getImageData() {
        return this.mImageData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("SRC")) {
            this.mImageData.setSrcName(value);
        } else if (key.equalsIgnoreCase("DENSITY")) {
            this.mImageData.setDensity(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("RECT")) {
            this.mImageData.setRectangle(ThemeUtils.splitInt(value, ","));
            this.mImageData.setRectStrings(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("X_DIVS")) {
            this.mImageData.setXDivs(ThemeUtils.splitInt(value, ","));
            this.mImageData.setXDivs(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("Y_DIVS")) {
            this.mImageData.setYDivs(ThemeUtils.splitInt(value, ","));
            this.mImageData.setYDivs(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("ALPHA")) {
            this.mImageData.setAlpha(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("PADDING")) {
            this.mImageData.setPadding(ThemeUtils.splitInt(value, ","));
        } else if (key.equalsIgnoreCase("IMG_TYPE")) {
            this.mImageData.setType(Integer.valueOf(value));
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

