/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.theme;

import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.model.common.StyleData;
import java.awt.Image;

public class ThemeLayoutData {
    private Rectangle mZoomRect;
    private ShowMode mShowMode = ShowMode.Zoom;
    private StyleData mStyleData;
    private String mStyleTag;
    private int[] mLayoutSize;
    private String mLayoutTag;
    private int[] mTypeAttr;

    public void setShowMode(int showMode) {
        switch (showMode) {
            case 1: {
                this.mShowMode = ShowMode.Tile;
                break;
            }
            case 2: {
                this.mShowMode = ShowMode.Cut;
                break;
            }
            default: {
                this.mShowMode = ShowMode.Zoom;
            }
        }
    }

    public void setStyleTag(String tag) {
        this.mStyleTag = tag;
    }

    public String getStyleTag() {
        return this.mStyleTag;
    }

    public ShowMode getShowMode() {
        return this.mShowMode;
    }

    public void setRectZ(int[] rect) {
        if (rect != null && rect.length > 0) {
            this.mZoomRect = new Rectangle();
            switch (rect.length) {
                case 4: {
                    this.mZoomRect.mY2 = rect[3];
                }
                case 3: {
                    this.mZoomRect.mX2 = rect[2];
                }
                case 2: {
                    this.mZoomRect.mY1 = rect[1];
                }
                case 1: {
                    this.mZoomRect.mX1 = rect[0];
                }
            }
        }
    }

    public Rectangle getRectZ() {
        return this.mZoomRect;
    }

    public void setStyle(StyleData styleData) {
        this.mStyleData = styleData;
    }

    public StyleData getStyle() {
        return this.mStyleData;
    }

    public Image getOriginalBackgroundImage() {
        if (this.mStyleData == null) {
            return null;
        }
        if (this.mStyleData.getImageTag() != null) {
            return null;
        }
        return null;
    }

    public int[] getLayoutSize() {
        return this.mLayoutSize;
    }

    public void setLayoutSize(int width, int height) {
        if (this.mLayoutSize == null) {
            this.mLayoutSize = new int[2];
        }
        this.mLayoutSize[0] = width;
        this.mLayoutSize[1] = height;
    }

    public boolean isSameSize(int width, int height) {
        if (this.mLayoutSize == null) {
            return false;
        }
        return this.mLayoutSize[0] == width && this.mLayoutSize[1] == height;
    }

    public int[] getTypeAttr() {
        return this.mTypeAttr;
    }

    public void setTypeAttr(int[] type) {
        this.mTypeAttr = type;
    }

    public String getmLayoutTag() {
        return this.mLayoutTag;
    }

    public void setmLayoutTag(String mLayoutTag) {
        this.mLayoutTag = mLayoutTag;
    }

    public static enum ShowMode {
        Zoom,
        Tile,
        Cut;

    }
}

