/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.layout;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.BalloonData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.model.layout.SubKeyData;
import java.util.ArrayList;

public class SelectableBalloonData
extends BalloonData {
    private AreaData mAreaData;
    private String[] mTextes;
    private int mHlIndex;

    public void setBalloonArea(AreaData area) {
        this.mAreaData = area;
    }

    public AreaData getBalloonAreaData() {
        return this.mAreaData;
    }

    public void setText(String[] textes, int highLightIndex) {
        this.mTextes = textes;
        this.mHlIndex = highLightIndex;
    }

    public String[] getText() {
        return this.mTextes;
    }

    public int getHlIndex() {
        return this.mHlIndex;
    }

    public boolean loadBalloonData() {
        if (this.mAreaData != null && this.mTextes != null && this.mTextes.length > 0) {
            RowData rowData;
            ArrayList<RowData> rowSet = (ArrayList<RowData>)this.mAreaData.getRowSet();
            if (rowSet == null || rowSet.isEmpty()) {
                rowData = new RowData();
                rowData.setLayoutType(LayoutType.HORIZONTAL);
                if (rowSet == null) {
                    rowSet = new ArrayList<RowData>();
                }
                rowSet.add(rowData);
                this.mAreaData.setRowSet(rowSet);
            } else {
                rowData = (RowData)rowSet.get(0);
                rowData.removeAllKeyData();
            }
            DimensData areaDimens = this.mAreaData.getDimensData();
            areaDimens.measurePadding(480.0f, 480.0f);
            switch (rowData.getLayoutType()) {
                case VERTICAL: {
                    areaDimens.measureWidth(480.0f);
                    break;
                }
                default: {
                    areaDimens.measureHeight(480.0f);
                }
            }
            int width = 0;
            int height = 0;
            int size = this.mTextes.length;
            String[] stringArray = this.mTextes;
            int n = this.mTextes.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                KeyData keyData = this.mAreaData.getKeyAttribute().clone();
                SubKeyData subKeyData = keyData.getDefaultSubKeyData();
                if (subKeyData == null) {
                    subKeyData = new SubKeyData();
                    subKeyData.setGravity(0x110000);
                    subKeyData.setDefaultOperation();
                    subKeyData.setText(text);
                    keyData.addSubKeyDataForGravity(subKeyData);
                }
                subKeyData.setText(text);
                rowData.addKeyData(keyData);
                DimensData keyDimens = keyData.getDimensData();
                keyDimens.measurePadding(480.0f, 480.0f);
                keyDimens.measureMargin(480.0f, 480.0f);
                switch (rowData.getLayoutType()) {
                    case VERTICAL: {
                        keyDimens.measureHeight(480.0f);
                        keyData.measure(480.0f, 0.0f);
                        break;
                    }
                    default: {
                        keyDimens.measureWidth(480.0f);
                        keyData.measure(0.0f, 800.0f);
                    }
                }
                Rectangle margin = keyDimens.getMargin();
                int mleft = 0;
                int mright = 0;
                int mtop = 0;
                int mbottom = 0;
                if (margin != null) {
                    mleft = margin.mX1;
                    mright = margin.mX2;
                    mtop = margin.mY1;
                    mbottom = margin.mY2;
                }
                width = (int)((float)width + ((float)mleft + keyDimens.getWidth() + (float)mright));
                height = (int)((float)height + ((float)mtop + keyDimens.getHeight() + (float)mbottom));
                switch (rowData.getLayoutType()) {
                    case VERTICAL: {
                        keyDimens.setHeightString(String.valueOf(String.valueOf(100 / size)) + "%p");
                        break;
                    }
                    default: {
                        keyDimens.setWidthString(String.valueOf(String.valueOf(100 / size)) + "%p");
                    }
                }
                ++n2;
            }
            DimensData rowDimens = rowData.getDimensData();
            switch (rowData.getLayoutType()) {
                case VERTICAL: {
                    rowDimens.setHeight(height);
                    rowDimens.setWidth(areaDimens.getWidth());
                    break;
                }
                default: {
                    rowDimens.setWidth(width);
                    rowDimens.setHeight(areaDimens.getHeight());
                }
            }
            Rectangle margin = rowDimens.getMargin();
            int mleft = 0;
            int mright = 0;
            int mtop = 0;
            int mbottom = 0;
            if (margin != null) {
                mleft = margin.mX1;
                mright = margin.mY1;
                mtop = margin.mX2;
                mbottom = margin.mY2;
            }
            Rectangle padding = areaDimens.getPadding();
            int pleft = 0;
            int pright = 0;
            int ptop = 0;
            int pbottom = 0;
            if (padding != null) {
                pleft = padding.mX1;
                pright = padding.mY1;
                ptop = padding.mX2;
                pbottom = padding.mY2;
            }
            areaDimens.setWidth((float)(pleft + mleft) + rowDimens.getWidth() + (float)mright + (float)pright);
            areaDimens.setHeight((float)(ptop + mtop) + rowDimens.getHeight() + (float)mbottom + (float)pbottom);
            return true;
        }
        return false;
    }
}

