/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.layout;

import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;

public class AnimationData
implements Cloneable {
    protected AnimationType mAnimationType;
    protected InterpolatorType mInterpolatorType;
    protected int mAnimationDrawableNum;
    protected ImageIcon[] mAnimationImages;
    protected boolean mShareInterpolator;
    protected int mDuration;
    protected int mRepeatCount;
    protected long mStartOffset;
    protected boolean mFillAfter;
    private String mAnimationTag;

    public AnimationData() {
    }

    protected AnimationData(DataInputStream is, int type) throws IOException {
        if (type != this.description()) {
            throw new IOException("the type is incompatible");
        }
        int version = is.readInt();
        if (version != this.version()) {
            throw new IOException("the version is incompatible, old version is " + version + ", new version is " + this.version());
        }
    }

    public AnimationType create(int value) {
        switch (value) {
            case 0: {
                return AnimationType.NONE;
            }
            case 1: {
                return AnimationType.ALPHA;
            }
            case 2: {
                return AnimationType.TRANSLATE;
            }
            case 3: {
                return AnimationType.SCALE;
            }
            case 4: {
                return AnimationType.ROTATE;
            }
            case 5: {
                return AnimationType.ROTATE3D;
            }
            case 6: {
                return AnimationType.ATSET;
            }
            case 7: {
                return AnimationType.AUTO_FRAME;
            }
            case 8: {
                return AnimationType.PAGE;
            }
            case 9: {
                return AnimationType.MANUAL_SWITCH;
            }
            case 10: {
                return AnimationType.MANUAL_ROTATE;
            }
            case 11: {
                return AnimationType.MANUAL_FRAME;
            }
        }
        return AnimationType.NONE;
    }

    public String getmAnimationTag() {
        return this.mAnimationTag;
    }

    public void setmAnimationTag(String mAnimationTag) {
        this.mAnimationTag = mAnimationTag;
    }

    public void setAnimationType(AnimationType animationType) {
        this.mAnimationType = animationType;
    }

    public void setAnimationType(int animationType) {
        switch (animationType) {
            case 0: {
                this.mAnimationType = AnimationType.NONE;
                break;
            }
            case 1: {
                this.mAnimationType = AnimationType.ALPHA;
                break;
            }
            case 2: {
                this.mAnimationType = AnimationType.TRANSLATE;
                break;
            }
            case 3: {
                this.mAnimationType = AnimationType.SCALE;
                break;
            }
            case 4: {
                this.mAnimationType = AnimationType.ROTATE;
                break;
            }
            case 5: {
                this.mAnimationType = AnimationType.ROTATE3D;
                break;
            }
            case 6: {
                this.mAnimationType = AnimationType.ATSET;
                break;
            }
            case 7: {
                this.mAnimationType = AnimationType.AUTO_FRAME;
                break;
            }
            case 8: {
                this.mAnimationType = AnimationType.PAGE;
                break;
            }
            case 9: {
                this.mAnimationType = AnimationType.MANUAL_SWITCH;
                break;
            }
            case 10: {
                this.mAnimationType = AnimationType.MANUAL_ROTATE;
                break;
            }
            case 11: {
                this.mAnimationType = AnimationType.MANUAL_FRAME;
                break;
            }
        }
    }

    public AnimationType getAnimationType() {
        return this.mAnimationType;
    }

    public void setInterpolatorType(InterpolatorType interpolatorType) {
        this.mInterpolatorType = interpolatorType;
    }

    public InterpolatorType getInterpolatorType() {
        return this.mInterpolatorType;
    }

    public void setAnimationDrawableNum(int animationDrawableNum) {
        this.mAnimationDrawableNum = animationDrawableNum;
    }

    public int getAnimationDrawableNum() {
        return this.mAnimationDrawableNum;
    }

    public void setAnimationDrawables(ImageIcon[] animationDrawables) {
        this.mAnimationImages = animationDrawables;
    }

    public ImageIcon[] getAnimationDrawables() {
        return this.mAnimationImages;
    }

    public void setShareInterpolator(boolean shareInterpolator) {
        this.mShareInterpolator = shareInterpolator;
    }

    public boolean isShareInterpolator() {
        return this.mShareInterpolator;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setRepeatCount(int repeatCount) {
        this.mRepeatCount = repeatCount;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setStartOffset(long startOffset) {
        this.mStartOffset = startOffset;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public void setFillAfter(boolean fillAfter) {
        this.mFillAfter = fillAfter;
    }

    public boolean isFillAfter() {
        return this.mFillAfter;
    }

    public int version() {
        return 0;
    }

    public int description() {
        return 0;
    }

    public AnimationData Clone() {
        AnimationData animationData = null;
        try {
            animationData = (AnimationData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return animationData;
    }

    public String[] getAnimationDrawableStrs() {
        return null;
    }

    public static enum AnimationType {
        NONE,
        ALPHA,
        TRANSLATE,
        SCALE,
        ROTATE,
        ROTATE3D,
        ATSET,
        AUTO_FRAME,
        PAGE,
        MANUAL_SWITCH,
        MANUAL_ROTATE,
        MANUAL_FRAME;

    }

    public static enum InterpolatorType {
        ACCELERATE,
        ANTICIPATE,
        ANTICIPATE_OVERSHOOT,
        BOUNCE,
        CYCLE,
        DECELERATE,
        LINEAR,
        OVERSHOOT,
        ACCELERATE_DECELERATE;

    }
}

