/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.common;

import com.iflytek.skintool.domin.DisplayConst;
import com.iflytek.skintool.domin.KeyImageData;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.pool.ImagePool;
import javax.swing.ImageIcon;

public class StyleData
implements Cloneable {
    private int mTextSize;
    private String mTextSizeStr;
    private int mTextColor;
    private TextStyle mTextStyle;
    protected ImageIcon mImage;
    protected String mImageTag;
    private int mBgColor = DisplayConst.DEFAULT_COLOR;
    private int mBgRectColor;
    private float[] mBgRectRadian;
    private TextAlign mTextAlign;
    private TextFloat mTextFloat;
    private int mImageColor;
    private int mImageAlpha;
    private boolean mStyleOver = true;
    private ImageData mImageData;
    private String mTag;

    public StyleData clone() {
        StyleData styleData = null;
        try {
            styleData = (StyleData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return styleData;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public void merge(StyleData style) {
        if (style == null) {
            return;
        }
        if (style.mImageTag != null && this.mImageTag == null) {
            this.mImageTag = style.mImageTag;
        }
        if (style.mImage != null && this.mImage == null) {
            this.mImage = style.mImage;
        }
        if (style.mBgColor != 0 && this.mBgColor == 0) {
            this.mBgColor = style.mBgColor;
        }
        if (style.mTextSizeStr != null && this.mTextSizeStr == null) {
            this.mTextSizeStr = style.mTextSizeStr;
        }
        if (style.mTextSize != 0 && this.mTextSize == 0) {
            this.mTextSize = style.mTextSize;
        }
        if (style.mTextColor != 0 && this.mTextColor == 0) {
            this.mTextColor = style.mTextColor;
        }
        if (style.mTextAlign != null && this.mTextAlign == null) {
            this.mTextAlign = style.mTextAlign;
        }
    }

    public void setTextSize(int textSize, boolean isFirst) {
        this.mTextSize = textSize;
        this.mTextSize = (int)((double)this.mTextSize / 1.23);
    }

    public void setTextSize(String textsize) {
        this.mTextSizeStr = textsize;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public String getTextSizeStr() {
        return this.mTextSizeStr;
    }

    public void setTextSizeStr(String value) {
        this.mTextSizeStr = value;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextStyle(int textStyle) {
        switch (textStyle) {
            case 0: {
                this.mTextStyle = TextStyle.NORMAL;
            }
            case 1: {
                this.mTextStyle = TextStyle.ITALIC;
            }
            case 2: {
                this.mTextStyle = TextStyle.BOLD;
            }
            case 3: {
                this.mTextStyle = TextStyle.UNDERLINE;
            }
        }
        this.mTextStyle = TextStyle.NORMAL;
    }

    public TextStyle getTextStyle() {
        return this.mTextStyle;
    }

    public void setImage(ImageIcon image) {
        this.mImage = image;
    }

    public void setImageTag(String imageTag) {
        this.mImageTag = imageTag;
    }

    public String getImageTag() {
        return this.mImageTag;
    }

    public void setBgColor(int bgColor) {
        this.mBgColor = bgColor;
    }

    public int getBgColor() {
        return this.mBgColor;
    }

    public int getImageColor() {
        return this.mImageColor;
    }

    public void setImageColor(int imgColor) {
        this.mImageColor = imgColor;
    }

    public int getImageAlpha() {
        return this.mImageAlpha;
    }

    public void setImageAlpha(int alpha) {
        this.mImageAlpha = alpha;
    }

    public boolean isStyleOver() {
        return this.mStyleOver;
    }

    public void setStyleOver(boolean styleOver) {
        this.mStyleOver = styleOver;
    }

    public void setTextAlign(int textAlign) {
        switch (textAlign) {
            case 0: {
                this.mTextAlign = TextAlign.LEFT;
                break;
            }
            case 1: {
                this.mTextAlign = TextAlign.CENTER;
                break;
            }
            case 2: {
                this.mTextAlign = TextAlign.RIGHT;
                break;
            }
            default: {
                this.mTextAlign = TextAlign.CENTER;
            }
        }
    }

    public TextAlign getTextAlign() {
        return this.mTextAlign;
    }

    public void setTextFloat(int textFloat) {
        switch (textFloat) {
            case 0: {
                this.mTextFloat = TextFloat.LEFT;
                break;
            }
            case 1: {
                this.mTextFloat = TextFloat.TOP;
                break;
            }
            case 2: {
                this.mTextFloat = TextFloat.RIGHT;
                break;
            }
            case 3: {
                this.mTextFloat = TextFloat.BOTTOM;
                break;
            }
            default: {
                this.mTextFloat = TextFloat.LEFT;
            }
        }
    }

    public TextFloat getTextFloat() {
        return this.mTextFloat;
    }

    public void setBorderColor(int color) {
        this.mBgRectColor = color;
    }

    public int getBorderColor() {
        return this.mBgRectColor;
    }

    public void setBorderRadius(float rx, float ry) {
        this.mBgRectRadian = new float[]{rx, ry};
    }

    public float[] getBorderRadius() {
        if (this.mBgRectRadian == null) {
            this.mBgRectRadian = new float[]{0.0f, 0.0f};
        }
        return this.mBgRectRadian;
    }

    public void setImageData(ImageData data) {
        this.mImageData = data;
    }

    public ImageData getImageData() {
        return this.mImageData;
    }

    public KeyImageData loadImage(boolean scaledFlag, int width, int height) {
        if (this.mImageTag != null) {
            KeyImageData keyimage = ImagePool.getInstance().getImageByTag(this.mImageTag, false, width, height);
            if (keyimage.getXDivs()[0] == 0 && keyimage.getXDivs()[1] == 0 && keyimage.getYDivs()[0] == 0 && keyimage.getYDivs()[1] == 0 && width != 0 && height != 0 && !scaledFlag) {
                ImageIcon icon = keyimage.getIcon();
                icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 1));
                keyimage.setIcon(icon);
            }
            if (keyimage != null) {
                this.mImage = keyimage.getIcon();
            }
            return keyimage;
        }
        return null;
    }

    public ImageIcon getImage() {
        return this.mImage;
    }

    public void showStyleData() {
        System.out.println("mTextSize: " + this.mTextSize);
        System.out.println("mTextColor: " + this.mTextColor);
        System.out.println("mTextStyle: " + (Object)((Object)this.mTextStyle));
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum TextFloat {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    public static enum TextStyle {
        NORMAL,
        ITALIC,
        BOLD,
        UNDERLINE;

    }
}

