/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.low;

import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.graphical.low.IMEButton;
import com.iflytek.skintool.util.PictureUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public abstract class IMEPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ImageIcon mWallPaper;
    protected ImageIcon mAlphaedImage;
    protected String ThemeStyleTag;
    protected IMEButton[] mSonButton;
    protected int mSonButtonLength = 0;
    protected IMEPanel[] mSonPanel;
    protected int mSonPanleLength = 0;
    protected Rectangle mPadding;
    protected Rectangle mMargin = new Rectangle();

    public IMEPanel() {
        this.mPadding = new Rectangle();
    }

    public void setThemeStyleTag(String tag) {
        this.ThemeStyleTag = tag;
    }

    public String getThemeStyleTag() {
        return this.ThemeStyleTag;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mWallPaper != null) {
            this.processBackground(g);
        }
    }

    public void setAlphaedImage(ImageIcon alphaedImage) {
        this.mAlphaedImage = alphaedImage;
        this.repaint();
    }

    public void setBackgroundIcon(ImageIcon wallpaper) {
        this.mWallPaper = wallpaper;
        this.repaint();
    }

    public ImageIcon getBackIcon() {
        return this.mWallPaper;
    }

    public void setBackgroudColor(Color color) {
        super.setBackground(color);
    }

    private void processBackground(Graphics g) {
        ImageIcon icon = this.mWallPaper;
        if (this.mAlphaedImage != null) {
            icon = this.mAlphaedImage;
        }
        Image image = icon.getImage();
        int cw = this.getWidth();
        int ch = this.getHeight();
        int iw = image.getWidth(this);
        int ih = image.getHeight(this);
        Image reImage = image;
        if (iw >= cw && ih >= ch) {
            reImage = new ImageIcon(PictureUtil.createResizedImage(image, cw, ch)).getImage();
            iw = cw;
            ih = ch;
        }
        g.drawImage(reImage, 0, 0, this);
    }

    public void setSonButton(IMEButton button) {
        this.mSonButton[this.mSonButtonLength] = button;
        ++this.mSonButtonLength;
    }

    public void replaceSonButton(IMEButton button, int j) {
        this.mSonButton[j] = button;
    }

    public IMEButton[] getSonButton() {
        return this.mSonButton;
    }

    public void setSonPanel(IMEPanel jpanel) {
        this.mSonPanel[this.mSonPanleLength] = jpanel;
        ++this.mSonPanleLength;
    }

    public IMEPanel[] getSonPanel() {
        return this.mSonPanel;
    }

    public int getSonButtonLength() {
        return this.mSonButtonLength;
    }

    public int getSonPanelLength() {
        return this.mSonPanleLength;
    }

    public void setPadding(Rectangle padding) {
        this.mPadding = new Rectangle(padding);
    }

    public void setMargin(Rectangle margin) {
        this.mMargin = new Rectangle(margin);
    }

    public Rectangle getPadding() {
        return this.mPadding;
    }

    public Rectangle getMargin() {
        return this.mMargin;
    }

    public void initializeSonButtons(int size) {
        this.mSonButton = new IMEButton[size];
        this.mSonButtonLength = size;
    }
}

