/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.low;

import com.iflytek.skintool.domin.KeyGravity;
import com.iflytek.skintool.graphical.low.IMEBalloon;
import com.iflytek.skintool.graphical.low.IMEButton;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.SubKeyData;
import com.iflytek.skintool.model.pool.LayoutDataPool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.PictureUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class GravityIMEButon
extends IMEButton {
    private JLabel topLabel;
    private JLabel bottomLabel;
    private JLabel topSpaceLabel;
    private JLabel midSpaceLabel;
    private JLabel bottomSpaceLabel;
    private SubKeyData topSubKeyData;
    private SubKeyData bottomSubKeyData;

    public GravityIMEButon() {
        this.addMouseListener(new GravityIMEButtonLisenter());
    }

    @Override
    public void loadButton() {
        super.loadButton();
        if (this.mkey.getVisibleSubkeys().size() == 1) {
            this.loadSingleSubKey();
        } else {
            StyleData styleData;
            this.initiateFrame();
            int i = 0;
            while (i < this.mkey.getVisibleSubkeys().size()) {
                if (KeyGravity.isTop(this.mkey.getVisibleSubkeys().get(i).getGravity())) {
                    this.topLabel.setText(this.mkey.getVisibleSubkeys().get(i).getText());
                    this.topSubKeyData = this.mkey.getVisibleSubkeys().get(i);
                    if (ManageUtils.containChinese(this.topLabel.getText())) {
                        this.topLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
                    } else {
                        this.topLabel.setFont(new Font(this.getFont().getName(), 0, 18));
                    }
                }
                if (KeyGravity.isBottom(this.mkey.getVisibleSubkeys().get(i).getGravity())) {
                    this.bottomSubKeyData = this.mkey.getVisibleSubkeys().get(i);
                    if (this.mkey.getVisibleSubkeys().get(i).getText() != null) {
                        StyleData subStyleData = this.mkey.getVisibleSubkeys().get(i).getForegroundStyle(1);
                        int fontSize = 28;
                        if (subStyleData != null && subStyleData.getTextSize() != 0) {
                            fontSize = subStyleData.getTextSize();
                        }
                        this.bottomLabel.setText(this.mkey.getVisibleSubkeys().get(i).getText());
                        if (ManageUtils.containChinese(this.bottomLabel.getText())) {
                            this.bottomLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, fontSize));
                        } else {
                            this.bottomLabel.setFont(new Font(this.getFont().getName(), 0, fontSize));
                        }
                    }
                    if (this.mkey.getVisibleSubkeys().get(i).getImageTag() != null) {
                        this.mkey.getVisibleSubkeys().get(i).loadImage(false, this.getWidth(), (int)this.bottomLabel.getMaximumSize().getHeight());
                        if (ThemeDataPool.msubjectset.getThemeColor(1) != 0) {
                            this.bottomLabel.setIcon(PictureUtil.setImageColor(this.mkey.getVisibleSubkeys().get(i).getImageIcon(), ThemeDataPool.msubjectset.getThemeColor(1)));
                        } else {
                            this.bottomLabel.setIcon(this.mkey.getVisibleSubkeys().get(i).getImageIcon());
                        }
                    }
                }
                ++i;
            }
            ThemeKeyData themeKeyData = ThemeDataPool.msubjectset.getThemeKeyData(this.mkey.getThemeType());
            if (themeKeyData != null && (styleData = themeKeyData.getForegroundStyle(1)) != null) {
                int filteredColor = PictureUtil.getFilteredColor(this.topSubKeyData.getForegroundStyle(1).getTextColor(), styleData.getTextColor());
                this.topLabel.setForeground(new Color(PictureUtil.getRed(filteredColor), PictureUtil.getGreen(filteredColor), PictureUtil.getBlue(filteredColor), PictureUtil.getAlpha(filteredColor)));
                int filteredBottomColor = PictureUtil.getFilteredColor(this.bottomSubKeyData.getForegroundStyle(1).getTextColor(), styleData.getTextColor());
                this.bottomLabel.setForeground(new Color(PictureUtil.getRed(filteredBottomColor), PictureUtil.getGreen(filteredBottomColor), PictureUtil.getBlue(filteredBottomColor), PictureUtil.getAlpha(filteredBottomColor)));
            }
        }
    }

    private void loadSingleSubKey() {
        SubKeyData keyData = this.mkey.getVisibleSubkeys().get(0);
        if (keyData.getImageTag() != null) {
            keyData.loadImage(false, this.getWidth(), this.getHeight());
            ImageIcon resultIcon = null;
            if (ThemeDataPool.msubjectset.getThemeColor(1) != 0) {
                this.setForeImageIcon(PictureUtil.setImageColor(keyData.getImageIcon(), ThemeDataPool.msubjectset.getThemeColor(1)));
                resultIcon = LayoutDataPool.getThemeInfo().getAlpha() != 255 ? PictureUtil.getCombinPicture(PictureUtil.setImageOpacity(this.getBackgroundIcon(), LayoutDataPool.getThemeInfo().getAlpha()), this.getForeImageIcon()) : PictureUtil.getCombinPicture(this.getBackgroundIcon(), this.getForeImageIcon());
            } else {
                this.setForeImageIcon(keyData.getImageIcon());
                resultIcon = LayoutDataPool.getThemeInfo().getAlpha() != 255 ? PictureUtil.getCombinPicture(PictureUtil.setImageOpacity(this.getBackgroundIcon(), LayoutDataPool.getThemeInfo().getAlpha()), keyData.getImageIcon()) : PictureUtil.getCombinPicture(this.getBackgroundIcon(), keyData.getImageIcon());
            }
            this.setIcon(resultIcon);
        }
    }

    private void initiateFrame() {
        this.setLayout(new BoxLayout(this, 3));
        this.topSpaceLabel = new JLabel();
        this.topSpaceLabel.setMaximumSize(new Dimension(this.getWidth(), this.getHeight() / 10 - 2));
        this.topLabel = new JLabel();
        this.topLabel.setMaximumSize(new Dimension(this.getWidth(), this.getHeight() / 4 + 3));
        this.topLabel.setHorizontalAlignment(0);
        this.topLabel.setForeground(super.getForeground());
        this.midSpaceLabel = new JLabel();
        this.bottomLabel = new JLabel();
        this.bottomLabel.setMaximumSize(new Dimension(this.getWidth(), this.getHeight() * 3 / 5));
        this.bottomLabel.setHorizontalAlignment(0);
        this.bottomLabel.setForeground(super.getForeground());
        this.bottomSpaceLabel = new JLabel();
        this.bottomSpaceLabel.setMaximumSize(new Dimension(this.getWidth(), this.getHeight() / 20));
        this.add(this.topSpaceLabel);
        this.add(this.topLabel);
        this.add(this.midSpaceLabel);
        this.add(this.bottomLabel);
        this.add(this.bottomSpaceLabel);
        this.validate();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.topLabel != null) {
            this.topLabel.setForeground(fg);
        }
        if (this.bottomLabel != null) {
            this.bottomLabel.setForeground(fg);
        }
    }

    private void showButtonByState(int state) {
        ThemeKeyData themeKeyData = ThemeDataPool.msubjectset.getThemeKeyData(this.mkey.getThemeType());
        if (themeKeyData != null) {
            StyleData backStyleData;
            StyleData foreStyleData = themeKeyData.getForegroundStyle(state);
            if (foreStyleData != null && this.topLabel != null && this.bottomLabel != null) {
                int topLabelColor = PictureUtil.getFilteredColor(this.topSubKeyData.getForegroundStyle(state).getTextColor(), foreStyleData.getTextColor());
                this.topLabel.setForeground(new Color(PictureUtil.getRed(topLabelColor), PictureUtil.getGreen(topLabelColor), PictureUtil.getBlue(topLabelColor), PictureUtil.getAlpha(topLabelColor)));
                int bottomLabelColor = PictureUtil.getFilteredColor(this.bottomSubKeyData.getForegroundStyle(state).getTextColor(), foreStyleData.getTextColor());
                this.bottomLabel.setForeground(new Color(PictureUtil.getRed(bottomLabelColor), PictureUtil.getGreen(bottomLabelColor), PictureUtil.getBlue(bottomLabelColor), PictureUtil.getAlpha(bottomLabelColor)));
            }
            if ((backStyleData = themeKeyData.getBackgroundStyle(state)) != null) {
                ManageUtils.flag = true;
                backStyleData.loadImage(false, this.getWidth(), this.getHeight());
                ManageUtils.flag = false;
                ImageIcon backIcon = backStyleData.getImage();
                if (LayoutDataPool.getThemeInfo().getAlpha() != 255) {
                    backIcon = PictureUtil.setImageOpacity(backIcon, LayoutDataPool.getThemeInfo().getAlpha());
                }
                ImageIcon resultImage = backIcon;
                if (this.mkey.getVisibleSubkeys().size() == 1 && this.mkey.getVisibleSubkeys().get(0).getImageIcon() != null) {
                    resultImage = ThemeDataPool.msubjectset.getThemeColor(state) != 0 ? PictureUtil.getCombinPicture(backIcon, PictureUtil.setImageColor(this.mkey.getVisibleSubkeys().get(0).getImageIcon(), ThemeDataPool.msubjectset.getThemeColor(state))) : PictureUtil.getCombinPicture(backIcon, this.mkey.getVisibleSubkeys().get(0).getImageIcon());
                }
                this.setIcon(resultImage);
            } else {
                StyleData backStyle = this.mkey.getBackStateSet().get(1);
                if (backStyle != null && backStyle.getImageTag() != null) {
                    backStyle.loadImage(false, this.getWidth(), this.getHeight());
                    ImageIcon resultImage = backStyle.getImage();
                    if (LayoutDataPool.getThemeInfo().getAlpha() != 255) {
                        resultImage = PictureUtil.setImageOpacity(resultImage, LayoutDataPool.getThemeInfo().getAlpha());
                    }
                    if (this.mkey.getVisibleSubkeys().size() == 1 && this.mkey.getVisibleSubkeys().get(0).getImageIcon() != null) {
                        resultImage = ThemeDataPool.msubjectset.getThemeColor(state) != 0 ? PictureUtil.getCombinPicture(resultImage, PictureUtil.setImageColor(this.mkey.getVisibleSubkeys().get(0).getImageIcon(), ThemeDataPool.msubjectset.getThemeColor(state))) : PictureUtil.getCombinPicture(resultImage, this.mkey.getVisibleSubkeys().get(0).getImageIcon());
                    }
                    this.setIcon(resultImage);
                } else if (this.mkey.getVisibleSubkeys().size() == 1 && this.mkey.getVisibleSubkeys().get(0).getImageIcon() != null) {
                    if (ThemeDataPool.msubjectset.getThemeColor(state) != 0) {
                        this.setIcon(PictureUtil.setImageColor(this.mkey.getVisibleSubkeys().get(0).getImageIcon(), ThemeDataPool.msubjectset.getThemeColor(state)));
                    } else {
                        this.setIcon(this.mkey.getVisibleSubkeys().get(0).getImageIcon());
                    }
                }
            }
        }
    }

    private class GravityIMEButtonLisenter
    extends MouseAdapter {
        Timer timer = null;
        IMEBalloon imeBalloon = null;

        private GravityIMEButtonLisenter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                GravityIMEButon.this.showButtonByState(2);
                if (GravityIMEButon.this.mkey.getSubkeyWithBalloon() != null) {
                    this.timer = new Timer();
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            GravityIMEButtonLisenter.this.imeBalloon = new IMEBalloon(GravityIMEButon.this.getLocationOnScreen(), GravityIMEButon.this.topLabel.getText(), ((GravityIMEButtonLisenter)GravityIMEButtonLisenter.this).GravityIMEButon.this.mkey.getSubkeyWithBalloon());
                            GravityIMEButtonLisenter.this.imeBalloon.setVisible(true);
                        }
                    }, 100L);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                GravityIMEButon.this.showButtonByState(1);
                if (GravityIMEButon.this.mkey.getSubkeyWithBalloon() != null) {
                    this.timer.cancel();
                    if (this.imeBalloon != null) {
                        this.imeBalloon.dispose();
                    }
                }
            }
        }
    }
}

