/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.high;

import com.iflytek.skintool.domin.DisplayConst;
import com.iflytek.skintool.graphical.low.IMEPanel;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.util.ManageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;

public class ComposingPanel
extends IMEPanel {
    private JLabel compLabel = null;

    public ComposingPanel(ComposingData data) {
        this.initPanel();
        this.setComposingData(data);
        this.setOpaque(false);
    }

    private void initPanel() {
        this.compLabel = new JLabel();
        this.compLabel.setLocation(0, 0);
        this.compLabel.setSize(DisplayConst.COMPOSING_WIDTH, DisplayConst.COMPOSING_HEIGHT);
        this.compLabel.setText("NiHao");
        this.setLayout(null);
        this.add(this.compLabel);
    }

    public void setComposingData(ComposingData data) {
        StyleData foreStyleData = data.getForegroundStyle(1);
        int textSize = 28;
        Font defaultfont = null;
        if (defaultfont == null) {
            defaultfont = ManageUtils.getIMEFont();
        }
        Font iniFont = defaultfont != null ? defaultfont.deriveFont((float)textSize) : new Font("Dialog", 0, textSize);
        this.compLabel.setFont(iniFont);
        if (foreStyleData != null) {
            this.compLabel.setForeground(new Color(foreStyleData.getTextColor()));
        } else {
            this.compLabel.setForeground(Color.WHITE);
        }
        StyleData backStyleData = data.getBackgroundStyle();
        if (backStyleData != null) {
            Color backColor = new Color(backStyleData.getBgColor(), true);
            this.setBackground(backColor);
        } else {
            this.setBackgroudColor(Color.BLACK);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    public void setPyForegroundColor(Color color) {
        this.compLabel.setForeground(color);
    }
}

