/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.theme.ThemeLayoutData;
import java.util.Collection;
import java.util.TreeMap;

public class ThemeLayoutDataSerializer
extends AbstractBaseSerializer<ThemeLayoutData> {
    @Override
    public TreeMap<String, String> writeto(ThemeLayoutData data) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (data.getTypeAttr() != null) {
            attr.put("TYPE", SerializerUtil.array2str(data.getTypeAttr(), ","));
        }
        attr.put("STYLE", this.mListener.redirect(9, data.getStyleTag(), data.getStyle()));
        if (data.getShowMode() != null && data.getShowMode() != ThemeLayoutData.ShowMode.Zoom) {
            attr.put("SHOW_MODE", String.valueOf(data.getShowMode().ordinal()));
        }
        if (data.getRectZ() != null) {
            int[] rect = new int[]{data.getRectZ().mX1, data.getRectZ().mY1, data.getRectZ().mX2, data.getRectZ().mY2};
            attr.put("ZOOM_RECT", SerializerUtil.array2str(rect, ","));
        }
        return attr;
    }

    @Override
    public boolean isExist(ThemeLayoutData data) {
        if (this.mProps.size() != 0) {
            Collection values = this.mProps.values();
            String typeStr = SerializerUtil.array2str(data.getTypeAttr(), ",");
            if (typeStr == null) {
                return false;
            }
            for (TreeMap treeMap : values) {
                if (!((String)treeMap.get("TYPE")).equals(typeStr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTag(ThemeLayoutData data) {
        if (data.getmLayoutTag() != null) {
            return data.getmLayoutTag();
        }
        return "Layout_" + this.mProps.size();
    }
}

