/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StringUtil {
    public static final String CHINESE = "[\u4e00-\u9fa5]";

    public static boolean isEmpty(String str) {
        return null == str || str.trim().equals("") || str.length() == 0;
    }

    public static int getLength(String str) {
        if (StringUtil.isEmpty(str)) {
            return 0;
        }
        int strLength = 0;
        for (int i = 0; i < str.length(); ++i) {
            String temp = str.substring(i, i + 1);
            if (temp.matches(CHINESE)) {
                strLength += 2;
                continue;
            }
            ++strLength;
        }
        return strLength;
    }

    public static String reverse(String str) {
        if (null == str || "".equals(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        return sb.reverse().toString();
    }

    public static String substring(String orignal, int count) {
        if (orignal != null && !"".equals(orignal)) {
            StringBuilder result = new StringBuilder();
            int strLength = 0;
            for (int i = 0; i < orignal.length() && count >= strLength; ++i) {
                String temp = orignal.substring(i, i + 1);
                result.append(temp);
                if (temp.matches(CHINESE)) {
                    strLength += 2;
                    continue;
                }
                ++strLength;
            }
            return result.toString();
        }
        return orignal;
    }

    public static int isCnorEn(char c) {
        if (c >= '\u0391' && c <= '\uffee') {
            return 0;
        }
        if (c >= '\u0000' && c <= '\u00ff') {
            return 1;
        }
        return -1;
    }

    public static boolean chineseValid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            byte[] b = s.substring(i).getBytes();
            if ((b[0] & 0x80) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getCountOfCharCN(String str) {
        if (StringUtil.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (0 != StringUtil.isCnorEn(str.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public static String replace(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadStringFromInputStream(InputStream file, String encoding) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(file, encoding));
            StringBuilder builder = new StringBuilder();
            char[] chars = new char[4096];
            int length = 0;
            while (0 < (length = reader.read(chars))) {
                builder.append(chars, 0, length);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadStringFromFile(File file, String encoding) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuilder builder = new StringBuilder();
            char[] chars = new char[4096];
            int length = 0;
            while (0 < (length = reader.read(chars))) {
                builder.append(chars, 0, length);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

