/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import sina.mobile.tianqitong.util.FileHandler;

public class Log {
    private static final String LEVEL_VERBOSE = "VERBOSE";
    private static final String LEVEL_DEBUG = "DEBUG";
    private static final String LEVEL_INFO = "INFO";
    private static final String LEVEL_WARN = "WARN";
    private static final String LEVEL_ERROR = "ERROR";
    private static boolean mDebug = true;
    private static boolean mIsHandlerFile = false;
    private static boolean mIsHandlerConsole = true;
    private static Log mInstance = new Log();
    private static String mLogFilePath = "";
    private static String mLogFileLastName = ".log";
    private static Level mLogOutPutLevel;
    private static int mFileSize;
    private static int mFileMax;
    private static ArrayList<String> mLogList;
    private SimpleDateFormat mDateFormat = new SimpleDateFormat();

    private Log() {
    }

    public static void setDebug(boolean debug) {
        mDebug = debug;
    }

    public static void initLog(boolean isConsole, boolean isFile) {
        mIsHandlerConsole = isConsole;
        mIsHandlerFile = isFile;
    }

    public static void setLogFilePath(String path) {
        if (null != path) {
            mLogFilePath = path;
        }
    }

    public static void verbose(String info) {
        Log.setLogLevel(LEVEL_VERBOSE);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_VERBOSE, "[VERBOSE] " + info, null);
    }

    public static void debug(String info) {
        Log.setLogLevel(LEVEL_DEBUG);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_DEBUG, "[DEBUG] " + info, null);
    }

    public static void info(String info) {
        Log.setLogLevel(LEVEL_INFO);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_INFO, "[INFO] " + info, null);
    }

    public static void warn(String info) {
        Log.setLogLevel(LEVEL_WARN);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_WARN, "[WARN] " + info, null);
    }

    public static void error(String info) {
        Log.setLogLevel(LEVEL_ERROR);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_ERROR, "[ERROR] " + info, null);
    }

    public static void error(Throwable info) {
        Log.setLogLevel(LEVEL_ERROR);
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElement[2];
        mInstance.log(element, LEVEL_ERROR, "", info);
    }

    private static void setLogLevel(String level) {
        mLogOutPutLevel = Log.getLogLevelFromString(level);
    }

    private void log(StackTraceElement element, String level, String info, Throwable exception) {
        if (!mDebug) {
            return;
        }
        this.checkFileDate(level);
        Logger logger = Logger.getLogger(level);
        if (!mLogList.contains(level)) {
            mLogList.add(level);
        }
        this.dealHander(logger);
        this.dealInfoFormat(element, logger);
        logger.setLevel(mLogOutPutLevel);
        logger.log(Log.getLogLevelFromString(level), info, exception);
    }

    private static Level getLogLevelFromString(String strLevel) {
        Level l = Level.ALL;
        if (LEVEL_VERBOSE.equalsIgnoreCase(strLevel)) {
            l = Level.ALL;
        }
        if (LEVEL_INFO.equalsIgnoreCase(strLevel)) {
            l = Level.INFO;
        }
        if (LEVEL_DEBUG.equalsIgnoreCase(strLevel)) {
            l = Level.FINE;
        }
        if (LEVEL_WARN.equalsIgnoreCase(strLevel)) {
            l = Level.WARNING;
        }
        if (LEVEL_ERROR.equalsIgnoreCase(strLevel)) {
            l = Level.SEVERE;
        }
        return l;
    }

    private void dealInfoFormat(final StackTraceElement element, Logger logger) {
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            handler.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    StringBuilder formatMessage = new StringBuilder();
                    formatMessage.append(Log.this.getDateFormat("yyyy-MM-dd HH:mm:ss", new Date()));
                    formatMessage.append(" ").append(element.getFileName()).append("(Line:").append(element.getLineNumber()).append("):").append(" ").append(record.getMessage()).append("\n");
                    if (record.getThrown() != null) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            record.getThrown().printStackTrace(pw);
                            pw.close();
                            formatMessage.append(sw.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return formatMessage.toString();
                }
            });
        }
    }

    private void dealHander(Logger logger) {
        boolean alreadyHasConsole = false;
        boolean alreadyHasFile = false;
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i] instanceof ConsoleHandler) {
                alreadyHasConsole = true;
                continue;
            }
            if (!(handlers[i] instanceof FileHandler)) continue;
            alreadyHasFile = true;
        }
        if (mIsHandlerConsole && !alreadyHasConsole) {
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(mLogOutPutLevel);
            logger.addHandler(ch);
        }
        if (mIsHandlerFile && !alreadyHasFile) {
            String file = this.getLogFileName(logger.getName());
            File f = new File(mLogFilePath);
            if (!f.isDirectory()) {
                f.mkdirs();
                f.mkdir();
            }
            try {
                FileHandler fh = new FileHandler(file, mFileSize, mFileMax, true);
                fh.setLevel(mLogOutPutLevel);
                logger.addHandler(fh);
            }
            catch (IOException ex) {
                Logger.getLogger(Log.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(Log.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String getDateFormat(String pattern, Date date) {
        this.mDateFormat.applyPattern(pattern);
        return this.mDateFormat.format(date);
    }

    private void checkFileDate(String level) {
        File f = new File(this.getLogFileName(level));
        if (!f.exists()) {
            for (Handler handler : Logger.getLogger(level).getHandlers()) {
                handler.close();
            }
            mLogList.remove(level);
        }
    }

    private String getLogFileName(String level) {
        String firtFileName = mLogFilePath + level + "_" + this.getDateFormat("yyyy-MM-dd", new Date()) + mLogFileLastName;
        return firtFileName;
    }

    static {
        mFileSize = 2000000;
        mFileMax = 10;
        mLogList = new ArrayList();
    }
}

