/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import sina.mobile.tianqitong.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String queryString, String charset, boolean pretty) {
        StringBuilder response = new StringBuilder();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            if (null != queryString && !"".equals(queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            client.executeMethod((HttpMethod)method);
            Log.info(url + method.getQueryString());
            if (method.getStatusCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), charset));
                while ((line = reader.readLine()) != null) {
                    if (pretty) {
                        response.append(line).append(System.getProperty("line.separator"));
                        continue;
                    }
                    response.append(line);
                }
                reader.close();
            }
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, String charset, boolean pretty) {
        StringBuilder response = new StringBuilder();
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        if (params != null) {
            HttpMethodParams p = new HttpMethodParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                p.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            method.setParams(p);
        }
        try {
            client.executeMethod((HttpMethod)method);
            Log.info(url);
            if (method.getStatusCode() == 200) {
                String line;
                InputStreamReader isr = new InputStreamReader(method.getResponseBodyAsStream(), charset);
                BufferedReader reader = new BufferedReader(isr);
                while ((line = reader.readLine()) != null) {
                    if (pretty) {
                        response.append(line).append(System.getProperty("line.separator"));
                        continue;
                    }
                    response.append(line);
                }
                reader.close();
                isr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return response.toString();
    }

    public static String doPost(String url, List<NameValuePair> params) throws UnsupportedEncodingException, IOException {
        String result = "";
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)httppost);
        Header header = response.getFirstHeader("Content-Length");
        String Length = header.getValue();
        Log.info("Url is : " + url);
        Log.info("Header Length is : " + header);
        if (response.getStatusLine().getStatusCode() == 200) {
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            result = new String(result.getBytes("ISO-8859-1"), "UTF-8");
        }
        return result;
    }
}

