/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class FileHandler
extends StreamHandler {
    private static final int MAX_LOCKS = 100;
    private static HashMap<String, String> locks = new HashMap();
    private MeteredStream mMeter;
    private boolean isAppend;
    private int mLimit;
    private int mCount;
    private String mPattern;
    private String mLockFileName;
    private FileOutputStream mLockStream;
    private File[] mFiles;

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.mMeter = new MeteredStream(bout, len);
        this.setOutputStream(this.mMeter);
    }

    public FileHandler() throws IOException, SecurityException {
        this.openFiles();
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.mPattern = pattern;
        this.mLimit = 0;
        this.mCount = 1;
        this.openFiles();
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.mPattern = pattern;
        this.mLimit = 0;
        this.mCount = 1;
        this.isAppend = append;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.mPattern = pattern;
        this.mLimit = limit;
        this.mCount = count;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.mPattern = pattern;
        this.mLimit = limit;
        this.mCount = count;
        this.isAppend = append;
        this.openFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFiles() throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.checkAccess();
        if (this.mCount < 1) {
            throw new IllegalArgumentException("file count = " + this.mCount);
        }
        if (this.mLimit < 0) {
            this.mLimit = 0;
        }
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        int unique = -1;
        while (true) {
            if (++unique > 100) {
                throw new IOException("Couldn't get lock for " + this.mPattern);
            }
            this.mLockFileName = this.generate(this.mPattern, 0, unique).toString() + ".lck";
            HashMap<String, String> hashMap = locks;
            synchronized (hashMap) {
                FileChannel fc;
                if (locks.get(this.mLockFileName) != null) {
                    continue;
                }
                try {
                    this.mLockStream = new FileOutputStream(this.mLockFileName);
                    fc = this.mLockStream.getChannel();
                }
                catch (IOException ix) {
                    continue;
                }
                try {
                    FileLock fl = fc.tryLock();
                    if (fl != null) break;
                }
                catch (IOException ix) {
                    // empty catch block
                    break;
                }
            }
        }
        {
            locks.put(this.mLockFileName, this.mLockFileName);
        }
        this.mFiles = new File[this.mCount];
        for (int i = 0; i < this.mCount; ++i) {
            this.mFiles[i] = this.generate(this.mPattern, i, unique);
        }
        if (this.isAppend) {
            this.open(this.mFiles[0], true);
        } else {
            this.rotate();
        }
        Exception ex = em.lastException;
        if (ex == null) {
            this.setErrorManager(new ErrorManager());
            return;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof SecurityException) {
            throw (SecurityException)ex;
        }
        throw new IOException("Exception: " + ex);
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (FileHandler.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (this.mCount > 1 && generation > 0 && !sawg) {
            word = word + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = word + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        for (int i = this.mCount - 2; i >= 0; --i) {
            File f1 = this.mFiles[i];
            File f2 = this.mFiles[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            f1.renameTo(f2);
        }
        try {
            this.open(this.mFiles[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.mLimit > 0 && this.mMeter.written >= this.mLimit) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.mLockFileName == null) {
            return;
        }
        try {
            this.mLockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.mLockFileName);
        }
        new File(this.mLockFileName).delete();
        this.mLockFileName = null;
        this.mLockStream = null;
    }

    private static native boolean isSetUID();

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

