/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin.skinframework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import sina.mobile.tianqitong.skin.skinframework.SkinFramework;
import sina.mobile.tianqitong.skin.skinframework.SkinResolution;
import sina.mobile.tianqitong.util.Log;

public class SkinFrameworkHelper {
    private static final File SKIN_CONFIG_FILE = new File("resource" + File.separator + "SkinRect.xml");
    private static final String TYOE_NODE = "Type";
    private static final String RESOLUTIONS_NODE = "Resolutions";
    private static final String RESOLUTION_NODE = "Resolution";
    private static HashMap<String, SkinFramework> mSkinFrameworkMap = new HashMap();

    public static void readConfig() {
        try {
            FileReader fileReader = new FileReader(SKIN_CONFIG_FILE);
            BufferedReader br = new BufferedReader(fileReader);
            StringBuilder sb = new StringBuilder();
            String tempStr = "";
            while ((tempStr = br.readLine()) != null) {
                sb.append(tempStr);
            }
            Document document = DocumentHelper.parseText(sb.toString());
            Element element = document.getRootElement();
            SkinFrameworkHelper.parseType(element);
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static SkinFramework getSkinFramework(String skinType) {
        SkinFramework sf = null;
        if (mSkinFrameworkMap.containsKey(skinType)) {
            sf = mSkinFrameworkMap.get(skinType);
        }
        return sf;
    }

    private static void parseType(Element root) {
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element type = (Element)iterator.next();
            if (!TYOE_NODE.equals(type.getName())) continue;
            SkinFramework sf = new SkinFramework();
            HashMap<String, SkinResolution> resolutionMap = new HashMap<String, SkinResolution>();
            Iterator iter = type.elementIterator();
            while (iter.hasNext()) {
                Element resolutions = (Element)iter.next();
                if (!RESOLUTIONS_NODE.equals(resolutions.getName())) continue;
                Iterator it = resolutions.elementIterator();
                while (it.hasNext()) {
                    Element resolution = (Element)it.next();
                    if (!RESOLUTION_NODE.equals(resolution.getName())) continue;
                    SkinResolution sr = new SkinResolution();
                    sr.setName(resolution.attributeValue("Name"));
                    sr.setX(Integer.parseInt(resolution.attributeValue("X")));
                    sr.setY(Integer.parseInt(resolution.attributeValue("Y")));
                    sr.setWidth(Integer.parseInt(resolution.attributeValue("Width")));
                    sr.setHeight(Integer.parseInt(resolution.attributeValue("Height")));
                    resolutionMap.put(resolution.attributeValue("Name"), sr);
                }
            }
            String frameName = type.attributeValue("Name");
            sf.setName(frameName);
            sf.setWidth(Integer.parseInt(type.attributeValue("Width")));
            sf.setHeight(Integer.parseInt(type.attributeValue("Height")));
            String orientation = type.attributeValue("Orientation");
            sf.setOrientation(orientation);
            sf.setSkinResolutions(resolutionMap);
            mSkinFrameworkMap.put(frameName + "_" + orientation, sf);
        }
    }

    public static void print() {
        for (Map.Entry<String, SkinFramework> entry : mSkinFrameworkMap.entrySet()) {
            SkinFramework sf = entry.getValue();
            Log.info(sf.toString());
            for (Map.Entry<String, SkinResolution> e : sf.getSkinResolutions().entrySet()) {
                SkinResolution sr = e.getValue();
                Log.info(sr.toString());
            }
        }
    }
}

