/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin.skinframework;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import sina.mobile.tianqitong.skin.skinframework.SkinFramework;
import sina.mobile.tianqitong.skin.skinframework.SkinFrameworkHelper;
import sina.mobile.tianqitong.skin.skinframework.SkinResolution;

public abstract class AbSkinFramework {
    public Rectangle getSkinRect() {
        Rectangle skinRect = new Rectangle();
        String skinType = this.getSkinTypeString();
        SkinFramework sf = SkinFrameworkHelper.getSkinFramework(skinType);
        skinRect.width = sf.getWidth();
        skinRect.height = sf.getHeight();
        return skinRect;
    }

    public Rectangle getRealSkinRect(String resolution) {
        Rectangle skinRect = new Rectangle();
        String skinType = this.getSkinTypeString();
        SkinFramework sf = SkinFrameworkHelper.getSkinFramework(skinType);
        HashMap<String, SkinResolution> resolutionMap = sf.getSkinResolutions();
        if (resolutionMap.containsKey(resolution)) {
            skinRect.x = resolutionMap.get(resolution).getX();
            skinRect.y = resolutionMap.get(resolution).getY();
            skinRect.width = resolutionMap.get(resolution).getWidth();
            skinRect.height = resolutionMap.get(resolution).getHeight();
        }
        return skinRect;
    }

    public abstract int getSkinButtonCount();

    public abstract Rectangle getRectByButtonIdx(int var1);

    public abstract Point getSkinOffsetPoint();

    public abstract int getScreenOrientation();

    public abstract int getScreenWidgetType();

    public abstract int getButtonFrame();

    private String getSkinTypeString() {
        StringBuilder skinType = new StringBuilder();
        switch (this.getScreenWidgetType()) {
            case 1: {
                skinType.append("4x1");
                break;
            }
            case 0: {
                skinType.append("4x2");
                break;
            }
            case 3: {
                skinType.append("5x1");
                break;
            }
            case 2: {
                skinType.append("5x2");
            }
        }
        skinType.append("_");
        switch (this.getScreenOrientation()) {
            case 0: {
                skinType.append("Port");
                break;
            }
            case 1: {
                skinType.append("Land");
            }
        }
        return skinType.toString();
    }
}

