/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin.moji;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import sina.mobile.tianqitong.skin.moji.DrawPicture;
import sina.mobile.tianqitong.skin.moji.DrawSetting;
import sina.mobile.tianqitong.skin.moji.DrawText;
import sina.mobile.tianqitong.skin.moji.Layout;
import sina.mobile.tianqitong.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojiWidget
extends Layout {
    private String mName = "";
    private String mAuthor = "";
    private String mDescription = "";
    private String mDirectoryName = "";
    private String mSkinVersion = "";
    private String mSkinEngineVersion = "";
    private String mDir = "";
    private ArrayList<DrawSetting> mDrawSettings = new ArrayList();

    public MojiWidget(String dir) {
        this.mDir = dir;
    }

    public String getDir() {
        return this.mDir;
    }

    public ArrayList<DrawSetting> getDrawSettings() {
        return this.mDrawSettings;
    }

    public void addDrawSetting(DrawSetting set) {
        this.mDrawSettings.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseLayoutXml() throws XmlPullParserException, IOException {
        ArrayList<Layout> out = new ArrayList<Layout>();
        File layoutFile = new File(this.mDir, "setting.xml");
        if (!layoutFile.exists()) {
            out.clear();
            return;
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(layoutFile));
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(bis, null);
            int eventType = xpp.getEventType();
            DrawSetting currentSetting = null;
            block10: while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        Layout aslu = null;
                        if (xpp.getName().equals("SingleScreenSetting")) {
                            aslu = new DrawSetting();
                            currentSetting = aslu;
                            this.addDrawSetting((DrawSetting)aslu);
                        } else if (xpp.getName().equals("DrawText")) {
                            aslu = new DrawText();
                            currentSetting.addDrawText((DrawText)aslu);
                        } else if (xpp.getName().equals("DrawPicture")) {
                            aslu = new DrawPicture();
                            currentSetting.addDrawPicture((DrawPicture)aslu);
                        } else if (xpp.getName().equals("SkinInformation")) {
                            aslu = this;
                        } else {
                            eventType = xpp.next();
                            continue block10;
                        }
                        if (aslu == null) continue block10;
                        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                            String attrValue;
                            String attrName = xpp.getAttributeName(i);
                            if (aslu.setValue(attrName, attrValue = xpp.getAttributeValue(i))) continue;
                        }
                        out.add(aslu);
                    }
                }
                eventType = xpp.next();
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public void setAuthor(String author) {
        this.mAuthor = author;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDirectoryName() {
        return this.mDirectoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.mDirectoryName = directoryName;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getSkinEngineVersion() {
        return this.mSkinEngineVersion;
    }

    public void setSkinEngineVersion(String skinEngineVersion) {
        this.mSkinEngineVersion = skinEngineVersion;
    }

    public String getSkinVersion() {
        return this.mSkinVersion;
    }

    public void setSkinVersion(String skinVersion) {
        this.mSkinVersion = skinVersion;
    }

    @Override
    public boolean setValue(String key, String value) {
        Log.info("SkinInformation ->" + key + ":" + value);
        if (key.equals("Name")) {
            this.setName(value);
        }
        if (key.equals("Author")) {
            this.setAuthor(value);
        }
        if (key.equals("Description")) {
            this.setDescription(value);
        }
        if (key.equals("DirectoryName")) {
            this.setDirectoryName(value);
        }
        if (key.equals("SkinVersion")) {
            this.setSkinVersion(value);
        }
        if (key.equals("SkinEngineVersion")) {
            this.setSkinEngineVersion(value);
        }
        return true;
    }
}

