/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.skin.SkinCfg;
import sina.mobile.tianqitong.skin.skinframework.AbSkinFramework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinPkg {
    public static final int G480X800 = 1;
    public static final int G480X854 = 2;
    public static final int G480X640 = 4;
    public static final int G640X960 = 8;
    public static final int G540X960 = 16;
    public static final int G320X480 = 32;
    public static final int G720X1280 = 64;
    public static final int G800X1280 = 128;
    private File mSkinFile;
    private SkinCfg mSkinCfg;
    private SkinAdapter mLandSkinAdapter;
    private SkinAdapter mPortSkinAdapter;
    private AbSkinFramework mSkinFramework;
    private int mCheck = 1;
    private static final HashMap<String, Boolean> mIsDependMap = new HashMap(8);

    public void recycle() {
        this.mSkinFramework = null;
        this.mSkinCfg = null;
        this.mSkinFile = null;
        if (this.mLandSkinAdapter != null) {
            this.mLandSkinAdapter.recycle();
        }
        this.mLandSkinAdapter = null;
        if (this.mPortSkinAdapter != null) {
            this.mPortSkinAdapter.recycle();
        }
        this.mPortSkinAdapter = null;
    }

    public AbSkinFramework getSkinFramework() {
        return this.mSkinFramework;
    }

    public void setSkinFramework(AbSkinFramework skinFramework) {
        this.mSkinFramework = skinFramework;
    }

    public void addCheck(int type) {
        this.mCheck |= type;
    }

    public ArrayList<String> getNotCheck() {
        ArrayList<String> notChecks = new ArrayList<String>();
        if ((this.mCheck & 1) == 0) {
            notChecks.add("480X800");
        }
        if ((this.mCheck & 2) == 0) {
            notChecks.add("480X854");
        }
        if ((this.mCheck & 4) == 0) {
            notChecks.add("480X640");
        }
        if ((this.mCheck & 8) == 0) {
            notChecks.add("640X960");
        }
        if ((this.mCheck & 0x10) == 0) {
            notChecks.add("540X960");
        }
        if ((this.mCheck & 0x20) == 0) {
            notChecks.add("320X480");
        }
        if ((this.mCheck & 0x40) == 0) {
            notChecks.add("720X1280");
        }
        if ((this.mCheck & 0x80) == 0) {
            notChecks.add("800X1280");
        }
        return notChecks;
    }

    public boolean isAllChecked() {
        boolean result = false;
        if ((this.mCheck & 1) != 0 && (this.mCheck & 2) != 0 && (this.mCheck & 4) != 0 && (this.mCheck & 8) != 0 && (this.mCheck & 0x10) != 0 && (this.mCheck & 0x20) != 0 && (this.mCheck & 0x40) != 0 && (this.mCheck & 0x80) != 0) {
            result = true;
        }
        return result;
    }

    public static void putIsDepend(String resolution, boolean bool) {
        mIsDependMap.put(resolution, bool);
    }

    public static boolean isDepend(String resolution) {
        return mIsDependMap.get(resolution);
    }

    public SkinAdapter getLandSkinAdapter() {
        return this.mLandSkinAdapter;
    }

    public void setLandSkinAdapter(SkinAdapter landSkinAdapter) {
        this.mLandSkinAdapter = landSkinAdapter;
    }

    public SkinAdapter getPortSkinAdapter() {
        return this.mPortSkinAdapter;
    }

    public void setPortSkinAdapter(SkinAdapter portSkinAdapter) {
        this.mPortSkinAdapter = portSkinAdapter;
    }

    public SkinCfg getSkinCfg() {
        return this.mSkinCfg;
    }

    public void setSkinCfg(SkinCfg skinCfg) {
        this.mSkinCfg = skinCfg;
    }

    public File getSkinFile() {
        return this.mSkinFile;
    }

    public void setSkinFile(File skinFile) {
        this.mSkinFile = skinFile;
    }

    static {
        mIsDependMap.put(Config.RESOLUTION[0], true);
        mIsDependMap.put(Config.RESOLUTION[1], false);
        mIsDependMap.put(Config.RESOLUTION[2], false);
        mIsDependMap.put(Config.RESOLUTION[3], false);
        mIsDependMap.put(Config.RESOLUTION[4], false);
        mIsDependMap.put(Config.RESOLUTION[5], false);
        mIsDependMap.put(Config.RESOLUTION[6], false);
        mIsDependMap.put(Config.RESOLUTION[7], false);
    }
}

