/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import sina.mobile.tianqitong.util.BufferedImagePool;

public class ImagePreview {
    private BufferedImage mSourceImage;
    private Image mShowImage;
    private File mSourceImageFile;
    private String mName = "\u672a\u547d\u540d\u7684\u56fe\u7247\u6587\u4ef6";
    private String mTag = null;

    public String getTag() {
        return this.mTag;
    }

    public void setTag(String mTag) {
        this.mTag = mTag;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void recycle() {
        this.mSourceImage = null;
        this.mShowImage = null;
        this.mSourceImageFile = null;
        this.mName = "\u672a\u547d\u540d\u7684\u56fe\u7247\u6587\u4ef6";
        this.mTag = null;
    }

    public BufferedImage getSourceImage() {
        return this.mSourceImage;
    }

    public void setSourceImage(BufferedImage sourceImage) {
        this.mSourceImage = sourceImage;
    }

    public File getSourceImageFile() {
        return this.mSourceImageFile;
    }

    public void setSourceImageFile(File file) throws IOException {
        this.mSourceImageFile = file;
        this.mSourceImage = BufferedImagePool.getImage(file.getAbsolutePath());
    }

    public void paintPreview(Graphics g, int x, int y, int w, int h) {
        if (this.mSourceImage == null) {
            return;
        }
        if (this.mSourceImage.getWidth() <= w && this.mSourceImage.getHeight() <= h) {
            this.mShowImage = this.mSourceImage;
        } else if (this.mSourceImage.getWidth() <= w && this.mSourceImage.getHeight() > h) {
            double ratio = (double)this.mSourceImage.getHeight() * 1.0 / (double)this.mSourceImage.getWidth();
            int newW = Math.max(1, (int)((double)h / ratio));
            this.mShowImage = this.mSourceImage.getScaledInstance(newW, h, 2);
        } else if (this.mSourceImage.getWidth() > w && this.mSourceImage.getHeight() <= h) {
            double ratio = (double)this.mSourceImage.getWidth() * 1.0 / (double)this.mSourceImage.getHeight();
            int newH = Math.max(1, (int)((double)w / ratio));
            this.mShowImage = this.mSourceImage.getScaledInstance(w, newH, 2);
        } else if (this.mSourceImage.getWidth() > w && this.mSourceImage.getHeight() > h) {
            if (this.mSourceImage.getWidth() > this.mSourceImage.getHeight()) {
                double ratio = (double)this.mSourceImage.getWidth() * 1.0 / (double)this.mSourceImage.getHeight();
                int newH = Math.max(1, (int)((double)w / ratio));
                this.mShowImage = this.mSourceImage.getScaledInstance(w, newH, 2);
            } else if (this.mSourceImage.getWidth() == this.mSourceImage.getHeight()) {
                this.mShowImage = this.mSourceImage.getScaledInstance(w, h, 2);
            } else {
                double ratio = (double)this.mSourceImage.getHeight() * 1.0 / (double)this.mSourceImage.getWidth();
                int newW = Math.max(1, (int)((double)h / ratio));
                this.mShowImage = this.mSourceImage.getScaledInstance(newW, h, 2);
            }
        }
        g.drawImage(this.mShowImage, x + (w - this.mShowImage.getWidth(null)) / 2, y + (h - this.mShowImage.getHeight(null)) / 2, null);
    }
}

