/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinRender;
import sina.mobile.tianqitong.SkinPreviewDialog;
import sina.mobile.tianqitong.adapter.PictureAdapter;
import sina.mobile.tianqitong.adapter.RenderAdapter;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.adapter.SkinButtonAdapter;
import sina.mobile.tianqitong.adapter.SkinUnitAdapter;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.observer.Event;
import sina.mobile.tianqitong.observer.Observer;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.Log;

public class SkinResolutionPreviewPanel
extends JPanel
implements MouseListener,
Observer {
    private int mValue = -1;
    private SkinPreviewDialog mSkinPreviewDialog = null;
    private SkinPkg mSkinPkg = null;
    private Graphics2D mG2d = null;
    private BufferedImage mSkinBufferImage = null;
    private int mTouchableOffsetX = 0;
    private int mTouchableOffsetY = 0;
    private Rectangle mSkinRect = new Rectangle();
    private Rectangle mSkinRealRect = new Rectangle();
    private boolean mIsPort = true;
    private String mResolution = Config.RESOLUTION[6];
    private boolean mIsLoading = false;
    private boolean mHasClick = false;
    private boolean mAllLoadEnd = false;

    public SkinResolutionPreviewPanel(SkinPreviewDialog skinPreviewDialog, int value) {
        this.initComponents();
        this.addMouseListener(this);
        this.mSkinPreviewDialog = skinPreviewDialog;
        this.mValue = value;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 225);
    }

    public boolean isLoading() {
        return this.mIsLoading;
    }

    public void setIsLoading(boolean mIsLoading) {
        this.mIsLoading = mIsLoading;
        this.updateUI();
    }

    public void setSkinPkg(SkinPkg pkg, boolean isPort) {
        this.mSkinPkg = pkg;
        this.mIsPort = isPort;
        this.repaintSkin();
    }

    public boolean isPortait() {
        return this.isPortait();
    }

    public SkinPkg getSkinPkg() {
        return this.mSkinPkg;
    }

    public String getResolution() {
        return this.mResolution;
    }

    public void setResolution(String resolution) {
        this.mResolution = resolution;
    }

    private void measureSkinRealRect() {
        if (this.mSkinPkg == null) {
            return;
        }
        String resolution = this.mResolution.split(" ")[0];
        this.mSkinRealRect.x = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).x);
        this.mSkinRealRect.y = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).y);
        this.mSkinRealRect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).width);
        this.mSkinRealRect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).height);
    }

    private void measureSkinRect() {
        if (this.mSkinPkg == null) {
            return;
        }
        this.mSkinRect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinRect().width);
        this.mSkinRect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinRect().height);
    }

    private void measureSkinOffset() {
        if (this.mSkinPkg == null) {
            return;
        }
        this.mTouchableOffsetX = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinOffsetPoint().x);
        this.mTouchableOffsetY = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinOffsetPoint().y);
    }

    private Rectangle getRectangleByIdx(int idx) {
        Rectangle rect = new Rectangle();
        if (this.mSkinPkg == null) {
            return rect;
        }
        rect.x = this.mTouchableOffsetX + SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).x);
        rect.y = this.mTouchableOffsetY + SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).y);
        rect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).width);
        rect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).height);
        return rect;
    }

    public int getSkinButtonCount() {
        if (this.mSkinPkg == null) {
            return 0;
        }
        int count = this.mSkinPkg.getSkinFramework().getSkinButtonCount();
        return count;
    }

    public void repaintSkin() {
        if (this.mSkinPkg == null) {
            return;
        }
        this.measureSkinRect();
        this.measureSkinRealRect();
        this.measureSkinOffset();
        this.mSkinBufferImage = new BufferedImage(this.mSkinRect.width, this.mSkinRect.height, 2);
        if (this.mSkinPkg != null) {
            this.mG2d = this.mSkinBufferImage.createGraphics();
            RenderAdapter iRender = new RenderAdapter();
            iRender.setGraphics2D(this.mG2d);
            SkinRender skinRender = new SkinRender();
            skinRender.setRender(iRender);
            SkinAdapter adapter = null;
            adapter = this.mIsPort ? this.mSkinPkg.getPortSkinAdapter() : this.mSkinPkg.getLandSkinAdapter();
            Skin skin = adapter.getSkin();
            skin.draw(skinRender);
            this.drawButton(adapter);
            adapter.measureSkinUnitAdapterRect();
        }
        this.mIsLoading = false;
        this.updateUI();
    }

    private void drawButton(SkinAdapter adapter) {
        SkinAdapter skinAdapter = adapter;
        if (skinAdapter == null) {
            return;
        }
        for (int i = 0; i < skinAdapter.skinUnitAdapterCount(); ++i) {
            Rectangle rect;
            BufferedImage src;
            SkinButton button;
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinButtonAdapter) || (button = (SkinButton)unit.getSkinUnit()).getFunctionId().equals("app") && button.getIntoClock() == null || ((SkinButtonAdapter)unit).getSkinUnit().getIdx() < 0 || ((SkinButtonAdapter)unit).getSkinUnit().getIdx() >= this.getSkinButtonCount()) continue;
            if (!((SkinButtonAdapter)unit).isClicked() && button.getSrc() != null) {
                src = ((PictureAdapter)button.getSrcCachePicture().getPicture()).getBufferedImage();
                rect = this.getRectangleByIdx(button.getIdx());
                this.mG2d.drawImage(src, rect.x, rect.y, button.getPictureRect().width(), button.getPictureRect().height(), null);
                continue;
            }
            if (button.getStopPlayingSrc() == null) continue;
            src = ((PictureAdapter)button.getStopPlayingSrcCachePicture().getPicture()).getBufferedImage();
            rect = this.getRectangleByIdx(button.getIdx());
            this.mG2d.drawImage(src, rect.x, rect.y, button.getPictureRect().width(), button.getPictureRect().height(), null);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Colors.LIGHT_AREA);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g;
        if (this.mIsLoading) {
            this.drawLoading(g2);
        } else if (this.mSkinPkg != null) {
            if (this.mSkinBufferImage != null) {
                this.drawSkinRealBufferImage(g2, 0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            this.drawWaiting(g2);
        }
    }

    private void drawLoading(Graphics2D g2) {
        g2.setColor(Color.BLACK);
        String loadingText = "\u6b63\u5728\u52a0\u8f7d";
        Font f = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 32);
        int width = SwingUtilities.computeStringWidth(Toolkit.getDefaultToolkit().getFontMetrics(f), loadingText);
        g2.drawString(loadingText, (this.getWidth() - width) / 2 + 32, this.getHeight() / 2 - 32);
    }

    private void drawWaiting(Graphics2D g2) {
        g2.setColor(Color.BLACK);
        String loadingText = "\u7b49\u5f85\u52a0\u8f7d";
        Font f = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 32);
        int width = SwingUtilities.computeStringWidth(Toolkit.getDefaultToolkit().getFontMetrics(f), loadingText);
        g2.drawString(loadingText, (this.getWidth() - width) / 2 + 32, this.getHeight() / 2 - 32);
    }

    private void drawSkinRealBufferImage(Graphics2D g2, int x, int y, int w, int h) {
        BufferedImage mSourceImage = this.getSkinRealBufferImage();
        if (mSourceImage == null) {
            return;
        }
        Image mShowImage = null;
        if (mSourceImage.getWidth() <= w && mSourceImage.getHeight() <= h) {
            mShowImage = mSourceImage;
        } else if (mSourceImage.getWidth() <= w && mSourceImage.getHeight() > h) {
            double ratio = (double)mSourceImage.getHeight() * 1.0 / (double)mSourceImage.getWidth();
            int newW = Math.max(1, (int)((double)h / ratio));
            mShowImage = mSourceImage.getScaledInstance(newW, h, 2);
        } else if (mSourceImage.getWidth() > w && mSourceImage.getHeight() <= h) {
            double ratio = (double)mSourceImage.getWidth() * 1.0 / (double)mSourceImage.getHeight();
            int newH = Math.max(1, (int)((double)w / ratio));
            mShowImage = mSourceImage.getScaledInstance(w, newH, 2);
        } else if (mSourceImage.getWidth() > w && mSourceImage.getHeight() > h) {
            if (mSourceImage.getWidth() > mSourceImage.getHeight()) {
                double ratio = (double)mSourceImage.getWidth() * 1.0 / (double)mSourceImage.getHeight();
                int newH = Math.max(1, (int)((double)w / ratio));
                mShowImage = mSourceImage.getScaledInstance(w, (int)((double)w / ratio), 2);
            } else if (mSourceImage.getWidth() == mSourceImage.getHeight()) {
                mShowImage = mSourceImage.getScaledInstance(w, h, 2);
            } else {
                double ratio = (double)mSourceImage.getHeight() * 1.0 / (double)mSourceImage.getWidth();
                int newW = Math.max(1, (int)((double)h / ratio));
                mShowImage = mSourceImage.getScaledInstance((int)((double)h / ratio), h, 2);
            }
        }
        g2.drawImage(mShowImage, x + (w - ((Image)mShowImage).getWidth(null)) / 2, y + (h - ((Image)mShowImage).getHeight(null)) / 2, null);
    }

    public BufferedImage getSkinBufferImage() {
        return this.mSkinBufferImage;
    }

    public BufferedImage getSkinRealBufferImage() {
        if (this.mSkinBufferImage == null) {
            return null;
        }
        return this.mSkinBufferImage.getSubimage(this.mSkinRealRect.x, this.mSkinRealRect.y, this.mSkinRealRect.width, this.mSkinRealRect.height);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        Log.info("\u70b9\u51fb\u9884\u89c8\u56fe\uff0c\u5206\u8fa8\u7387\uff1a" + this.mResolution);
        if (this.mSkinPkg != null && !this.mIsLoading) {
            this.mHasClick = true;
        }
        if (this.mAllLoadEnd) {
            this.disposeSkinPreviewDialog();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.getCommand().equals("load_all_end")) {
            this.mAllLoadEnd = true;
        } else if (event.getCommand().equals("load_end") && this.mHasClick) {
            this.disposeSkinPreviewDialog();
        }
    }

    private void disposeSkinPreviewDialog() {
        this.mSkinPreviewDialog.setCanLoad(false);
        this.mSkinPreviewDialog.setResultValue(this.mValue);
        this.mSkinPreviewDialog.setResultSkinPkg(this.mSkinPkg);
        this.mSkinPreviewDialog.dispose();
    }

    public void recycle() {
        if (this.mSkinPkg != null) {
            this.mSkinPkg.recycle();
        }
        this.mSkinPkg = null;
        this.mG2d = null;
        this.mSkinBufferImage = null;
    }
}

