/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.material.MaterialButton;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.StringUtil;

public class MaterialPkgPanel
extends JPanel {
    private MaterialButton materialImageButton;
    private JLabel materialNameLabel;

    public MaterialPkgPanel() {
        this.initComponents();
    }

    public MaterialButton getMaterialButton() {
        return this.materialImageButton;
    }

    public void setMaterial(MaterialPkg material) {
        if (material == null || material.getFile() == null || !material.getFile().exists()) {
            this.materialNameLabel.setText("\u7d20\u6750\u5305\u65e0\u6548");
        } else {
            this.materialImageButton.setMaterialPkg(material);
            String name = FileUtil.getNameWithoutExten(material.getFile()).split("-")[0];
            this.setToolTipText(name);
            if (StringUtil.getLength(name) > 10) {
                name = StringUtil.substring(name, 9) + "...";
            }
            this.materialNameLabel.setText(name);
        }
    }

    private void initComponents() {
        this.materialImageButton = new MaterialButton();
        this.materialNameLabel = new JLabel();
        this.setBackground(Colors.LIGHT_AREA);
        this.materialImageButton.setBackground(Colors.LIGHT_AREA);
        this.materialNameLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        this.materialNameLabel.setForeground(new Color(255, 255, 255));
        this.materialNameLabel.setHorizontalAlignment(0);
        this.materialNameLabel.setText("\u672a\u77e5\u7d20\u6750\u5305");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.materialImageButton, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.materialNameLabel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.materialImageButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.materialNameLabel, -2, 17, -2)));
    }
}

