/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.constants.Constants;
import sina.mobile.tianqitong.listener.PhoneWallpaperListener;
import sina.mobile.tianqitong.listener.SkinUnitPreviewListener;
import sina.mobile.tianqitong.observer.Notifier;
import sina.mobile.tianqitong.skin.ImagePreview;
import sina.mobile.tianqitong.skin.MaterialPkgPreview;
import sina.mobile.tianqitong.skin.SkinUnitPreview;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePreviewPane
extends JPanel
implements Scrollable,
MouseListener,
KeyListener {
    private ArrayList<ImagePreview> mImgPreviews = new ArrayList();
    private ArrayList<SkinUnitPreviewListener> mSkinImagePreviewListeners = new ArrayList();
    private PhoneWallpaperListener mPhoneWallpaperListener = null;
    private static final int IMG_INTERVAL = 4;
    private static final int IMG_Y = 12;
    private static final int IMG_WIDTH = 100;
    private static final int IMG_HEIGHT = 100;
    private ImagePreview mSelectedFile;
    private BufferedImage mDeleteBtnBg = null;

    public ImagePreviewPane() {
        this.initComponents();
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void setPhoneWallpaperListener(PhoneWallpaperListener phoneWallpaperListener) {
        this.mPhoneWallpaperListener = phoneWallpaperListener;
    }

    public void addSkinUnitPreviewListener(SkinUnitPreviewListener skinImagePreviewListener) {
        this.mSkinImagePreviewListeners.add(skinImagePreviewListener);
    }

    public void removeSkinUnitPreviewListener(SkinUnitPreviewListener skinImagePreviewListener) {
        this.mSkinImagePreviewListeners.remove(skinImagePreviewListener);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(4 + this.mImgPreviews.size() * 104, 120);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height / 32 * 32;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            g.setColor(Colors.LIGHT_AREA);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Graphics2D graphics2D = null;
            int index = -1;
            for (int i = 0; i < this.mImgPreviews.size(); ++i) {
                ImagePreview pic = this.mImgPreviews.get(i);
                if (pic == null) continue;
                pic.paintPreview(g, 4 + i * 104, 12, 100, 100);
                if (this.mSelectedFile != null && this.mSelectedFile.getTag().equals(pic.getTag())) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setStroke(new BasicStroke(2.0f, 0, 0));
                    g2.setColor(new Color(6904269));
                    g2.drawRect(4 + i * 104, 12, 100, 100);
                    graphics2D = g2;
                    index = i;
                }
                g.setColor(Color.WHITE);
                String name = pic.getName();
                if (name.endsWith(".png") || name.endsWith(".jpg")) {
                    name = name.substring(0, name.length() - 4);
                }
                if (StringUtil.getLength(name) > 16) {
                    name = StringUtil.substring(name, 13) + "...";
                }
                Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
                int textWidth = SwingUtilities.computeStringWidth(Toolkit.getDefaultToolkit().getFontMetrics(font), name);
                g.drawString(name, (100 - textWidth) / 2 + 4 + i * 104, 124);
            }
            if (null != this.mSelectedFile && null != graphics2D && index != -1) {
                this.drawDeleteButton(graphics2D, index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDeleteButton(Graphics2D g2, int i) {
        if (this.mSelectedFile.getTag().contains("PhonePaperImage_")) {
            InputStream in = this.getClass().getResourceAsStream("/sina/mobile/tianqitong/resources/delete.png");
            try {
                this.mDeleteBtnBg = ImageIO.read(in);
                g2.drawImage(this.mDeleteBtnBg, null, 4 + i * 104 + 100 - this.mDeleteBtnBg.getWidth(null) / 2, 12 - this.mDeleteBtnBg.getHeight(null) / 2);
            }
            catch (IOException ex) {
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    public void addImagePreview(ImagePreview preview) {
        this.mImgPreviews.add(preview);
        this.updateUI();
    }

    public void addImagePreviewWithoutUpdate(ImagePreview preview) {
        this.mImgPreviews.add(preview);
    }

    public void removeImagePreviewWithoutUpdate(int index) {
        if (index < this.mImgPreviews.size()) {
            this.mImgPreviews.remove(index);
        }
    }

    public int getImagePreviewsSize() {
        return this.mImgPreviews.size();
    }

    public void updateImagePreviews() {
        this.updateUI();
    }

    public void addImagePreviews(ArrayList<ImagePreview> previews) {
        this.mImgPreviews.addAll(previews);
        this.updateUI();
    }

    public void addSkinUnitPreviews(ArrayList<SkinUnitPreview> previews) {
        this.mImgPreviews.addAll(previews);
        this.updateUI();
    }

    public void addMaterialPkgPreviews(ArrayList<MaterialPkgPreview> previews) {
        this.mImgPreviews.addAll(previews);
        this.updateUI();
    }

    public void clear() {
        if (!this.mImgPreviews.isEmpty()) {
            for (ImagePreview imagePreview : this.mImgPreviews) {
                if (imagePreview == null) continue;
                imagePreview.recycle();
            }
            this.mImgPreviews.clear();
            this.mSelectedFile = null;
            this.updateUI();
        }
    }

    private void setSelectedImageFile(ImagePreview file) {
        if (file != this.mSelectedFile) {
            this.mSelectedFile = file;
            if (file != null && file instanceof SkinUnitPreview) {
                for (int i = 0; i < this.mSkinImagePreviewListeners.size(); ++i) {
                    this.mSkinImagePreviewListeners.get(i).skinUnitPreviewPressed((SkinUnitPreview)file);
                }
            }
            this.repaint();
        }
        if (null != file && file instanceof ImagePreview && file.getTag().contains("PhonePaper")) {
            this.requestFocus();
            this.mPhoneWallpaperListener.phoneWallpagePreviewPressed(file);
            this.repaint();
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            if (this.mSelectedFile != null && this.mSelectedFile instanceof SkinUnitPreview) {
                for (int i = 0; i < this.mSkinImagePreviewListeners.size(); ++i) {
                    this.mSkinImagePreviewListeners.get(i).skinUnitPreviewDoubleClicked((SkinUnitPreview)this.mSelectedFile);
                }
            }
        } else {
            for (int i = 0; i < this.mImgPreviews.size(); ++i) {
                if (null != this.mSelectedFile && this.mSelectedFile == this.mImgPreviews.get(i) && null != this.mDeleteBtnBg && this.mSelectedFile.getTag().contains("PhonePaperImage_") && e.getPoint().x > 4 + i * 104 + 100 - this.mDeleteBtnBg.getWidth(null) / 2 && e.getPoint().x < 4 + i * 104 + 100 + this.mDeleteBtnBg.getWidth(null) / 2 && e.getPoint().y > 12 - this.mDeleteBtnBg.getHeight(null) / 2 && e.getPoint().y < 12 + this.mDeleteBtnBg.getHeight(null) / 2) {
                    if (0 == JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u5220\u9664\u6b64\u81ea\u5b9a\u4e49\u58c1\u7eb8\uff1f", "\u63d0\u793a", 2)) {
                        this.deletePhoneBackground();
                    }
                    return;
                }
                if (e.getPoint().x <= 4 + i * 104 || e.getPoint().x >= 104 + i * 104 || e.getPoint().y <= 4 || e.getPoint().y >= 104) continue;
                this.setSelectedImageFile(this.mImgPreviews.get(i));
                return;
            }
            this.setSelectedImageFile(null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 && null != this.mSelectedFile && this.mSelectedFile instanceof ImagePreview && this.mSelectedFile.getTag().contains("PhonePaperImage_")) {
            this.deletePhoneBackground();
        }
    }

    private void deletePhoneBackground() {
        this.mImgPreviews.remove(this.mSelectedFile);
        FileUtil.deleteFile(Constants.BG_IMAGE_PATH, this.mSelectedFile.getSourceImageFile().getName());
        FileUtil.deleteFile(Constants.BG_THUMBNAIL_PATH, this.mSelectedFile.getSourceImageFile().getName());
        Notifier.getInstance().notifyEvent("update_skin_preview", new Object[0]);
        this.updateUI();
    }
}

