/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import sina.mobile.tianqitong.skin.SkinUnitPreview;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicImagePreviewPane
extends JPanel
implements Scrollable {
    private static final int IMG_WIDTH = 100;
    private static final int IMG_HEIGHT = 100;
    private ArrayList<File> imgFiles = new ArrayList();
    private HashMap<File, BufferedImage> imgMap = new HashMap();

    public DynamicImagePreviewPane() {
        this.initComponents();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height / 32 * 32;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            for (int i = 0; i < this.imgFiles.size(); ++i) {
                File name = this.imgFiles.get(i);
                SkinUnitPreview pic = new SkinUnitPreview();
                if (this.imgMap.get(name) == null) {
                    pic.setSourceImageFile(name);
                    this.imgMap.put(name, pic.getSourceImage());
                } else {
                    pic.setSourceImage(this.imgMap.get(name));
                }
                pic.paintPreview(g, 0, 0, 100, 100);
                g.setColor(Color.black);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addImageFile(File name) {
        this.imgFiles.add(name);
        this.updateUI();
    }

    public void addImageFiles(ArrayList<File> names) {
        this.imgFiles.addAll(names);
        this.updateUI();
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(100, 100));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

