/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.module.DynamicImagePreviewPane;
import sina.mobile.tianqitong.moduleui.CustomComboBoxUI;

public class DynamicImagePane
extends JPanel {
    private DynamicImagePreviewPane mIconPreviewPanel;
    private JComboBox mNameList;
    private String[] mNames = new String[0];

    public DynamicImagePane() {
        this.initComponents();
    }

    public DynamicImagePane(File file, String[] names) {
        this.mNames = names;
        this.initComponents();
        this.mNameList.setSelectedIndex(0);
        this.mIconPreviewPanel.addImageFile(file);
        this.mIconPreviewPanel.repaint();
        this.mNameList.setUI(CustomComboBoxUI.createUI(this.mNameList));
        this.setVisible(true);
    }

    public JComboBox getSelectedNameList() {
        return this.mNameList;
    }

    public String getSelectedName() {
        return this.mNameList.getSelectedItem().toString();
    }

    public void setImage(File image) {
        this.mIconPreviewPanel.addImageFile(image);
        this.mIconPreviewPanel.repaint();
    }

    public void setNameList(String[] names) {
        this.mNameList.setModel(new DefaultComboBoxModel<String>(names));
    }

    private void initComponents() {
        this.mIconPreviewPanel = new DynamicImagePreviewPane();
        this.mNameList = new JComboBox();
        this.mIconPreviewPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout mIconPreviewPanelLayout = new GroupLayout(this.mIconPreviewPanel);
        this.mIconPreviewPanel.setLayout(mIconPreviewPanelLayout);
        mIconPreviewPanelLayout.setHorizontalGroup(mIconPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        mIconPreviewPanelLayout.setVerticalGroup(mIconPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        this.mNameList.setBackground(Colors.BACKGROUND);
        this.mNameList.setModel(new DefaultComboBoxModel<String>(this.mNames));
        this.mNameList.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mNameList, -2, 100, -2).addComponent(this.mIconPreviewPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.mIconPreviewPanel, this.mNameList);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mIconPreviewPanel, -2, -1, -2).addGap(14, 14, 14).addComponent(this.mNameList, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

