/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import sina.mobile.tianqitong.material.MaterialAddButton;
import sina.mobile.tianqitong.material.MaterialButton;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.module.ImagePreviewPane;
import sina.mobile.tianqitong.skin.MaterialPkgPreview;

public class MaterialButtonMouseAdapter
extends MouseAdapter {
    private ImagePreviewPane mSkinUnitPreviewPane;
    private IAddNewOnClickListener mListener;
    private String mDirName = "";

    public void setListener(IAddNewOnClickListener listener) {
        this.mListener = listener;
    }

    public void setDirName(String mDirName) {
        this.mDirName = mDirName;
    }

    public ImagePreviewPane getSkinUnitPreviewPane() {
        return this.mSkinUnitPreviewPane;
    }

    public void setSkinUnitPreviewPane(ImagePreviewPane skinUnitPreviewPane) {
        this.mSkinUnitPreviewPane = skinUnitPreviewPane;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof MaterialButton) {
            MaterialButton mb = (MaterialButton)e.getSource();
            MaterialPkg pkg = mb.getMaterialPkg();
            if (pkg.getMaterialCfg() == null) {
                try {
                    pkg.readMaterialCfg();
                }
                catch (ZipException ex) {
                    ex.printStackTrace();
                }
                catch (DocumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.mSkinUnitPreviewPane != null) {
                this.mSkinUnitPreviewPane.clear();
                if (pkg.getMaterialCfg() != null) {
                    ArrayList<MaterialPkgPreview> pkgPreviews = new ArrayList<MaterialPkgPreview>();
                    for (int i = 0; i < pkg.getMaterialCfg().fileNames.size(); ++i) {
                        String fn = pkg.getMaterialCfg().fileNames.get(i);
                        MaterialPkgPreview pkgPreview = new MaterialPkgPreview();
                        pkgPreview.setSourceImage(pkg.getMaterialCfg().imageCacheMap.get(fn));
                        pkgPreview.setTag(fn);
                        pkgPreview.setName(pkg.getMaterialCfg().imageStrings.get(fn));
                        pkgPreview.setMaterialPkg(pkg);
                        pkgPreviews.add(pkgPreview);
                    }
                    this.mSkinUnitPreviewPane.addMaterialPkgPreviews(pkgPreviews);
                }
            }
        } else if (e.getSource() instanceof MaterialAddButton && null != this.mListener) {
            this.mListener.onClickListener(this.mDirName);
        }
    }

    public static interface IAddNewOnClickListener {
        public void onClickListener(String var1);
    }
}

