/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.module.JDragableButton;

public class MaterialButton
extends JDragableButton {
    private MaterialPkg mMaterial;
    private static final int W = 64;
    private static final int H = 64;

    public MaterialPkg getMaterialPkg() {
        return this.mMaterial;
    }

    public void setMaterialPkg(MaterialPkg material) {
        this.mMaterial = material;
    }

    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Colors.LIGHT_AREA);
        g.fillRect(3, 3, 58, 58);
        if (this.mMaterial != null && this.mMaterial.getPreviewImage() != null) {
            BufferedImage image = this.mMaterial.getPreviewImage();
            int x = 3;
            int y = 3;
            int w = 58;
            int h = 58;
            if (image.getWidth() <= w && image.getHeight() <= h) {
                g.drawImage(image, x + (w - image.getWidth()) / 2, y + (h - image.getHeight()) / 2, null);
            } else if (image.getWidth() <= w && image.getHeight() > h) {
                double ratio = (double)image.getHeight() * 1.0 / (double)image.getWidth();
                int newW = Math.max(1, (int)((double)h / ratio));
                g.drawImage(image.getScaledInstance(newW, h, 2), x + (w - newW) / 2, y, null);
            } else if (image.getWidth() > w && image.getHeight() <= h) {
                double ratio = (double)image.getWidth() * 1.0 / (double)image.getHeight();
                int newH = Math.max(1, (int)((double)w / ratio));
                g.drawImage(image.getScaledInstance(w, newH, 2), x, y + (h - newH) / 2, null);
            } else if (image.getWidth() > w && image.getHeight() > h) {
                if (image.getWidth() > image.getHeight()) {
                    double ratio = (double)image.getWidth() * 1.0 / (double)image.getHeight();
                    int newH = Math.max(1, (int)((double)w / ratio));
                    g.drawImage(image.getScaledInstance(w, (int)((double)w / ratio), 2), x, y + (h - newH) / 2, null);
                } else if (image.getWidth() == image.getHeight()) {
                    g.drawImage(image.getScaledInstance(w, h, 2), x, y, null);
                } else {
                    double ratio = (double)image.getHeight() * 1.0 / (double)image.getWidth();
                    int newW = Math.max(1, (int)((double)h / ratio));
                    g.drawImage(image.getScaledInstance((int)((double)h / ratio), h, 2), x + (w - newW) / 2, y, null);
                }
            }
        }
    }
}

