/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.dnd.DragGestureEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.module.JDragableButton;

public class MaterialAddButton
extends JDragableButton {
    private MaterialPkg mMaterial;
    private BufferedImage mBackgroundImg;
    private static final int W = 64;
    private static final int H = 64;

    public MaterialAddButton() {
        this.initImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImage() {
        InputStream in = this.getClass().getResourceAsStream("/sina/mobile/tianqitong/resources/add_new.png");
        try {
            this.mBackgroundImg = ImageIO.read(in);
        }
        catch (IOException ex) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Colors.LIGHT_AREA);
        g.fillRect(3, 3, 58, 58);
        if (this.mBackgroundImg != null) {
            int x = 3;
            int y = 3;
            int w = 58;
            int h = 58;
            if (this.mBackgroundImg.getWidth() <= w && this.mBackgroundImg.getHeight() <= h) {
                g.drawImage(this.mBackgroundImg, x + (w - this.mBackgroundImg.getWidth()) / 2, y + (h - this.mBackgroundImg.getHeight()) / 2, null);
            } else if (this.mBackgroundImg.getWidth() <= w && this.mBackgroundImg.getHeight() > h) {
                double ratio = (double)this.mBackgroundImg.getHeight() * 1.0 / (double)this.mBackgroundImg.getWidth();
                int newW = Math.max(1, (int)((double)h / ratio));
                g.drawImage(this.mBackgroundImg.getScaledInstance(newW, h, 2), x + (w - newW) / 2, y, null);
            } else if (this.mBackgroundImg.getWidth() > w && this.mBackgroundImg.getHeight() <= h) {
                double ratio = (double)this.mBackgroundImg.getWidth() * 1.0 / (double)this.mBackgroundImg.getHeight();
                int newH = Math.max(1, (int)((double)w / ratio));
                g.drawImage(this.mBackgroundImg.getScaledInstance(w, newH, 2), x, y + (h - newH) / 2, null);
            } else if (this.mBackgroundImg.getWidth() > w && this.mBackgroundImg.getHeight() > h) {
                if (this.mBackgroundImg.getWidth() > this.mBackgroundImg.getHeight()) {
                    double ratio = (double)this.mBackgroundImg.getWidth() * 1.0 / (double)this.mBackgroundImg.getHeight();
                    int newH = Math.max(1, (int)((double)w / ratio));
                    g.drawImage(this.mBackgroundImg.getScaledInstance(w, (int)((double)w / ratio), 2), x, y + (h - newH) / 2, null);
                } else if (this.mBackgroundImg.getWidth() == this.mBackgroundImg.getHeight()) {
                    g.drawImage(this.mBackgroundImg.getScaledInstance(w, h, 2), x, y, null);
                } else {
                    double ratio = (double)this.mBackgroundImg.getHeight() * 1.0 / (double)this.mBackgroundImg.getWidth();
                    int newW = Math.max(1, (int)((double)h / ratio));
                    g.drawImage(this.mBackgroundImg.getScaledInstance((int)((double)h / ratio), h, 2), x + (w - newW) / 2, y, null);
                }
            }
        }
    }

    public MaterialPkg getMaterialPkg() {
        return this.mMaterial;
    }

    public void setMaterialPkg(MaterialPkg material) {
        this.mMaterial = material;
    }
}

