/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.material.AccordionEvent;
import sina.mobile.tianqitong.material.AccordionListener;
import sina.mobile.tianqitong.material.AccordionPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAccordionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel mPanel = new JPanel();
    private List<JScrollPane> mScrollPanels = new ArrayList<JScrollPane>();
    private List<AccordionPanel> mAccordionPanels = new ArrayList<AccordionPanel>();
    private boolean mSingleSelected = true;
    private AccordionListener mListener = new AccordionListener(){

        public void accordionStateChanged(AccordionEvent e) {
            if (e.getSource().isExpansion() && JAccordionPanel.this.mSingleSelected) {
                for (AccordionPanel accordionPanel : JAccordionPanel.this.mAccordionPanels) {
                    if (accordionPanel.equals(e.getSource())) continue;
                    accordionPanel.setExpansion(false);
                }
            }
            JAccordionPanel.this.initComponent();
        }
    };

    public boolean isSingleSelected() {
        return this.mSingleSelected;
    }

    public void setSingleSelected(boolean singleSelected) {
        this.mSingleSelected = singleSelected;
    }

    public JAccordionPanel() {
        super(new BorderLayout());
        this.mPanel.setOpaque(true);
        this.mPanel.setBackground(Colors.LIGHT_AREA);
        this.add((Component)this.mPanel, "Center");
    }

    public AccordionPanel addScrollPane(String name, JScrollPane panel) {
        AccordionPanel ap = new AccordionPanel();
        ap.setTitle(name);
        panel.setSize(panel.getPreferredSize());
        ap.setScrollPane(panel);
        this.mAccordionPanels.add(ap);
        this.mScrollPanels.add(panel);
        this.refreshAccordionPanels();
        return ap;
    }

    public AccordionPanel addAccordionPanel(AccordionPanel ap) {
        this.mAccordionPanels.add(ap);
        this.mScrollPanels.add(ap.getScrollPane());
        this.refreshAccordionPanels();
        return ap;
    }

    public void addAccordionPanels(ArrayList<AccordionPanel> aps) {
        for (AccordionPanel ap : aps) {
            this.mAccordionPanels.add(ap);
            this.mScrollPanels.add(ap.getScrollPane());
        }
        this.refreshAccordionPanels();
    }

    public void removeScrollPane(JScrollPane panel) {
        if (!this.mAccordionPanels.isEmpty() && !this.mScrollPanels.isEmpty() && panel != null) {
            this.mAccordionPanels.remove(this.mScrollPanels.indexOf(panel));
            this.mScrollPanels.remove(panel);
            this.refreshAccordionPanels();
        }
    }

    public void removeAccordionPanel(AccordionPanel ap) {
        if (!this.mAccordionPanels.isEmpty() && !this.mScrollPanels.isEmpty() && ap != null) {
            this.mAccordionPanels.remove(ap);
            this.mScrollPanels.remove(ap.getScrollPane());
            this.refreshAccordionPanels();
        }
    }

    public void clearAllScrollPanes() {
        this.mAccordionPanels.clear();
        this.mScrollPanels.clear();
        this.refreshAccordionPanels();
    }

    public void refreshAccordionPanels() {
        this.mPanel.removeAll();
        for (AccordionPanel epl : this.mAccordionPanels) {
            this.addComponent(epl);
            epl.addAccordionListener(this.mListener);
        }
    }

    public void initComponent() {
        Rectangle re = this.getParent().getBounds();
        Insets ins = this.mPanel.getInsets();
        int cw = (int)re.getWidth() - ins.left - ins.right;
        int ch = 10;
        Component[] list = this.mPanel.getComponents();
        for (int i = 0; i < list.length; ++i) {
            JComponent tmp = (JComponent)list[i];
            int th = tmp.getPreferredSize().height;
            tmp.setPreferredSize(new Dimension(cw, th));
            ch = ch + th + 10;
        }
        this.mPanel.setPreferredSize(new Dimension((int)re.getWidth(), ch + ins.top + ins.bottom));
        this.mPanel.revalidate();
    }

    public void addComponent(Component label) {
        SpringLayout layout = new SpringLayout();
        Component[] list = this.mPanel.getComponents();
        if (list.length == 0) {
            layout.putConstraint("West", label, 1, "West", (Component)this.mPanel);
            layout.putConstraint("North", label, 1, "North", (Component)this.mPanel);
        } else {
            JComponent cmp = null;
            for (int i = 0; i < list.length; ++i) {
                JComponent tmp = (JComponent)list[i];
                layout.putConstraint("West", (Component)tmp, 1, "West", (Component)this.mPanel);
                if (cmp == null) {
                    layout.putConstraint("North", (Component)tmp, 1, "North", (Component)this.mPanel);
                } else {
                    layout.putConstraint("North", (Component)tmp, 1, "South", cmp);
                }
                cmp = tmp;
            }
            layout.putConstraint("West", label, 1, "West", (Component)this.mPanel);
            layout.putConstraint("North", label, 1, "South", cmp);
        }
        this.mPanel.add(label);
        this.mPanel.setLayout(layout);
        this.initComponent();
    }
}

