/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.material.AccordionEvent;
import sina.mobile.tianqitong.material.AccordionListener;

public class AccordionPanel
extends JPanel {
    protected ArrayList<AccordionListener> mAccordionListenerList = new ArrayList();
    private String mTitle;
    private JLabel mLabel;
    private JScrollPane mPanel;
    private boolean mOpenFlag = false;
    private static BufferedImage mRightIcon;
    private static BufferedImage mDownIcon;

    public AccordionPanel() {
        super(new BorderLayout());
        try {
            mRightIcon = ImageIO.read(this.getClass().getResource("/sina/mobile/tianqitong/resources/right_arrow.png"));
            mDownIcon = ImageIO.read(this.getClass().getResource("/sina/mobile/tianqitong/resources/down_arrow.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(AccordionPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.mLabel = new JLabel(){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                Dimension dimen = new Dimension(super.getPreferredSize().width, 22);
                return dimen;
            }

            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Colors.BACKGROUND);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                int h = AccordionPanel.this.mLabel.getHeight();
                int y = (int)((float)(h - mRightIcon.getHeight()) / 2.0f);
                if (AccordionPanel.this.mOpenFlag) {
                    g.drawImage(mDownIcon, 8, y, null);
                } else {
                    g.drawImage(mRightIcon, 8, y, null);
                }
                Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
                g2.setFont(font);
                g2.setColor(Color.WHITE);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FontRenderContext context = g2.getFontRenderContext();
                Rectangle2D stringBounds = font.getStringBounds(AccordionPanel.this.mTitle, context);
                double height = stringBounds.getHeight();
                int y1 = (int)(((double)h - height) / 2.0 + height - 5.0);
                g.drawString(AccordionPanel.this.mTitle, 10 + mRightIcon.getWidth(), y1);
                super.paintComponent(g);
            }
        };
        this.mLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AccordionPanel.this.mOpenFlag = !AccordionPanel.this.mOpenFlag;
                AccordionPanel.this.refresh();
                AccordionPanel.this.fireAccordionEvent();
            }
        });
        this.add((Component)this.mLabel, "North");
    }

    public JScrollPane getScrollPane() {
        return this.mPanel;
    }

    public void setScrollPane(JScrollPane panel) {
        this.mPanel = panel;
        panel.setOpaque(true);
        MatteBorder outBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, Color.BLACK);
        Border inBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        CompoundBorder border = BorderFactory.createCompoundBorder(outBorder, inBorder);
        panel.setBorder(border);
        panel.setBackground(Colors.LIGHT_AREA);
    }

    public boolean isExpansion() {
        return this.mOpenFlag;
    }

    public void setExpansion(boolean mOpenFlag) {
        this.mOpenFlag = mOpenFlag;
        this.refresh();
        this.fireAccordionEvent();
    }

    protected void refresh() {
        if (this.mOpenFlag) {
            boolean isContain = false;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!this.mPanel.equals(this.getComponents()[i])) continue;
                isContain = true;
                break;
            }
            if (!isContain) {
                this.add((Component)this.mPanel, "Center");
            }
            this.setPreferredSize(new Dimension(this.getSize().width, this.mLabel.getSize().height + this.mPanel.getSize().height));
        } else {
            this.remove(this.mPanel);
            this.setPreferredSize(new Dimension(this.getSize().width, this.mLabel.getSize().height));
        }
        this.revalidate();
    }

    public void addAccordionListener(AccordionListener listener) {
        if (!this.mAccordionListenerList.contains(listener)) {
            this.mAccordionListenerList.add(listener);
        }
    }

    public void removeAccordionListener(AccordionListener listener) {
        this.mAccordionListenerList.remove(listener);
    }

    public void fireAccordionEvent() {
        List list = (List)this.mAccordionListenerList.clone();
        Iterator it = list.iterator();
        AccordionEvent e = new AccordionEvent(this);
        while (it.hasNext()) {
            AccordionListener listener = (AccordionListener)it.next();
            listener.accordionStateChanged(e);
        }
    }
}

