/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.io;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import org.xmlpull.v1.XmlPullParserException;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.weather.WeatherInfo;
import sina.mobile.tianqitong.io.ExportTQTSkinZipPkg;
import sina.mobile.tianqitong.skin.SkinCfg;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.ZipUtil;

public class ImportTQTSkinZipPkg {
    public static void expandSkinPkg(SkinPkg pkg, String cacheDirString, String size, String aspect, String dpi) throws IOException {
        int type = pkg.getSkinCfg().SkinType;
        if (type != 0 && type != 1 && type != 3 && type != 2) {
            Object cacheDir = null;
            Object mZipSkinFile = null;
            throw new IllegalStateException();
        }
        File dir = new File(cacheDirString, pkg.getSkinFile().getName().substring(0, pkg.getSkinFile().getName().length() - ".zip".length()));
        dir.mkdirs();
        SkinHelper.setCacheDir(dir);
        SkinHelper.setLazyLoad(false);
        File cacheDir = dir;
        File mZipSkinFile = pkg.getSkinFile();
        if (!SkinHelper.checkCacheDir(mZipSkinFile, cacheDir)) {
            FileUtil.deleteAllFile(cacheDir.getAbsolutePath());
            SkinHelper.makeCacheDir(mZipSkinFile, cacheDir, size, aspect, dpi);
        }
        SkinCfg cfg = pkg.getSkinCfg();
        ZipUtil.uncompress(mZipSkinFile.getPath(), new ExportTQTSkinZipPkg().getSkinZipPath(cfg.Name));
    }

    public static SkinCfg readSkinCfg(SkinPkg pkg) {
        try {
            SkinCfg skinCfg = SkinCfg.getSkinCfg(pkg.getSkinFile());
            if (null == skinCfg) {
                return null;
            }
            if (skinCfg.Type.equals("4x1")) {
                skinCfg.SkinType = 1;
            } else if (skinCfg.Type.equals("4x2")) {
                skinCfg.SkinType = 0;
            } else if (skinCfg.Type.equals("5x1")) {
                skinCfg.SkinType = 3;
            } else if (skinCfg.Type.equals("5x2")) {
                skinCfg.SkinType = 2;
            }
            return skinCfg;
        }
        catch (ZipException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (XmlPullParserException ex) {
            return null;
        }
    }

    public static Skin[] spliceSkin(int skinType, File skinFile, WeatherInfo weather) {
        Skin landSkin = Skin.getLandSkin(skinType, skinFile);
        Skin portSkin = Skin.getPortSkin(skinType, skinFile);
        landSkin.setWeatherInfo(weather);
        portSkin.setWeatherInfo(weather);
        try {
            if (landSkin.getSkinUnits().isEmpty()) {
                landSkin.parseLayoutXml();
            }
            if (portSkin.getSkinUnits().isEmpty()) {
                portSkin.parseLayoutXml();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Skin[] skins = new Skin[]{portSkin, landSkin};
        return skins;
    }
}

