/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.io;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.Picture;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinImage;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.adapter.PictureAdapter;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.io.ExportSkinCfg;
import sina.mobile.tianqitong.io.ExportSkinIcon;
import sina.mobile.tianqitong.io.ExportSkinLayoutXml;
import sina.mobile.tianqitong.io.ICallBack;
import sina.mobile.tianqitong.skin.SkinCfg;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.Log;
import sina.mobile.tianqitong.util.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTQTSkinZipPkg
implements ICallBack {
    private boolean mFlag1 = false;
    private boolean mFlag2 = false;
    private boolean mFlag3 = false;
    private String mSkinCachePath;
    private String mPath;
    private Runnable mRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HashMap<String, Boolean> map) {
        if (map.containsKey("SkinIcon")) {
            this.mFlag1 = map.get("SkinIcon");
        } else if (map.containsKey("SkinImage")) {
            this.mFlag2 = map.get("SkinImage");
        } else if (map.containsKey("LayoutXml")) {
            this.mFlag3 = map.get("LayoutXml");
        }
        if (this.mFlag1 && this.mFlag2 && this.mFlag3) {
            String p = this.mPath;
            p = p + (p.endsWith(".zip") ? "" : ".zip");
            Log.debug("\u538b\u7f29\u5230\u76ae\u80a4\u5305: " + this.mSkinCachePath);
            ZipUtil.compress(this.mSkinCachePath, p, "");
            Runnable runnable = this.mRunnable;
            synchronized (runnable) {
                this.mRunnable.notify();
            }
        }
    }

    public void exportSkinZip(String path, String dirname, String name, String author, BufferedImage icon, BufferedImage icon2, Runnable r) {
        String skinCachePath;
        SkinCfg cfg = AppData.getInstance().getSkinPkg().getSkinCfg();
        this.mSkinCachePath = skinCachePath = this.getSkinZipPath(dirname);
        this.mPath = path;
        this.mRunnable = r;
        this.createSkinCfg(skinCachePath, name, author, cfg.Type, cfg.ButtonFrame, cfg.Version);
        new CreateSkinIconTask().executeTask(skinCachePath, icon, icon2, this);
        new RepaintSkinImage().executeTask(skinCachePath, this);
        new WriteLayoutXmlTask().executeTask(skinCachePath, this);
    }

    public void createSkinCfg(String path, String skinName, String author, String skinType, int buttonFrame, String version) {
        ExportSkinCfg.createSkinCfg(path, skinName, author, skinType, buttonFrame, version);
    }

    public static void createSkinIcon(String path, BufferedImage image, BufferedImage image2) {
        ExportSkinIcon.createSkinIcon(path, image, image2);
    }

    private void writeImage(String path) {
        Skin skin = AppData.getInstance().getSkinAdapter().getSkin();
        ArrayList<AbSkinUnit> skinUnitList = skin.getSkinUnits();
        for (AbSkinUnit skinUnit : skinUnitList) {
            if (skinUnit instanceof SkinImage) {
                SkinImage skinImage = (SkinImage)skinUnit;
                int width = skinImage.getDrawRect().width();
                int height = skinImage.getDrawRect().height();
                Iterator iterator = skinImage.getImageCacheMap();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String name = (String)entry.getKey();
                    Picture pic = (Picture)entry.getValue();
                    if (pic == null) {
                        Log.info(name + "\u6587\u4ef6\u672a\u80fd\u6b63\u5e38\u5199\u51fa\uff0c\u8bf7\u68c0\u67e5\u76ae\u80a4\u5305\uff01");
                        continue;
                    }
                    if (skinImage.isCombination()) {
                        double scaleWidth = skinImage.getScaleWidth();
                        double scaleHeight = skinImage.getScaleHeight();
                        width = Math.max(1, (int)((double)pic.getWidth() * scaleWidth));
                        height = Math.max(1, (int)((double)pic.getHeight() * scaleHeight));
                    } else {
                        width = Math.max(1, width);
                        height = Math.max(1, height);
                    }
                    PictureAdapter picAdapter = (PictureAdapter)pic.getPicture();
                    Image image = picAdapter.getBufferedImage().getScaledInstance(width, height, 4);
                    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                    Graphics2D g = bufferedImage.createGraphics();
                    g.drawImage(image, null, null);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", new File(path + name));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                continue;
            }
            if (!(skinUnit instanceof SkinButton)) continue;
            this.writeImageButton((SkinButton)skinUnit, skin, path);
        }
    }

    public void repaintSkinImageUnit(String parentPath) {
        String path = null;
        String resolution = AppData.getInstance().mConfig.getResolution();
        if (resolution.equals(Config.RESOLUTION[6])) {
            path = this.createSkinZipDefaultCachePath(parentPath);
            FileUtil.deleteAllFile(path);
            this.writeImage(path);
            path = this.createSkinZipCachePath(parentPath);
            FileUtil.deleteAllFile(path);
            this.writeImage(path);
        } else if (SkinPkg.isDepend(resolution)) {
            path = this.createSkinZipCachePath(parentPath);
            FileUtil.deleteAllFile(path);
            this.writeImage(path);
        } else {
            return;
        }
    }

    public void writeLayout(String parentPath) {
        String resolution = AppData.getInstance().mConfig.getResolution();
        if (resolution.equals(Config.RESOLUTION[6])) {
            ExportSkinLayoutXml.createSkinLayoutXml(parentPath, this.createSkinLayoutDefaultXmlName(), AppData.getInstance().getSkinAdapter().getSkin().getSkinUnits());
            ExportSkinLayoutXml.createSkinLayoutXml(parentPath, this.createSkinLayoutXmlName(), AppData.getInstance().getSkinAdapter().getSkin().getSkinUnits());
        } else if (SkinPkg.isDepend(resolution)) {
            ExportSkinLayoutXml.createSkinLayoutXml(parentPath, this.createSkinLayoutXmlName(), AppData.getInstance().getSkinAdapter().getSkin().getSkinUnits());
        } else {
            File dir;
            File file;
            Config config = AppData.getInstance().mConfig;
            SkinPkg pkg = AppData.getInstance().getSkinPkg();
            String path = "SkinCache" + File.separator + Config.ORIENTATION_STRING[config.getOrientation()] + "_" + Config.ASPECT_RATIO_STRING[config.getAspectRatio()] + "_" + Config.DENSITY_STRING[config.getDensity()] + "_" + Config.SIZE_STRING[config.getSize()] + File.separator + pkg.getSkinFile().getName().substring(0, pkg.getSkinFile().getName().length() - ".zip".length()) + File.separator;
            File cacehDir = new File(path);
            if (cacehDir.exists()) {
                FileUtil.deleteFolder(path);
            }
            if ((file = new File(parentPath, this.createSkinLayoutXmlName())).exists()) {
                file.delete();
            }
            if ((dir = new File(this.createSkinZipCachePath(parentPath))).exists()) {
                FileUtil.deleteFolder(this.createSkinZipCachePath(parentPath));
            }
        }
    }

    public String getSkinZipPath(String skinName) {
        String path = "SkinZip" + File.separator + skinName + File.separator;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private String createSkinZipDefaultCachePath(String parentPath) {
        String path = parentPath + "drawable-" + Config.ORIENTATION_STRING[0] + "-" + Config.DENSITY_STRING[0] + File.separator;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private String createSkinZipCachePath(String parentPath) {
        Config config = AppData.getInstance().mConfig;
        String path = parentPath + "drawable-" + Config.SIZE_STRING[config.getSize()] + "-" + Config.ASPECT_RATIO_STRING[config.getAspectRatio()] + "-" + Config.ORIENTATION_STRING[config.getOrientation()] + "-" + Config.DENSITY_STRING[config.getDensity()] + File.separator;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    public String createSkinLayoutDefaultXmlName() {
        String path = "layout-" + Config.ORIENTATION_STRING[0] + "-" + Config.DENSITY_STRING[1] + ".xml";
        return path;
    }

    public String createSkinLayoutXmlName() {
        Config config = AppData.getInstance().mConfig;
        String path = "layout-" + Config.SIZE_STRING[config.getSize()] + "-" + Config.ASPECT_RATIO_STRING[config.getAspectRatio()] + "-" + Config.ORIENTATION_STRING[config.getOrientation()] + "-" + Config.DENSITY_STRING[config.getDensity()] + ".xml";
        return path;
    }

    private void writeImageButton(SkinButton skinUnit, Skin skin, String path) {
        Graphics g;
        BufferedImage bimg;
        Image temp;
        BufferedImage image;
        SkinButton skinButton = skinUnit;
        String playIcon = skinButton.getSrc();
        String stopIcon = skinButton.getStopPlayingSrc();
        if (playIcon != null && !"".equals(playIcon)) {
            try {
                image = ((PictureAdapter)SkinHelper.getPictureByFilename(skin.getSkinZipFile(), playIcon, skin.isPortrait()).getPicture()).getBufferedImage();
                temp = image.getScaledInstance(skinButton.getPictureRect().width(), skinButton.getPictureRect().height(), 4);
                bimg = new BufferedImage(skinButton.getPictureRect().width(), skinButton.getPictureRect().height(), 2);
                g = bimg.getGraphics();
                g.drawImage(temp, 0, 0, null);
                ImageIO.write((RenderedImage)bimg, "png", new File(path + playIcon));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (stopIcon != null && !"".equals(stopIcon)) {
            try {
                image = ((PictureAdapter)SkinHelper.getPictureByFilename(skin.getSkinZipFile(), stopIcon, skin.isPortrait()).getPicture()).getBufferedImage();
                temp = image.getScaledInstance(skinButton.getPictureRect().width(), skinButton.getPictureRect().height(), 4);
                bimg = new BufferedImage(skinButton.getPictureRect().width(), skinButton.getPictureRect().height(), 2);
                g = bimg.getGraphics();
                g.drawImage(temp, 0, 0, null);
                ImageIO.write((RenderedImage)bimg, "png", new File(path + stopIcon));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class WriteLayoutXmlTask {
        private WriteLayoutXmlTask() {
        }

        public void executeTask(final String skinCachePath, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    ExportTQTSkinZipPkg.this.writeLayout(skinCachePath);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("LayoutXml", true);
                    callBack.execute(map);
                }
            }.start();
        }
    }

    private class RepaintSkinImage {
        private RepaintSkinImage() {
        }

        public void executeTask(final String skinCachePath, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    ExportTQTSkinZipPkg.this.repaintSkinImageUnit(skinCachePath);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("SkinImage", true);
                    callBack.execute(map);
                }
            }.start();
        }
    }

    private class CreateSkinIconTask {
        private CreateSkinIconTask() {
        }

        public void executeTask(final String skinCachePath, final BufferedImage icon, final BufferedImage icon2, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    ExportTQTSkinZipPkg.createSkinIcon(skinCachePath, icon, icon2);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("SkinIcon", true);
                    callBack.execute(map);
                }
            }.start();
        }
    }
}

