/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.io;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinImage;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinText;
import sina.mobile.skin.SkinTextArea;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSkinLayoutXml {
    private static final HashMap<Integer, String> mDatumMaps = new HashMap();

    private static String getDatumPoint(SkinLayoutModel model) {
        if (model.getDatumPoint() == 17) {
            return mDatumMaps.get(1) + "|" + mDatumMaps.get(16);
        }
        if (model.getDatumPoint() == 9) {
            return mDatumMaps.get(1) + "|" + mDatumMaps.get(8);
        }
        if (model.getDatumPoint() == 33) {
            return mDatumMaps.get(1) + "|" + mDatumMaps.get(32);
        }
        if (model.getDatumPoint() == 18) {
            return mDatumMaps.get(2) + "|" + mDatumMaps.get(16);
        }
        if (model.getDatumPoint() == 10) {
            return mDatumMaps.get(2) + "|" + mDatumMaps.get(8);
        }
        if (model.getDatumPoint() == 34) {
            return mDatumMaps.get(2) + "|" + mDatumMaps.get(32);
        }
        if (model.getDatumPoint() == 20) {
            return mDatumMaps.get(4) + "|" + mDatumMaps.get(16);
        }
        if (model.getDatumPoint() == 12) {
            return mDatumMaps.get(4) + "|" + mDatumMaps.get(8);
        }
        if (model.getDatumPoint() == 36) {
            return mDatumMaps.get(4) + "|" + mDatumMaps.get(32);
        }
        return null;
    }

    private static int getRealSize(int offset) {
        Config config = AppData.getInstance().mConfig;
        return Math.round((float)offset * 1.0f / Config.DENSITY[config.getDensity()]);
    }

    private static void addSkinImageLayout(Element root, SkinImage skinImage) {
        String datumVLine;
        String datumHLine;
        Element imageElement = root.addElement("Image");
        imageElement.addAttribute("Name", skinImage.getName());
        if (skinImage.getFunctionId() != null) {
            imageElement.addAttribute("FunctionId", skinImage.getFunctionId());
        } else {
            imageElement.addAttribute("Src", skinImage.getSrc());
        }
        if (skinImage.getLayoutId() != null) {
            imageElement.addAttribute("LayoutId", skinImage.getLayoutId());
        }
        if ((datumHLine = mDatumMaps.get(skinImage.getDatumHLine())) == null) {
            datumHLine = "left";
        }
        if ((datumVLine = mDatumMaps.get(skinImage.getDatumVLine())) == null) {
            datumVLine = "top";
        }
        imageElement.addAttribute("DatumHLine", datumHLine);
        imageElement.addAttribute("DatumVLine", datumVLine);
        if (skinImage.getX() != Integer.MIN_VALUE) {
            imageElement.addAttribute("x", "" + ExportSkinLayoutXml.getRealSize(skinImage.getX()));
        }
        if (skinImage.getY() != Integer.MIN_VALUE) {
            imageElement.addAttribute("y", "" + ExportSkinLayoutXml.getRealSize(skinImage.getY()));
        }
        imageElement.addAttribute("OffsetX", "" + ExportSkinLayoutXml.getRealSize(skinImage.getOffsetX()));
        imageElement.addAttribute("OffsetY", "" + ExportSkinLayoutXml.getRealSize(skinImage.getOffsetY()));
        if (skinImage.getDatumHLineLayoutId() != null) {
            imageElement.addAttribute("DatumHLineLayoutId", skinImage.getDatumHLineLayoutId());
        }
        if (skinImage.getDatumVLineLayoutId() != null) {
            imageElement.addAttribute("DatumVLineLayoutId", skinImage.getDatumVLineLayoutId());
        }
        imageElement.addAttribute("Prefix", skinImage.getPrefix());
        imageElement.addAttribute("NightCWIPrefix", skinImage.getNightCWIPrefix());
        imageElement.addAttribute("OffsetTime", skinImage.getOffsetTime());
        imageElement.addAttribute("DatumPoint", ExportSkinLayoutXml.getDatumPoint(skinImage));
    }

    private static void addSkinTextLayout(Element root, SkinText skinText) {
        String datumVLine;
        String datumHLine;
        Element textElement = root.addElement("Text");
        textElement.addAttribute("Name", skinText.getName());
        if (skinText.getFunctionId() != null) {
            textElement.addAttribute("FunctionId", skinText.getFunctionId());
        } else {
            textElement.addAttribute("Text", skinText.getText());
        }
        if (skinText.getLayoutId() != null) {
            textElement.addAttribute("LayoutId", skinText.getLayoutId());
        }
        if ((datumHLine = mDatumMaps.get(skinText.getDatumHLine())) == null) {
            datumHLine = "left";
        }
        if ((datumVLine = mDatumMaps.get(skinText.getDatumVLine())) == null) {
            datumVLine = "top";
        }
        textElement.addAttribute("DatumHLine", datumHLine);
        textElement.addAttribute("DatumVLine", datumVLine);
        if (skinText.getX() != Integer.MIN_VALUE) {
            textElement.addAttribute("x", "" + ExportSkinLayoutXml.getRealSize(skinText.getX()));
        }
        if (skinText.getY() != Integer.MIN_VALUE) {
            textElement.addAttribute("y", "" + ExportSkinLayoutXml.getRealSize(skinText.getY()));
        }
        textElement.addAttribute("OffsetX", "" + ExportSkinLayoutXml.getRealSize(skinText.getOffsetX()));
        textElement.addAttribute("OffsetY", "" + ExportSkinLayoutXml.getRealSize(skinText.getOffsetY()));
        if (skinText.getDatumHLineLayoutId() != null) {
            textElement.addAttribute("DatumHLineLayoutId", skinText.getDatumHLineLayoutId());
        }
        if (skinText.getDatumVLineLayoutId() != null) {
            textElement.addAttribute("DatumVLineLayoutId", skinText.getDatumVLineLayoutId());
        }
        textElement.addAttribute("DatumPoint", ExportSkinLayoutXml.getDatumPoint(skinText));
        textElement.addAttribute("TextColor", Integer.toHexString(skinText.getTextColor()));
        textElement.addAttribute("TextSize", "" + ExportSkinLayoutXml.getRealSize(skinText.getTextSize()));
        if (skinText.isHasShadow()) {
            textElement.addAttribute("Shadow_pos_y", "" + ExportSkinLayoutXml.getRealSize(skinText.getShadowPosY()));
            textElement.addAttribute("Shadow_pos_x", "" + ExportSkinLayoutXml.getRealSize(skinText.getShadowPosX()));
            textElement.addAttribute("Shadow_color", Integer.toHexString(skinText.getShadowColor()));
            textElement.addAttribute("HasShadow", "" + skinText.isHasShadow());
        }
        textElement.addAttribute("OffsetTime", skinText.getOffsetTime());
    }

    private static void addSkinTextAreaLayout(Element root, SkinTextArea skinTextArea) {
        String datumVLine;
        String datumHLine;
        Element textAreaElement = root.addElement("TextArea");
        textAreaElement.addAttribute("Name", skinTextArea.getName());
        if (skinTextArea.getLayoutId() != null) {
            textAreaElement.addAttribute("LayoutId", skinTextArea.getLayoutId());
        }
        if ((datumHLine = mDatumMaps.get(skinTextArea.getDatumHLine())) == null) {
            datumHLine = "left";
        }
        if ((datumVLine = mDatumMaps.get(skinTextArea.getDatumVLine())) == null) {
            datumVLine = "top";
        }
        textAreaElement.addAttribute("DatumHLine", datumHLine);
        textAreaElement.addAttribute("DatumVLine", datumVLine);
        if (skinTextArea.getX() != Integer.MIN_VALUE) {
            textAreaElement.addAttribute("x", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getX()));
        }
        if (skinTextArea.getY() != Integer.MIN_VALUE) {
            textAreaElement.addAttribute("y", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getY()));
        }
        textAreaElement.addAttribute("OffsetX", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getOffsetX()));
        textAreaElement.addAttribute("OffsetY", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getOffsetY()));
        if (skinTextArea.getDatumHLineLayoutId() != null) {
            textAreaElement.addAttribute("DatumHLineLayoutId", skinTextArea.getDatumHLineLayoutId());
        }
        if (skinTextArea.getDatumVLineLayoutId() != null) {
            textAreaElement.addAttribute("DatumVLineLayoutId", skinTextArea.getDatumVLineLayoutId());
        }
        textAreaElement.addAttribute("Text", skinTextArea.getText());
        textAreaElement.addAttribute("TextColor", Integer.toHexString(skinTextArea.getTextColor()));
        textAreaElement.addAttribute("TextSize", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getTextSize()));
        textAreaElement.addAttribute("LineGap", "" + skinTextArea.getLineGap());
        if (skinTextArea.getW() != Integer.MIN_VALUE) {
            textAreaElement.addAttribute("w", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getW()));
        }
        if (skinTextArea.getH() != Integer.MIN_VALUE) {
            textAreaElement.addAttribute("h", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getH()));
        }
        textAreaElement.addAttribute("Suffix", skinTextArea.getSuffix());
        textAreaElement.addAttribute("DatumPoint", ExportSkinLayoutXml.getDatumPoint(skinTextArea));
        if (skinTextArea.isHasShadow()) {
            textAreaElement.addAttribute("Shadow_pos_y", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getShadowPosY()));
            textAreaElement.addAttribute("Shadow_pos_x", "" + ExportSkinLayoutXml.getRealSize(skinTextArea.getShadowPosX()));
            textAreaElement.addAttribute("Shadow_color", Integer.toHexString(skinTextArea.getShadowColor()));
            textAreaElement.addAttribute("HasShadow", "" + skinTextArea.isHasShadow());
        }
    }

    private static void addSkinButtonLayout(Element root, SkinButton skinButton) {
        Element buttonElement = root.addElement("Button");
        buttonElement.addAttribute("Name", skinButton.getName());
        buttonElement.addAttribute("Idx", "" + skinButton.getIdx());
        buttonElement.addAttribute("FunctionId", skinButton.getFunctionId());
        if (skinButton.getSrc() != null) {
            buttonElement.addAttribute("Src", skinButton.getSrc());
        }
        if (skinButton.getFunctionId().equals("play_tts")) {
            if (skinButton.getStopPlayingSrc() != null) {
                buttonElement.addAttribute("StopPlayingSrc", skinButton.getStopPlayingSrc());
            }
        } else if (skinButton.getFunctionId().equals("app")) {
            buttonElement.addAttribute("PkgName", skinButton.getPkgName());
            buttonElement.addAttribute("ActivityName", skinButton.getActivityName());
            if (skinButton.getIntoClock() != null) {
                buttonElement.addAttribute("IntoClock", skinButton.getIntoClock());
            }
        }
    }

    public static void createSkinLayoutXml(String path, String name, ArrayList<AbSkinUnit> skinUnits) {
        SkinButton button;
        int i;
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Layout");
        HashMap<Integer, SkinButton> buttonMap = new HashMap<Integer, SkinButton>();
        ArrayList<SkinButton> appButtons = new ArrayList<SkinButton>();
        ArrayList<SkinButton> otherButtons = new ArrayList<SkinButton>();
        for (i = 0; i < skinUnits.size(); ++i) {
            AbSkinUnit unit = skinUnits.get(i);
            if (!(unit instanceof SkinButton)) continue;
            SkinButton button2 = (SkinButton)unit;
            if (button2.getFunctionId().equals("app") && button2.getIntoClock() == null) {
                appButtons.add(button2);
                continue;
            }
            otherButtons.add(button2);
        }
        for (i = 0; i < appButtons.size(); ++i) {
            button = (SkinButton)appButtons.get(i);
            if (button.getIdx() == -1) continue;
            buttonMap.put(button.getIdx(), button);
        }
        for (i = 0; i < otherButtons.size(); ++i) {
            button = (SkinButton)otherButtons.get(i);
            if (button.getIdx() == -1) continue;
            buttonMap.put(button.getIdx(), button);
        }
        for (int i2 = 0; i2 < skinUnits.size(); ++i2) {
            AbSkinUnit unit = skinUnits.get(i2);
            if (unit instanceof SkinImage) {
                ExportSkinLayoutXml.addSkinImageLayout(root, (SkinImage)unit);
                continue;
            }
            if (unit instanceof SkinText) {
                ExportSkinLayoutXml.addSkinTextLayout(root, (SkinText)unit);
                continue;
            }
            if (!(unit instanceof SkinTextArea)) continue;
            ExportSkinLayoutXml.addSkinTextAreaLayout(root, (SkinTextArea)unit);
        }
        Iterator ite = buttonMap.entrySet().iterator();
        int count = AppData.getInstance().getSkinPkg().getSkinFramework().getSkinButtonCount();
        int index = 0;
        while (ite.hasNext()) {
            if (index > count - 1) {
                Log.info("\u591a\u4f59\u7684\u6309\u94ae\u88ab\u820d\u5f03");
                break;
            }
            Map.Entry entry = ite.next();
            ExportSkinLayoutXml.addSkinButtonLayout(root, (SkinButton)entry.getValue());
            ++index;
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        try {
            XMLWriter xmlWriter = new XMLWriter(new FileOutputStream(path + name), format);
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    static {
        mDatumMaps.put(1, "left");
        mDatumMaps.put(32, "bottom");
        mDatumMaps.put(2, "hcenter");
        mDatumMaps.put(16, "vcenter");
        mDatumMaps.put(8, "top");
        mDatumMaps.put(4, "right");
    }
}

