/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.config;

import java.util.ArrayList;
import sina.mobile.tianqitong.config.ConfigChangeListener;
import sina.mobile.tianqitong.config.ConfigChangedEvent;
import sina.mobile.tianqitong.util.Log;

public class Config {
    public static final String[] RESOLUTION = new String[]{"480X800 \u673a\u578b\uff1a\u4e09\u661f Galaxy SII, HTC G7,G10\u7b49", "480X854 \u673a\u578b\uff1aMOTO ME525, \u5c0f\u7c73MI1\u7b49", "480X640 \u673a\u578b\uff1aMOTO ME632, LG Vortex\u7b49", "640X960 \u673a\u578b\uff1a\u9b45\u65cf M9, MX\u7b49", "540X960 \u673a\u578b\uff1aHTC G14, MOTO XT910\u7b49", "320X480 \u673a\u578b\uff1a\u4e09\u661f S5830, HTC G13\u7b49", "720X1280 \uff08\u9ed8\u8ba4\uff09\u673a\u578b\uff1a\u4e09\u661f Galaxy SIII, HTC One X, \u5c0f\u7c73MI2\u7b49", "800X1280 \u673a\u578b\uff1a\u4e09\u661f Galaxy Note, \u7d22\u5c3c LT29I\u7b49"};
    public static final int R480X800 = 0;
    public static final int R480X854 = 1;
    public static final int R480X640 = 2;
    public static final int R640X960 = 3;
    public static final int R540X960 = 4;
    public static final int R320X480 = 5;
    public static final int R720X1280 = 6;
    public static final int R800X1280 = 7;
    public static final int R480X320 = 8;
    public static final int NORMAL = 1;
    public static final int SMALL = 2;
    public static final String[] SIZE_STRING = new String[]{"large", "normal", "small"};
    public static final int XHDPI = 0;
    public static final int HDPI = 1;
    public static final int MDPI = 2;
    public static final int LDPI = 3;
    public static final String[] DENSITY_STRING = new String[]{"xhdpi", "hdpi", "mdpi", "ldpi"};
    public static final float[] DENSITY = new float[]{2.0f, 1.5f, 1.0f, 0.75f};
    public static final int[] DPI = new int[]{320, 240, 160, 120};
    public static final int PORT = 0;
    public static final int LAND = 1;
    public static final String[] ORIENTATION_STRING = new String[]{"port", "land"};
    public static final int LONG = 0;
    public static final int NOTLONG = 1;
    public static final String[] ASPECT_RATIO_STRING = new String[]{"long", "notlong"};
    private String mResolution = RESOLUTION[6];
    private int mSize = 1;
    private int mDensity = 0;
    private int mOrientation = 0;
    private int mAspectRatio = 0;
    private ArrayList<ConfigChangeListener> mListeners = new ArrayList();

    public String[] setConfigurationByResolution(String str) {
        this.mResolution = str;
        if (str.startsWith("480X800")) {
            this.setSize(1);
            this.setDensity(1);
            this.setOrientation(0);
            this.setAspectRatio(1);
        } else if (str.startsWith("480X854")) {
            this.setSize(1);
            this.setDensity(1);
            this.setOrientation(0);
            this.setAspectRatio(0);
        } else if (str.startsWith("480X640")) {
            this.setSize(2);
            this.setDensity(1);
            this.setOrientation(0);
            this.setAspectRatio(1);
        } else if (str.startsWith("640X960")) {
            this.setSize(1);
            this.setDensity(1);
            this.setOrientation(0);
            this.setAspectRatio(1);
        } else if (str.startsWith("540X960")) {
            this.setSize(1);
            this.setDensity(1);
            this.setOrientation(0);
            this.setAspectRatio(0);
        } else if (str.startsWith("320X480")) {
            this.setSize(1);
            this.setDensity(2);
            this.setOrientation(0);
            this.setAspectRatio(1);
        } else if (str.startsWith("480X320")) {
            this.setSize(1);
            this.setDensity(2);
            this.setOrientation(1);
            this.setAspectRatio(1);
        } else if (str.startsWith("720X1280")) {
            this.setSize(1);
            this.setDensity(0);
            this.setOrientation(0);
            this.setAspectRatio(0);
        } else if (str.startsWith("800X1280")) {
            this.setSize(1);
            this.setDensity(0);
            this.setOrientation(0);
            this.setAspectRatio(1);
        }
        String orie = ORIENTATION_STRING[this.mOrientation];
        String aspe = ASPECT_RATIO_STRING[this.mAspectRatio];
        String dens = DENSITY_STRING[this.mDensity];
        String size = SIZE_STRING[this.mSize];
        Log.info("\u5206\u8fa8\u7387\u5207\u6362\uff1a" + orie + "," + aspe + "," + dens + "," + size);
        if (orie.equalsIgnoreCase("land")) {
            System.setProperty("skin.orientation", "port");
        } else {
            System.setProperty("skin.orientation", "land");
        }
        if (aspe.equalsIgnoreCase("notlong")) {
            System.setProperty("skin.aspectRadio", "notlong");
        } else {
            System.setProperty("skin.aspectRadio", "long");
        }
        if (dens.equalsIgnoreCase("xhdpi")) {
            System.setProperty("skin.dpi", "xhdpi");
            System.setProperty("skin.density", "2.0");
            System.setProperty("skin.densityDpi", "320");
        } else if (dens.equalsIgnoreCase("hdpi")) {
            System.setProperty("skin.dpi", "hdpi");
            System.setProperty("skin.density", "1.5");
            System.setProperty("skin.densityDpi", "240");
        } else if (dens.equalsIgnoreCase("mdpi")) {
            System.setProperty("skin.dpi", "mdpi");
            System.setProperty("skin.density", "1");
            System.setProperty("skin.densityDpi", "160");
        } else {
            System.setProperty("skin.dpi", "ldpi");
            System.setProperty("skin.density", "0.75");
            System.setProperty("skin.densityDpi", "120");
        }
        if (size.equalsIgnoreCase("large")) {
            System.setProperty("skin.size", "large");
        } else if (size.equalsIgnoreCase("normal")) {
            System.setProperty("skin.size", "normal");
        } else {
            System.setProperty("skin.size", "small");
        }
        return new String[]{orie, aspe, dens, size};
    }

    public String getResolution() {
        return this.mResolution;
    }

    public void setResolution(String mResolution) {
        this.mResolution = mResolution;
    }

    public void addChangedListener(ConfigChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void removeChangedListener(ConfigChangeListener listener) {
        this.mListeners.remove(listener);
    }

    public String getSizeString() {
        return SIZE_STRING[this.mSize];
    }

    public int getSize() {
        return this.mSize;
    }

    public String getDensityString() {
        return DENSITY_STRING[this.mDensity];
    }

    public int getDensity() {
        return this.mDensity;
    }

    public String getOrientationString() {
        return ORIENTATION_STRING[this.mOrientation];
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public String getAspectRatioString() {
        return ASPECT_RATIO_STRING[this.mAspectRatio];
    }

    public int getAspectRatio() {
        return this.mAspectRatio;
    }

    public void setSize(int newSize) {
        if (newSize != this.mSize) {
            this.mSize = newSize;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.get(i).sizeChanged(new ConfigChangedEvent(this), newSize);
            }
        }
    }

    public void setDensity(int newDensity) {
        if (newDensity != this.mDensity) {
            this.mDensity = newDensity;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.get(i).densityChanged(new ConfigChangedEvent(this), newDensity);
            }
        }
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation != this.mOrientation) {
            this.mOrientation = newOrientation;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.get(i).orientationChanged(new ConfigChangedEvent(this), newOrientation);
            }
        }
    }

    public void setAspectRatio(int newAspectRatio) {
        if (newAspectRatio != this.mAspectRatio) {
            this.mAspectRatio = newAspectRatio;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.get(i).aspectRatioChanged(new ConfigChangedEvent(this), newAspectRatio);
            }
        }
    }
}

