/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.GroupLayout;
import javax.swing.JDesktopPane;
import javax.swing.Scrollable;
import javax.swing.undo.UndoableEditSupport;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinImage;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.adapter.PictureAdapter;
import sina.mobile.tianqitong.adapter.RenderAdapter;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.adapter.SkinButtonAdapter;
import sina.mobile.tianqitong.adapter.SkinLayoutModelAdapter;
import sina.mobile.tianqitong.adapter.SkinUnitAdapter;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.io.SkinUnitOperator;
import sina.mobile.tianqitong.listener.MaterialPkgDragListener;
import sina.mobile.tianqitong.listener.SkinButtonListener;
import sina.mobile.tianqitong.listener.SkinButtonMultipleSelectedListener;
import sina.mobile.tianqitong.listener.SkinLayoutModelListener;
import sina.mobile.tianqitong.listener.SkinLayoutModelMultipleSelectedListener;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.material.MaterialTransferable;
import sina.mobile.tianqitong.observer.Notifier;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.uodoredo.SkinButtonEdit;
import sina.mobile.tianqitong.uodoredo.SkinButtonsEdit;
import sina.mobile.tianqitong.uodoredo.SkinLayoutModelEdit;
import sina.mobile.tianqitong.uodoredo.SkinLayoutModelsEdit;
import sina.mobile.tianqitong.uodoredo.UndoRedoHandler;
import sina.mobile.tianqitong.util.ButtonColorsHelper;
import sina.mobile.tianqitong.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinEditPane
extends JDesktopPane
implements Scrollable,
MouseListener,
MouseMotionListener,
KeyListener,
DropTargetListener {
    private SkinLayoutModelsEdit mLayoutModelsEdit;
    private SkinLayoutModelEdit mLayoutModelEdit;
    private SkinButtonsEdit mButtonsEdit;
    private SkinButtonEdit mButtonEdit;
    private final UndoRedoHandler mUndoRedoHandler;
    private final UndoableEditSupport mUndoRedoSupport;
    private SkinPkg mSkinPkg = null;
    private Graphics2D mG2d = null;
    private BufferedImage mSkinBufferImage = null;
    private int mTouchableOffsetX = 0;
    private int mTouchableOffsetY = 0;
    private Rectangle mSkinRect = new Rectangle();
    private Rectangle mSkinRealRect = new Rectangle();
    private SkinLayoutModelAdapter mFocusSkinLayoutModelAdapter = null;
    private SkinButtonAdapter mFocusSkinButtonAdapter = null;
    private SkinLayoutModelAdapter mSelectedSkinLayoutModelAdapter = null;
    private SkinButtonAdapter mSelectedSkinButtonAdapter = null;
    private ArrayList<SkinLayoutModelAdapter> mMultipleSelectedSkinLayoutModelAdapters = new ArrayList();
    private ArrayList<SkinButtonAdapter> mMultipleSelectedSkinButtonAdapters = new ArrayList();
    private boolean mShowTouchable = false;
    private ArrayList<SkinLayoutModelMultipleSelectedListener> mSkinLayoutModelMultipleSelectedListeners = new ArrayList();
    private ArrayList<SkinButtonMultipleSelectedListener> mSkinButtonMultipleSelectedListeners = new ArrayList();
    private ArrayList<SkinLayoutModelListener> mSkinUnitListeners = new ArrayList();
    private ArrayList<SkinButtonListener> mSkinButtonListeners = new ArrayList();
    private ArrayList<MaterialPkgDragListener> mMaterialPkgDragListeners = new ArrayList();
    private static final Cursor mNormalCursor = new Cursor(0);
    private static final Cursor mMoveCursor = new Cursor(13);
    private static final Cursor mEwMoveCursor = new Cursor(11);
    private static final Cursor mNsMoveCursor = new Cursor(9);
    private static final Cursor mSeMoveCursor = new Cursor(5);
    private static final Cursor mNeMoveCursor = new Cursor(7);
    private Point mPressedSkinLayoutModelPoint;
    private Point mMultiplePressedSkinLayoutModelPoint;
    private Point mPressedSkinPoint;
    private boolean mIsButtonMove = false;
    private boolean mIsMutipleButtonMove = false;
    private boolean mCanEdit = true;
    private boolean mIsMoving = false;
    private int mSkinOffsetX = 0;
    private int mSkinOffsetY = 0;
    private boolean mIsSingleMoveKeyPressed = false;
    private boolean mIsMultipleMoveKeyPressed = false;
    private boolean mIsAltPressed = false;
    private Point mButtonSelection = null;
    private Rectangle mSelectionRect = null;
    private Point mPressSelection = null;
    private SkinButtonAdapter lastSkinButtonAdapter = null;
    private Cursor mPressCursor;
    private Cursor mReleaseCursor;
    protected static double[] mZoomLevels = new double[]{1.0, 1.2, 1.4, 1.6, 1.8, 2.0};
    public static final int G_ZOOM_NORMALSIZE = 0;
    protected int mZoomLevel = 0;
    protected double mZoom = 1.0;

    public SkinEditPane() {
        this.initComponents();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.mUndoRedoHandler = new UndoRedoHandler(this);
        this.mUndoRedoSupport = new UndoableEditSupport();
        this.mUndoRedoSupport.addUndoableEditListener(this.mUndoRedoHandler);
    }

    public SkinLayoutModelsEdit getSkinLayoutModelsEdit() {
        return this.mLayoutModelsEdit;
    }

    public void setSkinLayoutModelsEdit(SkinLayoutModelsEdit skinLayoutModelsEdit) {
        this.mLayoutModelsEdit = skinLayoutModelsEdit;
    }

    public SkinLayoutModelEdit getSkinLayoutModelEdit() {
        return this.mLayoutModelEdit;
    }

    public void setSkinLayoutModelEdit(SkinLayoutModelEdit skinLayoutModelEdit) {
        this.mLayoutModelEdit = skinLayoutModelEdit;
    }

    private Cursor getReleaseCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = tk.getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/releasehand_cursor.png"));
        if (this.mReleaseCursor == null) {
            this.mReleaseCursor = tk.createCustomCursor(img, new Point(16, 8), "not move");
        }
        return this.mReleaseCursor;
    }

    private Cursor getPressCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = tk.getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/presshand_cursor.png"));
        if (this.mPressCursor == null) {
            this.mPressCursor = tk.createCustomCursor(img, new Point(16, 8), "move");
        }
        return this.mPressCursor;
    }

    public boolean zoomIn() {
        if (this.mZoomLevel < mZoomLevels.length - 1) {
            this.setZoomLevel(this.mZoomLevel + 1);
        }
        return this.mZoomLevel < mZoomLevels.length - 1;
    }

    public boolean zoomOut() {
        if (this.mZoomLevel > 0) {
            this.setZoomLevel(this.mZoomLevel - 1);
        }
        return this.mZoomLevel > 0;
    }

    private void setZoom(double zoom) {
        if (zoom > 0.0) {
            this.mZoom = zoom;
        }
    }

    public void setZoomLevel(int zoomLevel) {
        if (zoomLevel >= 0 && zoomLevel < mZoomLevels.length) {
            this.mZoomLevel = zoomLevel;
            this.setZoom(mZoomLevels[zoomLevel]);
        }
    }

    public boolean isMoving() {
        return this.mIsMoving;
    }

    public void setMoving(boolean isMoving) {
        this.mIsMoving = isMoving;
        if (isMoving) {
            this.setSelectedSkinButton(null);
            this.setSelectedSkinLayoutModel(null);
        }
    }

    public boolean isCanEdit() {
        return this.mCanEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.mCanEdit = canEdit;
        if (!canEdit) {
            this.setSelectedSkinButton(null);
            this.setSelectedSkinLayoutModel(null);
        }
    }

    public UndoableEditSupport getUndoRedoSupport() {
        return this.mUndoRedoSupport;
    }

    public UndoRedoHandler getUndoRedoHandler() {
        return this.mUndoRedoHandler;
    }

    public void clearSkinBufferImage() {
        this.mSkinBufferImage = null;
    }

    public BufferedImage getSkinBufferImage() {
        return this.mSkinBufferImage;
    }

    public BufferedImage getSkinRealBufferImage() {
        if (this.mSkinBufferImage == null) {
            return null;
        }
        return this.mSkinBufferImage.getSubimage(this.mSkinRealRect.x, this.mSkinRealRect.y, this.mSkinRealRect.width, this.mSkinRealRect.height);
    }

    public void addSkinButtonListener(SkinButtonListener skinUnitListener) {
        this.mSkinButtonListeners.add(skinUnitListener);
    }

    public void addMaterialPkgDragListener(MaterialPkgDragListener skinUnitListener) {
        this.mMaterialPkgDragListeners.add(skinUnitListener);
    }

    public void removeMaterialPkgDragListener(MaterialPkgDragListener skinUnitListener) {
        this.mMaterialPkgDragListeners.remove(skinUnitListener);
    }

    public void removeSkinButtonListener(SkinButtonListener skinUnitListener) {
        this.mSkinButtonListeners.remove(skinUnitListener);
    }

    public void addSkinLayoutModelMultipleSelectedListener(SkinLayoutModelMultipleSelectedListener skinUnitListener) {
        this.mSkinLayoutModelMultipleSelectedListeners.add(skinUnitListener);
    }

    public void removeSkinLayoutModelMultipleSelectedListener(SkinLayoutModelMultipleSelectedListener skinUnitListener) {
        this.mSkinLayoutModelMultipleSelectedListeners.remove(skinUnitListener);
    }

    public void addSkinButtonMultipleSelectedListener(SkinButtonMultipleSelectedListener skinUnitListener) {
        this.mSkinButtonMultipleSelectedListeners.add(skinUnitListener);
    }

    public void removeSkinButtoMultipleSelectedListener(SkinButtonMultipleSelectedListener skinUnitListener) {
        this.mSkinButtonMultipleSelectedListeners.remove(skinUnitListener);
    }

    public void addSkinUnitListener(SkinLayoutModelListener skinUnitListener) {
        this.mSkinUnitListeners.add(skinUnitListener);
    }

    public void removeSkinUnitListener(SkinLayoutModelListener skinUnitListener) {
        this.mSkinUnitListeners.remove(skinUnitListener);
    }

    public boolean isShowTouchable() {
        return this.mShowTouchable;
    }

    public void setShowTouchable(boolean showTouchable) {
        if (this.mShowTouchable != showTouchable) {
            this.mShowTouchable = showTouchable;
            if (showTouchable) {
                this.mSelectedSkinLayoutModelAdapter = null;
                this.mMultipleSelectedSkinLayoutModelAdapters.clear();
                this.mFocusSkinLayoutModelAdapter = null;
            } else {
                this.mSelectedSkinButtonAdapter = null;
                this.mMultipleSelectedSkinButtonAdapters.clear();
                this.mFocusSkinButtonAdapter = null;
            }
            this.repaintSkin();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height / 16 * 16;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        this.repaint();
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        this.repaint();
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getParent() == null) {
            return new Dimension(0, 0);
        }
        Dimension size = this.getParent().getSize();
        return new Dimension(Math.max(this.getPxByZoom(this.mSkinRect.width), size.width), Math.max(this.getPxByZoom(this.mSkinRect.height), size.height));
    }

    public void setSkinPkg(SkinPkg pkg) {
        this.mSkinPkg = pkg;
        if (this.mSkinBufferImage != null) {
            this.mSkinBufferImage = null;
        }
        if (this.mG2d != null) {
            this.mG2d.dispose();
            this.mG2d = null;
        }
        this.cleanAllSelectedOrFocusedStateWithoutFeedback();
        this.repaintSkin();
    }

    public SkinPkg getSkinPkg() {
        return this.mSkinPkg;
    }

    public void setSelectedSkinButton(SkinButtonAdapter skinUnit) {
        this.mSelectedSkinButtonAdapter = skinUnit;
        this.repaint();
        this.fireSelectedSkinButton(skinUnit);
    }

    private void fireSelectedSkinButton(SkinButtonAdapter skinUnit) {
        if (skinUnit != null) {
            this.mButtonEdit = new SkinButtonEdit(skinUnit, (SkinButtonAdapter)this.getSkinUnitCopy(skinUnit), null);
        }
        for (int i = 0; i < this.mSkinButtonListeners.size(); ++i) {
            this.mSkinButtonListeners.get(i).skinButtonSelected(skinUnit);
        }
    }

    private void fireDragedMaterialPkg(MaterialPkg skinUnitAdapter, Point location) {
        for (int i = 0; i < this.mMaterialPkgDragListeners.size(); ++i) {
            this.mMaterialPkgDragListeners.get(i).materialPkgDraged(skinUnitAdapter, location);
        }
    }

    public void setSelectedSkinButtonWithoutFeedback(SkinButtonAdapter skinUnit) {
        if (this.mSelectedSkinButtonAdapter != skinUnit) {
            this.mSelectedSkinButtonAdapter = skinUnit;
            this.repaint();
        }
    }

    public void setFocusSkinButton(SkinButtonAdapter skinUnit) {
        if (this.mFocusSkinButtonAdapter != skinUnit) {
            this.mFocusSkinButtonAdapter = skinUnit;
            this.repaint();
        }
    }

    public void setFocusSkinLayoutModel(SkinLayoutModelAdapter skinUnit) {
        if (this.mFocusSkinLayoutModelAdapter != skinUnit) {
            this.mFocusSkinLayoutModelAdapter = skinUnit;
            this.repaint();
        }
    }

    public void cleanAllSelectedOrFocusedStateWithoutFeedback() {
        this.mFocusSkinButtonAdapter = null;
        this.mFocusSkinLayoutModelAdapter = null;
        this.mSelectedSkinButtonAdapter = null;
        this.mSelectedSkinLayoutModelAdapter = null;
        this.mMultipleSelectedSkinButtonAdapters.clear();
        this.mMultipleSelectedSkinLayoutModelAdapters.clear();
        this.repaint();
    }

    public void cleanAllSelectedOrFocusedState() {
        this.mFocusSkinButtonAdapter = null;
        this.mFocusSkinLayoutModelAdapter = null;
        this.setSelectedSkinButton(null);
        this.setSelectedSkinLayoutModel(null);
        this.mMultipleSelectedSkinButtonAdapters.clear();
        this.mMultipleSelectedSkinLayoutModelAdapters.clear();
        this.repaint();
    }

    public void setSelectedSkinLayoutModel(SkinLayoutModelAdapter skinUnit) {
        this.mSelectedSkinLayoutModelAdapter = skinUnit;
        this.repaint();
        this.fireSelectedSkinLayoutModel(skinUnit);
    }

    private void fireSelectedSkinLayoutModel(SkinLayoutModelAdapter skinUnit) {
        if (skinUnit != null) {
            this.mLayoutModelEdit = new SkinLayoutModelEdit(skinUnit, (SkinLayoutModelAdapter)this.getSkinUnitCopy(skinUnit), null);
        }
        for (int i = 0; i < this.mSkinUnitListeners.size(); ++i) {
            this.mSkinUnitListeners.get(i).skinLayoutModelSelected(skinUnit);
        }
    }

    public void setSelectedSkinLayoutModelWithoutFeedback(SkinLayoutModelAdapter skinUnit) {
        if (this.mSelectedSkinLayoutModelAdapter != skinUnit) {
            this.mSelectedSkinLayoutModelAdapter = skinUnit;
            this.repaint();
        }
    }

    private void fireMultipleSelectedSkinLayoutModelsSelected(ArrayList<SkinLayoutModelAdapter> skinUnitAdapters) {
        if (skinUnitAdapters == null) {
            return;
        }
        this.mLayoutModelsEdit = new SkinLayoutModelsEdit(this.skinLayoutModelsToSkinUnits(skinUnitAdapters), this.skinLayoutModelsToSkinUnits(this.getSkinLayoutModelsCopy(skinUnitAdapters)), null);
        for (int i = 0; i < this.mSkinLayoutModelMultipleSelectedListeners.size(); ++i) {
            this.mSkinLayoutModelMultipleSelectedListeners.get(i).skinLayoutModelMultipleSelected(skinUnitAdapters);
        }
    }

    private void fireMultipleSelectedSkinLayoutModelsMoved(ArrayList<SkinLayoutModelAdapter> skinUnitAdapters) {
        if (this.mLayoutModelsEdit == null) {
            return;
        }
        this.mLayoutModelsEdit.setPresentationName("\u79fb\u52a8\u591a\u4e2a\u76ae\u80a4\u5143\u7d20");
        for (int i = 0; i < this.mSkinLayoutModelMultipleSelectedListeners.size(); ++i) {
            this.mSkinLayoutModelMultipleSelectedListeners.get(i).skinLayoutModelMultipleSelectedMoved(skinUnitAdapters);
        }
    }

    private void fireMultipleSelectedSkinButtonsSelected(ArrayList<SkinButtonAdapter> skinUnitAdapters) {
        if (skinUnitAdapters == null) {
            return;
        }
        this.mButtonsEdit = new SkinButtonsEdit(this.skinButtonsToSkinUnits(skinUnitAdapters), this.skinButtonsToSkinUnits(this.getSkinButtonsCopy(skinUnitAdapters)), null);
        for (int i = 0; i < this.mSkinButtonMultipleSelectedListeners.size(); ++i) {
            this.mSkinButtonMultipleSelectedListeners.get(i).skinButtonMultipleSelected(skinUnitAdapters);
        }
    }

    private void fireMultipleSelectedSkinButtonsMoved(ArrayList<SkinButtonAdapter> skinUnitAdapters) {
        if (this.mButtonsEdit == null) {
            return;
        }
        this.mButtonsEdit.setPresentationName("\u79fb\u52a8\u591a\u4e2a\u6309\u94ae\u5143\u7d20");
        for (int i = 0; i < this.mSkinButtonMultipleSelectedListeners.size(); ++i) {
            this.mSkinButtonMultipleSelectedListeners.get(i).skinButtonMultipleSelectedMoved(skinUnitAdapters);
        }
    }

    public ArrayList<SkinButtonAdapter> getMultipleSelectedSkinButtonAdapters() {
        return this.mMultipleSelectedSkinButtonAdapters;
    }

    public void setMultipleSelectedSkinButtonAdapters(ArrayList<SkinButtonAdapter> mMultipleSelectedSkinButtonAdapters) {
        this.mMultipleSelectedSkinButtonAdapters = mMultipleSelectedSkinButtonAdapters;
        this.fireMultipleSelectedSkinButtonsSelected(mMultipleSelectedSkinButtonAdapters);
        this.repaint();
    }

    public void setMultipleSelectedSkinButtonAdaptersWithoutFeedback(ArrayList<SkinButtonAdapter> mMultipleSelectedSkinButtonAdapters) {
        this.mMultipleSelectedSkinButtonAdapters = mMultipleSelectedSkinButtonAdapters;
        this.repaint();
    }

    public ArrayList<SkinLayoutModelAdapter> getMultipleSelectedSkinLayoutModelAdapters() {
        return this.mMultipleSelectedSkinLayoutModelAdapters;
    }

    public void setMultipleSelectedSkinLayoutModelAdapters(ArrayList<SkinLayoutModelAdapter> mMultipleSelectedSkinLayoutModelAdapters) {
        this.mMultipleSelectedSkinLayoutModelAdapters = mMultipleSelectedSkinLayoutModelAdapters;
        this.fireMultipleSelectedSkinLayoutModelsSelected(mMultipleSelectedSkinLayoutModelAdapters);
        this.repaint();
    }

    public void setMultipleSelectedSkinLayoutModelAdaptersWithoutFeedback(ArrayList<SkinLayoutModelAdapter> mMultipleSelectedSkinLayoutModelAdapters) {
        this.mMultipleSelectedSkinLayoutModelAdapters = mMultipleSelectedSkinLayoutModelAdapters;
        this.repaint();
    }

    public SkinLayoutModelAdapter getSelectedSkinLayoutModelAdapter() {
        return this.mSelectedSkinLayoutModelAdapter;
    }

    public SkinButtonAdapter getSelectedSkinButtonAdapter() {
        return this.mSelectedSkinButtonAdapter;
    }

    private void measureSkinRealRect() {
        if (this.mSkinPkg == null) {
            return;
        }
        String str = AppData.getInstance().mConfig.getResolution();
        String resolution = str.split(" ")[0];
        this.mSkinRealRect.x = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).x);
        this.mSkinRealRect.y = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).y);
        this.mSkinRealRect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).width);
        this.mSkinRealRect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRealSkinRect((String)resolution).height);
    }

    private void measureSkinRect() {
        if (this.mSkinPkg == null) {
            return;
        }
        this.mSkinRect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinRect().width);
        this.mSkinRect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinRect().height);
    }

    private int getPxByZoom(double i) {
        return (int)Math.round(i * this.mZoom);
    }

    private int getPxByZoom(int i) {
        return (int)Math.round((double)i * this.mZoom);
    }

    private void measureSkinOffset() {
        if (this.mSkinPkg == null) {
            return;
        }
        this.mTouchableOffsetX = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinOffsetPoint().x);
        this.mTouchableOffsetY = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getSkinOffsetPoint().y);
    }

    public void repaintSkin() {
        if (this.mSkinPkg == null) {
            return;
        }
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return;
        }
        this.measureSkinRect();
        this.measureSkinRealRect();
        this.measureSkinOffset();
        this.mSkinBufferImage = new BufferedImage(this.mSkinRect.width, this.mSkinRect.height, 2);
        if (this.mSkinPkg != null) {
            this.mG2d = this.mSkinBufferImage.createGraphics();
            RenderAdapter iRender = new RenderAdapter();
            iRender.setGraphics2D(this.mG2d);
            SkinRender skinRender = new SkinRender();
            skinRender.setRender(iRender);
            Skin skin = skinAdapter.getSkin();
            skin.draw(skinRender);
            this.drawButton();
            skinAdapter.measureSkinUnitAdapterRect();
        }
        this.updateUI();
    }

    private void drawButton() {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return;
        }
        for (int i = 0; i < skinAdapter.skinUnitAdapterCount(); ++i) {
            Rectangle rect;
            BufferedImage src;
            SkinButton button;
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinButtonAdapter) || (button = (SkinButton)unit.getSkinUnit()).getFunctionId().equals("app") && button.getIntoClock() == null || ((SkinButtonAdapter)unit).getSkinUnit().getIdx() < 0 || ((SkinButtonAdapter)unit).getSkinUnit().getIdx() >= this.getSkinButtonCount()) continue;
            if (!((SkinButtonAdapter)unit).isClicked() && button.getSrc() != null) {
                src = ((PictureAdapter)button.getSrcCachePicture().getPicture()).getBufferedImage();
                rect = this.getRectangleByIdx(button.getIdx());
                this.mG2d.drawImage(src, rect.x, rect.y, button.getPictureRect().width(), button.getPictureRect().height(), null);
                continue;
            }
            if (button.getStopPlayingSrc() == null) continue;
            src = ((PictureAdapter)button.getStopPlayingSrcCachePicture().getPicture()).getBufferedImage();
            rect = this.getRectangleByIdx(button.getIdx());
            this.mG2d.drawImage(src, rect.x, rect.y, button.getPictureRect().width(), button.getPictureRect().height(), null);
        }
    }

    private Rectangle getRectangleByIdx(int idx) {
        Rectangle rect = new Rectangle();
        if (this.mSkinPkg == null) {
            return rect;
        }
        rect.x = this.mTouchableOffsetX + SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).x);
        rect.y = this.mTouchableOffsetY + SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).y);
        rect.width = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).width);
        rect.height = SkinHelper.px("" + this.mSkinPkg.getSkinFramework().getRectByButtonIdx((int)idx).height);
        return rect;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void drawRealRect(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(1.0f, 0, 0));
        g.setColor(new Color(4557568));
        g.drawRect(this.getPxByZoom(this.mSkinRealRect.x), this.getPxByZoom(this.mSkinRealRect.y), this.getPxByZoom(this.mSkinRealRect.width), this.getPxByZoom(this.mSkinRealRect.height));
        g.setStroke(oldStroke);
    }

    private void drawSkinRect(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        float[] arr = new float[]{4.0f, 2.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.0f, arr, 0.0f);
        g.setStroke(stroke);
        g.setColor(new Color(0xFF4040));
        g.drawRect(0, 0, this.getPxByZoom(this.mSkinRect.width), this.getPxByZoom(this.mSkinRect.height));
        g.setStroke(oldStroke);
    }

    private void drawButtonRect(Graphics2D g, int count) {
        for (int i = 0; i < count; ++i) {
            Rectangle rect = this.getRectangleByIdx(i);
            g.drawRect(this.getPxByZoom(rect.x), this.getPxByZoom(rect.y), this.getPxByZoom(rect.width), this.getPxByZoom(rect.height));
        }
    }

    private void drawTouchable(Graphics2D g2) {
        g2.setStroke(new BasicStroke(1.0f, 0, 0));
        g2.setColor(new Color(16727702));
        this.drawButtonRect(g2, this.getSkinButtonCount());
        if (AppData.getInstance().getSkinAdapter() == null) {
            return;
        }
        for (int i = 0; i < AppData.getInstance().getSkinAdapter().skinUnitAdapterCount(); ++i) {
            SkinButton button;
            AbSkinUnit unit = AppData.getInstance().getSkinAdapter().getSkinUnitAdapter(i).getSkinUnit();
            if (!(unit instanceof SkinButton) || (button = (SkinButton)unit).getFunctionId().equals("app") && button.getIntoClock() == null || button.getIdx() < 0 || button.getIdx() >= this.getSkinButtonCount()) continue;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            g2.setColor(ButtonColorsHelper.getButtonColor(button.getFunctionId()));
            Rectangle rect = this.getRectangleByIdx(button.getIdx());
            g2.fillRect(this.getPxByZoom(rect.x), this.getPxByZoom(rect.y), this.getPxByZoom(rect.width), this.getPxByZoom(rect.height));
            g2.setComposite(oldComposite);
        }
    }

    private void drawButtonSelection(Graphics2D g2) {
        if (this.mButtonSelection != null && this.mSelectedSkinButtonAdapter != null) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            Rectangle rect = this.getRectangleByIdx(this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx());
            rect.x = this.getPxByZoom(rect.x);
            rect.y = this.getPxByZoom(rect.y);
            rect.width = this.getPxByZoom(rect.width);
            rect.height = this.getPxByZoom(rect.height);
            rect.add(this.mButtonSelection);
            g2.setColor(new Color(16727702));
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            g2.setComposite(oldComposite);
        }
    }

    private void drawSelectedSkinButton(Graphics2D g2) {
        if (this.mSelectedSkinButtonAdapter == null) {
            return;
        }
        if (this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx() >= 0 && this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx() < this.getSkinButtonCount()) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            g2.setColor(new Color(16766720));
            Rectangle rect = this.getRectangleByIdx(this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx());
            g2.fillRect(this.getPxByZoom(rect.x), this.getPxByZoom(rect.y), this.getPxByZoom(rect.width), this.getPxByZoom(rect.height));
            g2.setComposite(oldComposite);
        }
    }

    private void drawMultipleSelectedSkinButton(Graphics2D g2) {
        if (this.mMultipleSelectedSkinButtonAdapters.isEmpty()) {
            return;
        }
        Composite oldComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
        for (SkinButtonAdapter buttonAdapter : this.mMultipleSelectedSkinButtonAdapters) {
            if (buttonAdapter == null || buttonAdapter.getSkinUnit().getIdx() < 0 || buttonAdapter.getSkinUnit().getIdx() >= this.getSkinButtonCount()) continue;
            g2.setColor(new Color(16759055));
            Rectangle rect = this.getRectangleByIdx(buttonAdapter.getSkinUnit().getIdx());
            g2.fillRect(this.getPxByZoom(rect.x), this.getPxByZoom(rect.y), this.getPxByZoom(rect.width), this.getPxByZoom(rect.height));
        }
        g2.setComposite(oldComposite);
    }

    private void drawMultipleSelectedSkinUnit(Graphics2D g2) {
        if (this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
            return;
        }
        Stroke oldStroke = g2.getStroke();
        AffineTransform oldTransform = g2.getTransform();
        Object oldHind = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f, 0, 0));
        g2.setColor(new Color(8306926));
        for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
            if (layoutModelAdapter == null) continue;
            if (layoutModelAdapter.getSkinUnit() instanceof SkinImage) {
                Calendar calendar;
                int py;
                int px;
                if ("clock_hourhand".equals(((SkinImage)layoutModelAdapter.getSkinUnit()).getFunctionId())) {
                    int w = layoutModelAdapter.getSkinUnit().getDrawRect().width();
                    int h = layoutModelAdapter.getSkinUnit().getDrawRect().height();
                    px = layoutModelAdapter.getSkinUnit().getDrawRect().left;
                    py = layoutModelAdapter.getSkinUnit().getDrawRect().top;
                    calendar = Calendar.getInstance();
                    int hour = calendar.get(10);
                    int minute = calendar.get(12);
                    float time = (float)hour + (float)minute / 60.0f;
                    float degrees = time * 360.0f / 12.0f;
                    AffineTransform newat = new AffineTransform();
                    newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                    newat.translate(this.getX(), this.getY());
                    newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                    newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                    g2.setTransform(newat);
                } else if ("clock_minutehand".equals(((SkinImage)layoutModelAdapter.getSkinUnit()).getFunctionId())) {
                    int w = layoutModelAdapter.getSkinUnit().getDrawRect().width();
                    int h = layoutModelAdapter.getSkinUnit().getDrawRect().height();
                    px = layoutModelAdapter.getSkinUnit().getDrawRect().left;
                    py = layoutModelAdapter.getSkinUnit().getDrawRect().top;
                    calendar = Calendar.getInstance();
                    int minute = calendar.get(12);
                    float degrees = (float)minute * 360.0f / 60.0f;
                    AffineTransform newat = new AffineTransform();
                    newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                    newat.translate(this.getX(), this.getY());
                    newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                    newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                    g2.setTransform(newat);
                }
            }
            SkinLayoutModel skinUnit = layoutModelAdapter.getSkinUnit();
            SkinRect rect = skinUnit.getDrawRect();
            if (skinUnit instanceof SkinImage) {
                g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()));
            } else {
                g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()) + 5);
            }
            g2.setTransform(oldTransform);
        }
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHind);
    }

    private void drawFocusSkinButton(Graphics2D g2) {
        if (this.mFocusSkinButtonAdapter == null) {
            return;
        }
        if (this.mFocusSkinButtonAdapter.getSkinUnit().getIdx() >= 0 && this.mFocusSkinButtonAdapter.getSkinUnit().getIdx() < this.getSkinButtonCount()) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            Rectangle rect = this.getRectangleByIdx(this.mFocusSkinButtonAdapter.getSkinUnit().getIdx());
            g2.setColor(new Color(16752762));
            g2.fillRect(this.getPxByZoom(rect.x), this.getPxByZoom(rect.y), this.getPxByZoom(rect.width), this.getPxByZoom(rect.height));
            g2.setComposite(oldComposite);
        }
    }

    private void drawFocusSkinUnit(Graphics2D g2) {
        if (this.mFocusSkinLayoutModelAdapter == null) {
            return;
        }
        Stroke oldStroke = g2.getStroke();
        AffineTransform oldTransform = g2.getTransform();
        Object oldHind = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f, 0, 0));
        g2.setColor(new Color(14315734));
        if (this.mFocusSkinLayoutModelAdapter.getSkinUnit() instanceof SkinImage) {
            int h;
            int w;
            if ("clock_hourhand".equals(((SkinImage)this.mFocusSkinLayoutModelAdapter.getSkinUnit()).getFunctionId())) {
                w = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().width();
                h = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().height();
                int px = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().left;
                int py = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().top;
                Calendar calendar = Calendar.getInstance();
                int hour = calendar.get(10);
                int minute = calendar.get(12);
                float time = (float)hour + (float)minute / 60.0f;
                float degrees = time * 360.0f / 12.0f;
                AffineTransform newat = new AffineTransform();
                newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                newat.translate(this.getX(), this.getY());
                newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                g2.setTransform(newat);
            } else if ("clock_minutehand".equals(((SkinImage)this.mFocusSkinLayoutModelAdapter.getSkinUnit()).getFunctionId())) {
                w = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().width();
                h = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().height();
                int px = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().left;
                int py = this.mFocusSkinLayoutModelAdapter.getSkinUnit().getDrawRect().top;
                Calendar calendar = Calendar.getInstance();
                int minute = calendar.get(12);
                float degrees = (float)minute * 360.0f / 60.0f;
                AffineTransform newat = new AffineTransform();
                newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                newat.translate(this.getX(), this.getY());
                newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                g2.setTransform(newat);
            }
        }
        SkinLayoutModel skinUnit = this.mFocusSkinLayoutModelAdapter.getSkinUnit();
        SkinRect rect = skinUnit.getDrawRect();
        if (skinUnit instanceof SkinImage) {
            g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()));
        } else {
            g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()) + 5);
        }
        g2.setTransform(oldTransform);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHind);
    }

    private void drawSelectedSkinUnit(Graphics2D g2) {
        if (this.mSelectedSkinLayoutModelAdapter == null) {
            return;
        }
        Stroke oldStroke = g2.getStroke();
        AffineTransform oldTransform = g2.getTransform();
        Object oldHind = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.0f, 0, 0));
        g2.setColor(new Color(0x8EE5EE));
        if (this.mSelectedSkinLayoutModelAdapter.getSkinUnit() instanceof SkinImage) {
            int h;
            int w;
            if ("clock_hourhand".equals(((SkinImage)this.mSelectedSkinLayoutModelAdapter.getSkinUnit()).getFunctionId())) {
                w = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().width();
                h = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().height();
                int px = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().left;
                int py = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().top;
                Calendar calendar = Calendar.getInstance();
                int hour = calendar.get(10);
                int minute = calendar.get(12);
                float time = (float)hour + (float)minute / 60.0f;
                float degrees = time * 360.0f / 12.0f;
                AffineTransform newat = new AffineTransform();
                Log.info("x:" + this.getX());
                newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                newat.translate(this.getX(), this.getY());
                newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                g2.setTransform(newat);
            } else if ("clock_minutehand".equals(((SkinImage)this.mSelectedSkinLayoutModelAdapter.getSkinUnit()).getFunctionId())) {
                w = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().width();
                h = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().height();
                int px = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().left;
                int py = this.mSelectedSkinLayoutModelAdapter.getSkinUnit().getDrawRect().top;
                Calendar calendar = Calendar.getInstance();
                int minute = calendar.get(12);
                float degrees = (float)minute * 360.0f / 60.0f;
                AffineTransform newat = new AffineTransform();
                newat.translate(this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                newat.translate(this.getX(), this.getY());
                newat.translate(this.getPxByZoom(-w / 2), this.getPxByZoom(-h / 2));
                newat.rotate(Math.toRadians(degrees), this.getPxByZoom(px + w / 2), this.getPxByZoom(py + h / 2));
                g2.setTransform(newat);
            }
        }
        SkinLayoutModel skinUnit = this.mSelectedSkinLayoutModelAdapter.getSkinUnit();
        SkinRect rect = skinUnit.getDrawRect();
        if (skinUnit instanceof SkinImage) {
            g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()));
        } else {
            g2.drawRect(this.getPxByZoom(rect.left), this.getPxByZoom(rect.top), this.getPxByZoom(rect.width()), this.getPxByZoom(rect.height()) + 5);
        }
        g2.setStroke(oldStroke);
        g2.setTransform(oldTransform);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHind);
    }

    private void drawSkinSize(Graphics2D g2) {
        Object oldHind = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Font oldFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        g2.setColor(new Color(0xF0F8FF));
        g2.drawString("\u63d2\u4ef6\u5927\u5c0f", this.getWidth() - 64, this.getHeight() - 16 - 16);
        g2.setColor(new Color(0xF0F8FF));
        g2.drawString(this.mSkinRealRect.width + "X" + this.mSkinRealRect.height, this.getWidth() - 64, this.getHeight() - 16);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHind);
        g2.setFont(oldFont);
    }

    private void drawSkinTip(Graphics2D g2) {
        Object oldHind = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Font oldFont = g2.getFont();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 13));
        g2.setColor(new Color(4557568));
        g2.drawString("\u7eff\u8272\u7ebf\u6846\u4e3a\u5b89\u5168\u8303\u56f4\uff08\u8d85\u51fa\u90e8\u5206\u4e0d\u663e\u793a\uff09", 8, 24);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHind);
        g2.setFont(oldFont);
    }

    private void drawSkinImage(Graphics2D g2) {
        if (this.mSkinBufferImage == null) {
            return;
        }
        g2.drawImage(this.mSkinBufferImage.getScaledInstance(this.getPxByZoom(this.mSkinRect.getWidth()), this.getPxByZoom(this.mSkinRect.getHeight()), 2), 0, 0, null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Colors.LIGHT_AREA);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mSkinPkg != null) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.mSkinBufferImage != null) {
                int offsetX = this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2;
                int offsetY = this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2;
                this.drawSkinSize(g2);
                this.drawSkinTip(g2);
                g2.translate(offsetX, offsetY);
                this.drawSkinImage(g2);
                if (this.mFocusSkinLayoutModelAdapter != null && this.mFocusSkinLayoutModelAdapter.getSkinUnit() != null) {
                    this.drawFocusSkinUnit(g2);
                }
                if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                    this.drawMultipleSelectedSkinUnit(g2);
                }
                if (this.mSelectedSkinLayoutModelAdapter != null && this.mSelectedSkinLayoutModelAdapter.getSkinUnit() != null) {
                    this.drawSelectedSkinUnit(g2);
                }
                if (this.mShowTouchable) {
                    this.drawTouchable(g2);
                    if (this.mFocusSkinButtonAdapter != null && this.mFocusSkinButtonAdapter.getSkinUnit() != null) {
                        this.drawFocusSkinButton(g2);
                    }
                    if (!this.mMultipleSelectedSkinButtonAdapters.isEmpty()) {
                        this.drawMultipleSelectedSkinButton(g2);
                    }
                    if (this.mSelectedSkinButtonAdapter != null && this.mSelectedSkinButtonAdapter.getSkinUnit() != null) {
                        this.drawSelectedSkinButton(g2);
                    }
                    if (this.mButtonSelection != null && this.mSelectedSkinButtonAdapter != null) {
                        this.drawButtonSelection(g2);
                    }
                }
                this.drawSkinRect(g2);
                this.drawRealRect(g2);
                if (this.mSelectionRect != null) {
                    this.drawSelectionRect(g2);
                }
                g2.translate(-offsetX, -offsetY);
            }
        }
    }

    private void drawSelectionRect(Graphics2D g2) {
        if (this.mSelectionRect != null) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            g2.setColor(new Color(8306926));
            g2.fillRect(this.mSelectionRect.x, this.mSelectionRect.y, this.mSelectionRect.width, this.mSelectionRect.height);
            g2.setColor(new Color(4286945));
            g2.drawRect(this.mSelectionRect.x, this.mSelectionRect.y, this.mSelectionRect.width, this.mSelectionRect.height);
            g2.setComposite(oldComposite);
        }
    }

    private void fireSkinButtonMoved(SkinButtonAdapter unit) {
        if (unit == null || this.mButtonEdit == null) {
            return;
        }
        this.mButtonEdit.setPresentationName("\u79fb\u52a8\u6309\u94ae\u5355\u5143");
        for (int i = 0; i < this.mSkinButtonListeners.size(); ++i) {
            this.mSkinButtonListeners.get(i).skinButtonMoved(unit);
        }
    }

    private void fireSkinLayoutModelMoved(SkinLayoutModelAdapter unit) {
        if (unit == null || this.mLayoutModelEdit == null) {
            return;
        }
        this.mLayoutModelEdit.setPresentationName("\u79fb\u52a8\u76ae\u80a4\u5355\u5143");
        for (int i = 0; i < this.mSkinUnitListeners.size(); ++i) {
            this.mSkinUnitListeners.get(i).skinLayoutModelMoved(unit);
        }
    }

    public int getSkinButtonCount() {
        if (this.mSkinPkg == null) {
            return 0;
        }
        int count = this.mSkinPkg.getSkinFramework().getSkinButtonCount();
        return count;
    }

    public SkinButtonAdapter getSkinButtonByLocation(int x, int y) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return null;
        }
        for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
            SkinButtonAdapter buttonAdapter;
            SkinButton button;
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinButtonAdapter) || (button = (buttonAdapter = (SkinButtonAdapter)unit).getSkinUnit()).getFunctionId().equals("app") && button.getIntoClock() == null) continue;
            Rectangle rect = this.getRectangleByIdx(button.getIdx());
            if (x <= this.getPxByZoom(rect.x) || x >= this.getPxByZoom(rect.x + rect.width) || y <= this.getPxByZoom(rect.y) || y >= this.getPxByZoom(rect.y + rect.height)) continue;
            return buttonAdapter;
        }
        return null;
    }

    public int getIDByLocation(int x, int y) {
        for (int i = 0; i < this.getSkinButtonCount(); ++i) {
            Rectangle rect = this.getRectangleByIdx(i);
            if (x < this.getPxByZoom(rect.x) || x > this.getPxByZoom(rect.x + rect.width) || y < this.getPxByZoom(rect.y) || y > this.getPxByZoom(rect.y + rect.height)) continue;
            return i;
        }
        return -1;
    }

    private ArrayList<SkinButtonAdapter> getSkinButtonsCopy(ArrayList<SkinButtonAdapter> units) {
        ArrayList<SkinButtonAdapter> unitsAdapters = new ArrayList<SkinButtonAdapter>();
        try {
            for (int i = 0; i < units.size(); ++i) {
                if (units.get(i) == null) continue;
                unitsAdapters.add(units.get(i).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return unitsAdapters;
    }

    public ArrayList<SkinLayoutModelAdapter> getSkinLayoutModelsCopy(ArrayList<SkinLayoutModelAdapter> units) {
        ArrayList<SkinLayoutModelAdapter> unitsAdapters = new ArrayList<SkinLayoutModelAdapter>();
        try {
            for (int i = 0; i < units.size(); ++i) {
                if (units.get(i) == null) continue;
                unitsAdapters.add(units.get(i).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return unitsAdapters;
    }

    public ArrayList<SkinUnitAdapter> skinLayoutModelsToSkinUnits(ArrayList<SkinLayoutModelAdapter> units) {
        ArrayList<SkinUnitAdapter> unitsAdapters = new ArrayList<SkinUnitAdapter>();
        for (int i = 0; i < units.size(); ++i) {
            if (units.get(i) == null) continue;
            unitsAdapters.add(units.get(i));
        }
        return unitsAdapters;
    }

    public ArrayList<SkinUnitAdapter> skinButtonsToSkinUnits(ArrayList<SkinButtonAdapter> units) {
        ArrayList<SkinUnitAdapter> unitsAdapters = new ArrayList<SkinUnitAdapter>();
        for (int i = 0; i < units.size(); ++i) {
            if (units.get(i) == null) continue;
            unitsAdapters.add(units.get(i));
        }
        return unitsAdapters;
    }

    public SkinUnitAdapter getSkinUnitCopy(SkinUnitAdapter unit) {
        try {
            return unit.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setNowCursor(Cursor cursor) {
        if (this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
    }

    private void focusSkinButton(int x, int y) {
        SkinButtonAdapter button = this.getSkinButtonByLocation(x, y);
        if (button != null) {
            this.setNowCursor(this.getReleaseCursor());
            this.setFocusSkinButton(button);
            return;
        }
        this.setNowCursor(mNormalCursor);
        this.setFocusSkinButton(null);
    }

    private SkinButtonAdapter selectedSkinButton(int x, int y) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return null;
        }
        this.requestFocus();
        SkinButtonAdapter button = this.getSkinButtonByLocation(x, y);
        if (button != null) {
            this.setNowCursor(this.getPressCursor());
            this.setSelectedSkinButton(button);
            return button;
        }
        this.setSelectedSkinButton(null);
        return null;
    }

    private void focusSkinUnit(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return;
        }
        for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
            SkinLayoutModelAdapter modelAdapter;
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinLayoutModelAdapter) || !this.containsPonit(modelAdapter = (SkinLayoutModelAdapter)unit, x, y)) continue;
            this.setNowCursor(this.getReleaseCursor());
            this.setFocusSkinLayoutModel(modelAdapter);
            return;
        }
        this.setNowCursor(mNormalCursor);
        this.setFocusSkinLayoutModel(null);
    }

    private SkinLayoutModelAdapter selectedSkinUnit(int x, int y) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        if (skinAdapter == null) {
            return null;
        }
        this.requestFocus();
        for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
            SkinLayoutModelAdapter modelAdapter;
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinLayoutModelAdapter) || !this.containsPonit(modelAdapter = (SkinLayoutModelAdapter)unit, x, y)) continue;
            this.setNowCursor(this.getPressCursor());
            this.setSelectedSkinLayoutModel(modelAdapter);
            return modelAdapter;
        }
        this.setSelectedSkinLayoutModel(null);
        return null;
    }

    private boolean containsPoint(Point2D.Double point, ArrayList<Point2D.Double> vertices) {
        int verticesCount = vertices.size();
        int nCross = 0;
        for (int i = 0; i < verticesCount; ++i) {
            double x;
            Point2D.Double p1 = vertices.get(i);
            Point2D.Double p2 = vertices.get((i + 1) % verticesCount);
            if (p1.getY() == p2.getY() || point.getY() < Math.min(p1.getY(), p2.getY()) || point.getY() >= Math.max(p1.getY(), p2.getY()) || !((x = (point.getY() - p1.getY()) * (p2.getX() - p1.getX()) / (p2.getY() - p1.getY()) + p1.getX()) > point.getX())) continue;
            ++nCross;
        }
        return nCross % 2 == 1;
    }

    private boolean containsPonit(SkinLayoutModelAdapter adapter, int x, int y) {
        SkinRect rect = adapter.getSkinUnit().getDrawRect();
        if (rect == null) {
            return false;
        }
        if (adapter.getSkinUnit() instanceof SkinImage && "clock_hourhand".equals(((SkinImage)adapter.getSkinUnit()).getFunctionId())) {
            int w = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().width());
            int h = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().height());
            int px = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().left);
            int py = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().top);
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(10);
            int minute = calendar.get(12);
            float time = (float)hour + (float)minute / 60.0f;
            float degrees = time * 360.0f / 12.0f;
            Point2D.Double point1 = new Point2D.Double((double)(-w) * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)(-w) * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point2 = new Point2D.Double((double)w * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)w * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point3 = new Point2D.Double((double)w * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)w * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point4 = new Point2D.Double((double)(-w) * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)(-w) * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(point1);
            points.add(point2);
            points.add(point3);
            points.add(point4);
            return this.containsPoint(new Point2D.Double(x, y), points);
        }
        if (adapter.getSkinUnit() instanceof SkinImage && "clock_minutehand".equals(((SkinImage)adapter.getSkinUnit()).getFunctionId())) {
            int w = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().width());
            int h = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().height());
            int px = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().left);
            int py = this.getPxByZoom(adapter.getSkinUnit().getDrawRect().top);
            Calendar calendar = Calendar.getInstance();
            int minute = calendar.get(12);
            float degrees = (float)minute * 360.0f / 60.0f;
            Point2D.Double point1 = new Point2D.Double((double)(-w) * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)(-w) * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point2 = new Point2D.Double((double)w * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)w * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point3 = new Point2D.Double((double)w * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)w * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            Point2D.Double point4 = new Point2D.Double((double)(-w) * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) - (double)h * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)px, (double)(-w) * 1.0 / 2.0 * Math.sin(Math.toRadians(degrees)) + (double)h * 1.0 / 2.0 * Math.cos(Math.toRadians(degrees)) + (double)py);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(point1);
            points.add(point2);
            points.add(point3);
            points.add(point4);
            return this.containsPoint(new Point2D.Double(x, y), points);
        }
        return x >= this.getPxByZoom(rect.left) && x <= this.getPxByZoom(rect.right) && y >= this.getPxByZoom(rect.top) && y <= this.getPxByZoom(rect.bottom);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        e.translatePoint(-this.mSkinOffsetX - (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, -this.mSkinOffsetY - (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
        if (this.mShowTouchable) {
            SkinButtonAdapter button = this.getSkinButtonByLocation(e.getX(), e.getY());
            if (button != null) {
                if (e.isShiftDown() || e.isControlDown()) {
                    this.setNowCursor(this.getPressCursor());
                    SkinButtonAdapter sba = this.mSelectedSkinButtonAdapter;
                    this.setSelectedSkinButton(null);
                    if (sba != null && !this.mMultipleSelectedSkinButtonAdapters.contains(sba)) {
                        this.mMultipleSelectedSkinButtonAdapters.add(sba);
                    }
                    if (!this.mMultipleSelectedSkinButtonAdapters.contains(button)) {
                        this.mMultipleSelectedSkinButtonAdapters.add(button);
                    } else {
                        this.mMultipleSelectedSkinButtonAdapters.remove(button);
                    }
                    this.fireMultipleSelectedSkinButtonsSelected(this.mMultipleSelectedSkinButtonAdapters);
                    this.repaint();
                    return;
                }
                if (this.mMultipleSelectedSkinButtonAdapters.contains(button)) {
                    this.fireMultipleSelectedSkinButtonsSelected(this.mMultipleSelectedSkinButtonAdapters);
                    this.repaint();
                    if (e.getClickCount() == 2 && button != null) {
                        Notifier.getInstance().notifyEvent("double_click_skin_unit", button);
                    }
                    return;
                }
            }
            if (!this.mMultipleSelectedSkinButtonAdapters.isEmpty()) {
                this.mMultipleSelectedSkinButtonAdapters.clear();
                this.fireMultipleSelectedSkinButtonsSelected(this.mMultipleSelectedSkinButtonAdapters);
                this.repaint();
            }
            SkinButtonAdapter ba = this.selectedSkinButton(e.getX(), e.getY());
            if (e.getClickCount() == 2) {
                if (ba != null) {
                    Notifier.getInstance().notifyEvent("double_click_skin_unit", ba);
                } else {
                    int id = this.getIDByLocation(e.getX(), e.getY());
                    if (id != -1) {
                        Notifier.getInstance().notifyEvent("double_click_empty_skin_button", this.getIDByLocation(e.getX(), e.getY()));
                    }
                }
            }
        } else {
            SkinLayoutModelAdapter ba;
            SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
            SkinLayoutModelAdapter slma = null;
            for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
                SkinLayoutModelAdapter modelAdapter;
                SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
                if (!(unit instanceof SkinLayoutModelAdapter) || !this.containsPonit(modelAdapter = (SkinLayoutModelAdapter)unit, e.getX(), e.getY())) continue;
                slma = modelAdapter;
                break;
            }
            if (slma != null) {
                if (e.isShiftDown() || e.isControlDown()) {
                    this.setNowCursor(this.getPressCursor());
                    SkinLayoutModelAdapter slma2 = this.mSelectedSkinLayoutModelAdapter;
                    this.setSelectedSkinLayoutModel(null);
                    if (slma2 != null && !this.mMultipleSelectedSkinLayoutModelAdapters.contains(slma2)) {
                        this.mMultipleSelectedSkinLayoutModelAdapters.add(slma2);
                    }
                    if (!this.mMultipleSelectedSkinLayoutModelAdapters.contains(slma)) {
                        this.mMultipleSelectedSkinLayoutModelAdapters.add(slma);
                    } else {
                        this.mMultipleSelectedSkinLayoutModelAdapters.remove(slma);
                    }
                    this.fireMultipleSelectedSkinLayoutModelsSelected(this.mMultipleSelectedSkinLayoutModelAdapters);
                    this.repaint();
                    return;
                }
                if (this.mMultipleSelectedSkinLayoutModelAdapters.contains(slma)) {
                    this.fireMultipleSelectedSkinLayoutModelsSelected(this.mMultipleSelectedSkinLayoutModelAdapters);
                    this.repaint();
                    return;
                }
            }
            if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                this.mMultipleSelectedSkinLayoutModelAdapters.clear();
                this.fireMultipleSelectedSkinLayoutModelsSelected(this.mMultipleSelectedSkinLayoutModelAdapters);
                this.repaint();
            }
            if ((ba = this.selectedSkinUnit(e.getX(), e.getY())) != null && e.getClickCount() == 2) {
                Notifier.getInstance().notifyEvent("double_click_skin_unit", ba);
            }
        }
        if (this.mSelectedSkinLayoutModelAdapter == null && this.mSelectedSkinButtonAdapter == null) {
            this.mPressSelection = e.getPoint();
        }
    }

    private ArrayList<Integer> getIDsByRectangle(Rectangle rect) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.getSkinButtonCount(); ++i) {
            Rectangle r = this.getRectangleByIdx(i);
            if (!rect.contains(this.getPxByZoom(r.x), this.getPxByZoom(r.y), this.getPxByZoom(r.width), this.getPxByZoom(r.height))) continue;
            ids.add(i);
        }
        return ids;
    }

    private ArrayList<SkinLayoutModelAdapter> getSkinLayoutModelAdaptersByRectangle(Rectangle rect) {
        ArrayList<SkinLayoutModelAdapter> adapters = new ArrayList<SkinLayoutModelAdapter>();
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
            SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinLayoutModelAdapter)) continue;
            SkinLayoutModelAdapter modelAdapter = (SkinLayoutModelAdapter)unit;
            SkinRect sr = modelAdapter.getSkinUnit().getDrawRect();
            if (!rect.contains(this.getPxByZoom(sr.left), this.getPxByZoom(sr.top), this.getPxByZoom(sr.width()), this.getPxByZoom(sr.height()))) continue;
            adapters.add(modelAdapter);
        }
        return adapters;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Cloneable endLayer;
        ArrayList<Integer> ids;
        if (!this.mCanEdit || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (this.mIsMoving) {
            this.mPressedSkinPoint = null;
            return;
        }
        SkinAdapter adapter = AppData.getInstance().getSkinAdapter();
        if (this.getCursor().equals(this.getPressCursor())) {
            this.setNowCursor(this.getReleaseCursor());
        }
        if (this.mIsAltPressed) {
            this.mIsAltPressed = false;
        }
        if (this.mButtonSelection != null) {
            Rectangle rect = this.getRectangleByIdx(this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx());
            rect.x = this.getPxByZoom(rect.x);
            rect.y = this.getPxByZoom(rect.y);
            rect.width = this.getPxByZoom(rect.width);
            rect.height = this.getPxByZoom(rect.height);
            rect.add(this.mButtonSelection);
            ids = this.getIDsByRectangle(rect);
            ArrayList<SkinButton> buttons = new ArrayList<SkinButton>();
            for (int i = 0; i < ids.size(); ++i) {
                if (ids.get(i).intValue() == this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx() || adapter.getSkinButtonByID(ids.get(i)) != null) continue;
                try {
                    SkinButton button = this.mSelectedSkinButtonAdapter.getSkinUnit().clone();
                    button.setSrc(null);
                    button.setStopPlayingSrc(null);
                    button.setIdx(ids.get(i));
                    buttons.add(button);
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
            SkinUnitOperator.addSkinButtons(buttons);
            this.fireSelectedSkinButton(this.mSelectedSkinButtonAdapter);
            this.mButtonSelection = null;
            this.repaintSkin();
        }
        if (this.mPressSelection != null) {
            if (this.mSelectionRect != null) {
                ArrayList<Object> adapters;
                if (this.isShowTouchable()) {
                    adapters = new ArrayList();
                    ids = this.getIDsByRectangle(this.mSelectionRect);
                    for (int i = 0; i < ids.size(); ++i) {
                        SkinButtonAdapter button = adapter.getSkinButtonByID(ids.get(i));
                        if (button == null) continue;
                        adapters.add(button);
                    }
                    if (!adapters.isEmpty()) {
                        if (adapters.size() > 1) {
                            this.mMultipleSelectedSkinButtonAdapters.clear();
                            this.mMultipleSelectedSkinButtonAdapters = adapters;
                            this.fireMultipleSelectedSkinButtonsSelected(this.mMultipleSelectedSkinButtonAdapters);
                        } else {
                            this.setSelectedSkinButton((SkinButtonAdapter)adapters.get(0));
                        }
                    }
                } else {
                    adapters = this.getSkinLayoutModelAdaptersByRectangle(this.mSelectionRect);
                    if (!adapters.isEmpty()) {
                        if (adapters.size() > 1) {
                            this.mMultipleSelectedSkinLayoutModelAdapters.clear();
                            this.mMultipleSelectedSkinLayoutModelAdapters = adapters;
                            this.fireMultipleSelectedSkinLayoutModelsSelected(this.mMultipleSelectedSkinLayoutModelAdapters);
                        } else {
                            this.setSelectedSkinLayoutModel((SkinLayoutModelAdapter)adapters.get(0));
                        }
                    }
                }
            }
            this.mSelectionRect = null;
            this.mPressSelection = null;
            this.repaint();
        }
        if (e.isShiftDown() || e.isControlDown()) {
            return;
        }
        if (this.mIsMutipleButtonMove) {
            this.mIsMutipleButtonMove = false;
            this.fireMultipleSelectedSkinButtonsMoved(this.mMultipleSelectedSkinButtonAdapters);
        }
        if (this.mMultiplePressedSkinLayoutModelPoint != null) {
            this.mMultiplePressedSkinLayoutModelPoint = null;
            this.fireMultipleSelectedSkinLayoutModelsMoved(this.mMultipleSelectedSkinLayoutModelAdapters);
        }
        if (this.lastSkinButtonAdapter != null) {
            this.lastSkinButtonAdapter = null;
        }
        if (this.mIsButtonMove) {
            this.mIsButtonMove = false;
            this.fireSkinButtonMoved(this.mSelectedSkinButtonAdapter);
        }
        if (this.mPressedSkinLayoutModelPoint != null) {
            this.mPressedSkinLayoutModelPoint = null;
            this.fireSkinLayoutModelMoved(this.mSelectedSkinLayoutModelAdapter);
        }
        if (this.mLayoutModelsEdit != null && this.mLayoutModelsEdit.getPresentationName() != null) {
            if (this.mMultipleSelectedSkinLayoutModelAdapters != null) {
                endLayer = this.getSkinLayoutModelsCopy(this.mMultipleSelectedSkinLayoutModelAdapters);
                this.mLayoutModelsEdit.end(this.skinLayoutModelsToSkinUnits((ArrayList<SkinLayoutModelAdapter>)endLayer));
                this.mUndoRedoSupport.postEdit(this.mLayoutModelsEdit);
            }
            this.mLayoutModelsEdit = null;
        }
        if (this.mButtonsEdit != null && this.mButtonsEdit.getPresentationName() != null) {
            if (this.mMultipleSelectedSkinButtonAdapters != null) {
                endLayer = this.getSkinButtonsCopy(this.mMultipleSelectedSkinButtonAdapters);
                this.mButtonsEdit.end(this.skinButtonsToSkinUnits((ArrayList<SkinButtonAdapter>)endLayer));
                this.mUndoRedoSupport.postEdit(this.mButtonsEdit);
            }
            this.mButtonsEdit = null;
        }
        if (this.mLayoutModelEdit != null && this.mLayoutModelEdit.getPresentationName() != null) {
            if (this.mSelectedSkinLayoutModelAdapter != null) {
                endLayer = (SkinLayoutModelAdapter)this.getSkinUnitCopy(this.mSelectedSkinLayoutModelAdapter);
                this.mLayoutModelEdit.end((SkinUnitAdapter)endLayer);
                this.mUndoRedoSupport.postEdit(this.mLayoutModelEdit);
            }
            this.mLayoutModelEdit = null;
        }
        if (this.mButtonEdit != null && this.mButtonEdit.getPresentationName() != null) {
            if (this.mSelectedSkinButtonAdapter != null) {
                endLayer = (SkinButtonAdapter)this.getSkinUnitCopy(this.mSelectedSkinButtonAdapter);
                this.mButtonEdit.end((SkinUnitAdapter)endLayer);
                this.mUndoRedoSupport.postEdit(this.mButtonEdit);
            }
            this.mButtonEdit = null;
        }
    }

    private void checkFocus(MouseEvent e) {
        if (e.getX() > this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2 && e.getX() < this.mSkinOffsetX + (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2 + this.getPxByZoom(this.mSkinRect.width) && e.getY() > this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2 && e.getY() < this.mSkinOffsetY + (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2 + this.getPxByZoom(this.mSkinRect.height) && !this.isFocusOwner()) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        this.checkFocus(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mCanEdit || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (this.mIsMoving) {
            if (this.mPressedSkinPoint == null) {
                this.mPressedSkinPoint = e.getPoint();
            } else {
                int ox = e.getPoint().x - this.mPressedSkinPoint.x;
                int oy = e.getPoint().y - this.mPressedSkinPoint.y;
                this.mSkinOffsetX = ox;
                this.mSkinOffsetY = oy;
                this.repaintSkin();
            }
            return;
        }
        SkinAdapter adapter = AppData.getInstance().getSkinAdapter();
        e.translatePoint(-this.mSkinOffsetX - (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, -this.mSkinOffsetY - (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
        if (this.mShowTouchable) {
            if (!this.mMultipleSelectedSkinButtonAdapters.isEmpty()) {
                if (this.lastSkinButtonAdapter == null) {
                    this.lastSkinButtonAdapter = this.getSkinButtonByLocation(e.getX(), e.getY());
                }
                if (this.lastSkinButtonAdapter == null) {
                    return;
                }
                SkinButton lastSelectedButton = this.lastSkinButtonAdapter.getSkinUnit();
                int id = this.getIDByLocation(e.getPoint().x, e.getPoint().y);
                if (id != -1 && lastSelectedButton.getIdx() != id && (adapter.getSkinButtonByID(id) == null || adapter.getSkinButtonByID(id) != null && this.mMultipleSelectedSkinButtonAdapters.contains(adapter.getSkinButtonByID(id)))) {
                    boolean canMove = true;
                    for (SkinButtonAdapter buttonAdapter : this.mMultipleSelectedSkinButtonAdapters) {
                        int idx;
                        if (buttonAdapter == null || buttonAdapter.equals(this.lastSkinButtonAdapter) || adapter.getSkinButtonByID(idx = buttonAdapter.getSkinUnit().getIdx() + (id - lastSelectedButton.getIdx())) == null || this.mMultipleSelectedSkinButtonAdapters.contains(adapter.getSkinButtonByID(idx))) continue;
                        canMove = false;
                        break;
                    }
                    if (canMove) {
                        this.mIsMutipleButtonMove = true;
                        for (SkinButtonAdapter buttonAdapter : this.mMultipleSelectedSkinButtonAdapters) {
                            if (buttonAdapter == null || buttonAdapter.equals(this.lastSkinButtonAdapter)) continue;
                            buttonAdapter.getSkinUnit().setIdx(buttonAdapter.getSkinUnit().getIdx() + (id - lastSelectedButton.getIdx()));
                        }
                        lastSelectedButton.setIdx(id);
                        this.repaintSkin();
                    }
                }
                return;
            }
            if (this.mSelectedSkinButtonAdapter != null) {
                if (!this.mSelectedSkinButtonAdapter.isActivate()) {
                    if (e.isAltDown() && !this.mIsAltPressed) {
                        int id = this.getIDByLocation(e.getPoint().x, e.getPoint().y);
                        SkinButton button = this.mSelectedSkinButtonAdapter.getSkinUnit();
                        if (id != -1 && button.getIdx() != id && adapter.getSkinButtonByID(id) == null) {
                            this.mIsAltPressed = true;
                            SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
                            try {
                                this.setSelectedSkinButton((SkinButtonAdapter)skinAdapter.addSkinUnit(this.mSelectedSkinButtonAdapter.getSkinUnit().clone()));
                            }
                            catch (CloneNotSupportedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        int id = this.getIDByLocation(e.getPoint().x, e.getPoint().y);
                        SkinButton button = this.mSelectedSkinButtonAdapter.getSkinUnit();
                        if (id != -1 && button.getIdx() != id && adapter.getSkinButtonByID(id) == null) {
                            this.mIsButtonMove = true;
                            button.setIdx(id);
                            this.repaintSkin();
                        }
                    }
                } else {
                    this.mButtonSelection = e.getPoint();
                    this.repaintSkin();
                }
                return;
            }
        } else {
            if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                int ox = 0;
                int oy = 0;
                if (this.mMultiplePressedSkinLayoutModelPoint == null) {
                    this.mMultiplePressedSkinLayoutModelPoint = e.getPoint();
                } else {
                    ox = e.getPoint().x - this.mMultiplePressedSkinLayoutModelPoint.x;
                    oy = e.getPoint().y - this.mMultiplePressedSkinLayoutModelPoint.y;
                    this.mMultiplePressedSkinLayoutModelPoint.translate(ox, oy);
                }
                for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
                    if (layoutModelAdapter == null) continue;
                    layoutModelAdapter.offsetX(ox);
                    layoutModelAdapter.offsetY(oy);
                    for (SkinLayoutModelAdapter layoutModelAdapter2 : layoutModelAdapter.getAffectedSkinLayoutModelAdapters()) {
                        layoutModelAdapter2.offsetX(-ox);
                        layoutModelAdapter2.offsetY(-oy);
                    }
                }
                this.repaintSkin();
                return;
            }
            if (this.mSelectedSkinLayoutModelAdapter != null) {
                if (e.isAltDown() && !this.mIsAltPressed) {
                    this.mIsAltPressed = true;
                    SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
                    try {
                        this.setSelectedSkinLayoutModel((SkinLayoutModelAdapter)skinAdapter.addSkinUnit(this.mSelectedSkinLayoutModelAdapter.getSkinUnit().clone()));
                    }
                    catch (CloneNotSupportedException ex) {
                        ex.printStackTrace();
                    }
                } else if (this.mPressedSkinLayoutModelPoint == null) {
                    this.mPressedSkinLayoutModelPoint = e.getPoint();
                } else {
                    int ox = e.getPoint().x - this.mPressedSkinLayoutModelPoint.x;
                    int oy = e.getPoint().y - this.mPressedSkinLayoutModelPoint.y;
                    this.mPressedSkinLayoutModelPoint.translate(ox, oy);
                    this.mSelectedSkinLayoutModelAdapter.offsetX(ox);
                    this.mSelectedSkinLayoutModelAdapter.offsetY(oy);
                    this.repaintSkin();
                }
                return;
            }
        }
        if (this.mPressSelection != null) {
            this.mSelectionRect = new Rectangle(this.mPressSelection);
            this.mSelectionRect.add(e.getPoint());
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mCanEdit || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (this.mIsMoving) {
            this.setNowCursor(mMoveCursor);
            return;
        }
        this.checkFocus(e);
        e.translatePoint(-this.mSkinOffsetX - (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, -this.mSkinOffsetY - (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
        if (this.mShowTouchable) {
            this.focusSkinButton(e.getX(), e.getY());
            if (this.mSelectedSkinButtonAdapter != null && this.mSelectedSkinButtonAdapter.getSkinUnit() != null && !e.isShiftDown() && !e.isControlDown()) {
                Rectangle rect = this.getRectangleByIdx(this.mSelectedSkinButtonAdapter.getSkinUnit().getIdx());
                if (e.getPoint().x > this.getPxByZoom(rect.x) && e.getPoint().x < this.getPxByZoom(rect.x) + 5 && e.getPoint().y > this.getPxByZoom(rect.y) && e.getPoint().y < this.getPxByZoom(rect.y) + 5 || e.getPoint().x > this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) - 5 && e.getPoint().x < this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) && e.getPoint().y > this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height) - 5 && e.getPoint().y < this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mSeMoveCursor);
                    return;
                }
                if (e.getPoint().x > this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) - 5 && e.getPoint().x < this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) && e.getPoint().y > this.getPxByZoom(rect.y) && e.getPoint().y < this.getPxByZoom(rect.y) + 5 || e.getPoint().x > this.getPxByZoom(rect.x) && e.getPoint().x < this.getPxByZoom(rect.x) + 5 && e.getPoint().y > this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height) - 5 && e.getPoint().y < this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mNeMoveCursor);
                    return;
                }
                if (e.getPoint().x > this.getPxByZoom(rect.x) && e.getPoint().x < this.getPxByZoom(rect.x) + 5 && e.getPoint().y > this.getPxByZoom(rect.y) && e.getPoint().y < this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mEwMoveCursor);
                    return;
                }
                if (e.getPoint().y > this.getPxByZoom(rect.y) && e.getPoint().y < this.getPxByZoom(rect.y) + 5 && e.getPoint().x > this.getPxByZoom(rect.x) && e.getPoint().x < this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mNsMoveCursor);
                    return;
                }
                if (e.getPoint().x > this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) - 5 && e.getPoint().x < this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width) && e.getPoint().y > this.getPxByZoom(rect.y) && e.getPoint().y < this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mEwMoveCursor);
                    return;
                }
                if (e.getPoint().y > this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height) - 5 && e.getPoint().y < this.getPxByZoom(rect.y) + this.getPxByZoom(rect.height) && e.getPoint().x > this.getPxByZoom(rect.x) && e.getPoint().x < this.getPxByZoom(rect.x) + this.getPxByZoom(rect.width)) {
                    this.mSelectedSkinButtonAdapter.setActivate(true);
                    this.setNowCursor(mNsMoveCursor);
                    return;
                }
                this.mSelectedSkinButtonAdapter.setActivate(false);
            }
        } else {
            this.focusSkinUnit(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
        if (this.mShowTouchable) {
            if (this.mSelectedSkinButtonAdapter != null) {
                switch (e.getKeyCode()) {
                    case 38: {
                        break;
                    }
                    case 40: {
                        break;
                    }
                    case 37: {
                        break;
                    }
                }
                this.repaintSkin();
            }
        } else {
            switch (e.getKeyCode()) {
                case 38: {
                    if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                        this.mIsMultipleMoveKeyPressed = true;
                        for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
                            if (layoutModelAdapter == null) continue;
                            layoutModelAdapter.offsetY(-1);
                            for (SkinLayoutModelAdapter layoutModelAdapter2 : layoutModelAdapter.getAffectedSkinLayoutModelAdapters()) {
                                layoutModelAdapter2.offsetY(1);
                            }
                        }
                        this.fireKeyEventConsume(e);
                        break;
                    }
                    if (this.mSelectedSkinLayoutModelAdapter == null || this.mSelectedSkinLayoutModelAdapter.getSkinUnit() == null) break;
                    this.mSelectedSkinLayoutModelAdapter.offsetY(-1);
                    this.mIsSingleMoveKeyPressed = true;
                    SkinLayoutModelAdapter unit = this.mSelectedSkinLayoutModelAdapter;
                    this.mLayoutModelEdit = new SkinLayoutModelEdit(this.mSelectedSkinLayoutModelAdapter, (SkinLayoutModelAdapter)this.getSkinUnitCopy(unit), null);
                    this.fireKeyEventConsume(e);
                    break;
                }
                case 40: {
                    if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                        this.mIsMultipleMoveKeyPressed = true;
                        for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
                            if (layoutModelAdapter == null) continue;
                            layoutModelAdapter.offsetY(1);
                            for (SkinLayoutModelAdapter layoutModelAdapter2 : layoutModelAdapter.getAffectedSkinLayoutModelAdapters()) {
                                layoutModelAdapter2.offsetY(-1);
                            }
                        }
                        this.fireKeyEventConsume(e);
                        break;
                    }
                    if (this.mSelectedSkinLayoutModelAdapter == null || this.mSelectedSkinLayoutModelAdapter.getSkinUnit() == null) break;
                    this.mSelectedSkinLayoutModelAdapter.offsetY(1);
                    this.mIsSingleMoveKeyPressed = true;
                    SkinLayoutModelAdapter unit = this.mSelectedSkinLayoutModelAdapter;
                    this.mLayoutModelEdit = new SkinLayoutModelEdit(this.mSelectedSkinLayoutModelAdapter, (SkinLayoutModelAdapter)this.getSkinUnitCopy(unit), null);
                    this.fireKeyEventConsume(e);
                    break;
                }
                case 37: {
                    if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                        this.mIsMultipleMoveKeyPressed = true;
                        for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
                            if (layoutModelAdapter == null) continue;
                            layoutModelAdapter.offsetX(-1);
                            for (SkinLayoutModelAdapter layoutModelAdapter2 : layoutModelAdapter.getAffectedSkinLayoutModelAdapters()) {
                                layoutModelAdapter2.offsetX(1);
                            }
                        }
                        this.fireKeyEventConsume(e);
                        break;
                    }
                    if (this.mSelectedSkinLayoutModelAdapter == null || this.mSelectedSkinLayoutModelAdapter.getSkinUnit() == null) break;
                    this.mSelectedSkinLayoutModelAdapter.offsetX(-1);
                    this.mIsSingleMoveKeyPressed = true;
                    SkinLayoutModelAdapter unit = this.mSelectedSkinLayoutModelAdapter;
                    this.mLayoutModelEdit = new SkinLayoutModelEdit(this.mSelectedSkinLayoutModelAdapter, (SkinLayoutModelAdapter)this.getSkinUnitCopy(unit), null);
                    this.fireKeyEventConsume(e);
                    break;
                }
                case 39: {
                    if (!this.mMultipleSelectedSkinLayoutModelAdapters.isEmpty()) {
                        this.mIsMultipleMoveKeyPressed = true;
                        for (SkinLayoutModelAdapter layoutModelAdapter : this.mMultipleSelectedSkinLayoutModelAdapters) {
                            if (layoutModelAdapter == null) continue;
                            layoutModelAdapter.offsetX(1);
                            for (SkinLayoutModelAdapter layoutModelAdapter2 : layoutModelAdapter.getAffectedSkinLayoutModelAdapters()) {
                                layoutModelAdapter2.offsetX(-1);
                            }
                        }
                        this.fireKeyEventConsume(e);
                        break;
                    }
                    if (this.mSelectedSkinLayoutModelAdapter == null || this.mSelectedSkinLayoutModelAdapter.getSkinUnit() == null) break;
                    this.mSelectedSkinLayoutModelAdapter.offsetX(1);
                    this.mIsSingleMoveKeyPressed = true;
                    SkinLayoutModelAdapter unit = this.mSelectedSkinLayoutModelAdapter;
                    this.mLayoutModelEdit = new SkinLayoutModelEdit(this.mSelectedSkinLayoutModelAdapter, (SkinLayoutModelAdapter)this.getSkinUnitCopy(unit), null);
                    this.fireKeyEventConsume(e);
                }
            }
            this.repaintSkin();
        }
    }

    private void fireKeyEventConsume(KeyEvent e) {
        if (!e.isControlDown()) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.mCanEdit || this.mIsMoving || AppData.getInstance().getSkinPkg() == null) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
        if (this.mIsMultipleMoveKeyPressed) {
            this.mIsMultipleMoveKeyPressed = false;
            this.fireMultipleSelectedSkinLayoutModelsMoved(this.mMultipleSelectedSkinLayoutModelAdapters);
        }
        if (this.mIsSingleMoveKeyPressed) {
            this.mIsSingleMoveKeyPressed = false;
            this.fireSkinLayoutModelMoved(this.mSelectedSkinLayoutModelAdapter);
        }
        if (this.mLayoutModelEdit != null && this.mLayoutModelEdit.getPresentationName() != null) {
            if (this.mSelectedSkinLayoutModelAdapter != null) {
                SkinLayoutModelAdapter endLayer = (SkinLayoutModelAdapter)this.getSkinUnitCopy(this.mSelectedSkinLayoutModelAdapter);
                this.mLayoutModelEdit.end(endLayer);
                this.mUndoRedoSupport.postEdit(this.mLayoutModelEdit);
            }
            this.mLayoutModelEdit = null;
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.getLocation().translate(-this.mSkinOffsetX - (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, -this.mSkinOffsetY - (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
        Point p = new Point(dtde.getLocation().x, dtde.getLocation().y);
        if (p.x < 0 || p.x > this.mSkinRect.width || p.y < 0 || p.y > this.mSkinRect.height) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(3);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                Object o;
                if (!flavor.equals(MaterialTransferable.UNIT_FLAVOR) || (o = transferable.getTransferData(MaterialTransferable.UNIT_FLAVOR)) == null || !(o instanceof MaterialPkg)) continue;
                dtde.getLocation().translate(-this.mSkinOffsetX - (this.getWidth() - this.getPxByZoom(this.mSkinRect.getWidth())) / 2, -this.mSkinOffsetY - (this.getHeight() - this.getPxByZoom(this.mSkinRect.getHeight())) / 2);
                MaterialPkg unit = (MaterialPkg)o;
                Point p = new Point(dtde.getLocation().x, dtde.getLocation().y);
                this.fireDragedMaterialPkg(unit, p);
            }
            dtde.dropComplete(true);
        }
        catch (Exception e) {
            Log.error("\u65e0\u6548\u7684\u6587\u4ef6\uff01");
            Log.error(e);
        }
    }
}

