/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.moduleui.CustomScrollBarUI;
import sina.mobile.tianqitong.util.StringUtil;

public class AddStaticTextDialog
extends JDialog {
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton mCancelButton;
    private JTextArea mEditPane;
    private JButton mOkButton;
    private JLabel mWordNumLabel;
    private static final int WORD_SIZE_EN = 64;
    private String mText = "";

    public AddStaticTextDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initEditPane();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
        this.mEditPane.setText(text);
        this.updateLabel();
    }

    private void initEditPane() {
        this.mEditPane.setDocument(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String text = AddStaticTextDialog.this.mEditPane.getText();
                AddStaticTextDialog.this.updateLabel();
                if (StringUtil.getLength(text) > 64) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.insertString(offs, str, a);
            }
        });
    }

    private void updateLabel() {
        String text = this.mEditPane.getText();
        if (StringUtil.isEmpty(text)) {
            this.mWordNumLabel.setText("\u8fd8\u53ef\u4ee5\u8f93\u516532\u4e2a\u6c49\u5b57\u6216\u800564\u4e2a\u5b57\u7b26\u3002");
            return;
        }
        int length = StringUtil.getLength(text);
        if (64 > length) {
            this.mWordNumLabel.setText("\u8fd8\u53ef\u4ee5\u8f93\u5165" + (64 - length) / 2 + "\u4e2a\u6c49\u5b57\u6216\u8005" + (64 - length) + "\u4e2a\u5b57\u7b26\u3002");
        } else if (64 <= length) {
            this.mWordNumLabel.setText("\u60a8\u8f93\u5165\u7684\u5b57\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\u3002");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.mWordNumLabel = new JLabel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.mEditPane = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u6dfb\u52a0\u9759\u6001\u6587\u5b57");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                AddStaticTextDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBackground(Colors.BACKGROUND);
        this.mWordNumLabel.setForeground(new Color(255, 255, 255));
        this.mWordNumLabel.setText("\u8fd8\u53ef\u4ee5\u8f93\u516532\u4e2a\u6c49\u5b57\u6216\u800564\u4e2a\u5b57\u7b26\u3002");
        this.mOkButton.setBackground(Colors.BACKGROUND);
        this.mOkButton.setText("\u786e\u5b9a");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddStaticTextDialog.this.mOkButtonActionPerformed(evt);
            }
        });
        this.mCancelButton.setBackground(Colors.BACKGROUND);
        this.mCancelButton.setText("\u53d6\u6d88");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddStaticTextDialog.this.mCancelButtonActionPerformed(evt);
            }
        });
        this.mEditPane.setBackground(Colors.LIGHT_AREA);
        this.mEditPane.setColumns(20);
        this.mEditPane.setFont(new Font("\u5b8b\u4f53", 0, 13));
        this.mEditPane.setForeground(new Color(255, 255, 255));
        this.mEditPane.setLineWrap(true);
        this.mEditPane.setRows(3);
        this.mEditPane.setToolTipText("\u6700\u591a\u53ea\u80fd\u8f93\u516532\u4e2a\u6c49\u5b57\u6216\u800564\u4e2a\u5b57\u7b26");
        this.mEditPane.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AddStaticTextDialog.this.mEditPaneKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.mEditPane);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mWordNumLabel, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 14, Short.MAX_VALUE).addComponent(this.mOkButton, -2, 81, -2).addGap(18, 18, 18).addComponent(this.mCancelButton).addGap(20, 20, 20)).addComponent(this.jScrollPane1)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.mCancelButton, this.mOkButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mWordNumLabel).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mOkButton).addComponent(this.mCancelButton)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.mCancelButton, this.mOkButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void mOkButtonActionPerformed(ActionEvent evt) {
        if (this.mEditPane.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165\u60a8\u8981\u6dfb\u52a0\u7684\u6587\u5b57.", "\u63d0\u793a", 1);
            return;
        }
        this.mText = this.mEditPane.getText();
        this.dispose();
    }

    private void mCancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void mEditPaneKeyReleased(KeyEvent evt) {
        this.updateLabel();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.jScrollPane1.getVerticalScrollBar().setUI(CustomScrollBarUI.createUI());
        this.jScrollPane1.getHorizontalScrollBar().setUI(CustomScrollBarUI.createUI());
    }
}

