/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sina.mobile.skin.Lunar;
import sina.mobile.skin.LunarHelper;
import sina.mobile.skin.Picture;
import sina.mobile.skin.PictureHelper;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinPaint;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;
import sina.mobile.skin.SkinTransform;
import sina.mobile.skin.weather.ForecastWeather;
import sina.mobile.skin.weather.WeatherHelper;
import sina.mobile.skin.weather.WeatherInfo;
import sina.mobile.tianqitong.adapter.PictureAdapter;

public class SkinImage
extends SkinLayoutModel {
    private String Src = null;
    private String Prefix = null;
    private String NightCWIPrefix = null;
    private String OffsetTime = null;
    private String mFileName = null;
    private String[] mFileNames = null;
    private HashMap<String, Picture> mImageCacheMap = new HashMap();
    private Picture mShowPicture = null;
    private String mOldFileName = null;
    private double mScaleWidth = 1.0;
    private double mScaleHeight = 1.0;
    private String[] mCombinationFunctionIds = new String[]{"temperature", "humidity", "htemperature", "ltemperature", "yyyy", "yy", "mm", "m", "dd", "d", "chn_y", "chn_m"};
    public static final String[] G_FORECAST_FUNCTIONIDS = new String[]{"day_weather_icon", "night_weather_icon", "f_weather_icon", "htemperature", "ltemperature", "clock_h", "clock_h24", "clock_h12", "clock_m", "clock_hd", "clock_h24d", "clock_h12d", "clock_hu", "clock_h24u", "clock_h12u", "clock_md", "clock_mu", "yyyy", "yy", "mm", "m", "dd", "d", "week"};

    public SkinImage(Skin skin) {
        super(skin);
    }

    public SkinImage() {
    }

    public SkinImage clone() throws CloneNotSupportedException {
        SkinImage clone = (SkinImage)super.clone();
        return clone;
    }

    public Picture getShowPicture() {
        return this.mShowPicture;
    }

    public void setShowPicture(Picture mShowPicture) {
        this.mShowPicture = mShowPicture;
    }

    public double getScaleHeight() {
        return this.mScaleHeight;
    }

    public double getScaleWidth() {
        return this.mScaleWidth;
    }

    public boolean offsetTimeAvailable() {
        if (this.FunctionId == null) {
            return false;
        }
        for (String f : G_FORECAST_FUNCTIONIDS) {
            if (!this.FunctionId.equals(f)) continue;
            return true;
        }
        return false;
    }

    public boolean isCombination() {
        if (this.FunctionId == null) {
            return false;
        }
        for (String f : this.mCombinationFunctionIds) {
            if (!this.FunctionId.equals(f)) continue;
            return true;
        }
        return false;
    }

    private void loadImageCache() throws FileNotFoundException, IOException {
        if (this.mFileName != null) {
            Picture bmp = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.mFileName, this.skin.isPortrait());
            this.mImageCacheMap.put(this.mFileName, bmp);
        }
    }

    private void loadImagesCache() throws FileNotFoundException, IOException {
        if (this.mFileNames != null) {
            for (String file : this.mFileNames) {
                Picture bmp = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), file, this.skin.isPortrait());
                this.mImageCacheMap.put(file, bmp);
            }
        }
    }

    public Picture getImageCache(String file) {
        return this.mImageCacheMap.get(file);
    }

    public Iterator getImageCacheMap() {
        return this.mImageCacheMap.entrySet().iterator();
    }

    public Picture addImageCache(String filename) throws FileNotFoundException, IOException {
        Picture bmp = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), filename, this.skin.isPortrait());
        this.mImageCacheMap.put(filename, bmp);
        return bmp;
    }

    public void clearImageCache() {
        this.mImageCacheMap.clear();
    }

    public String getOffsetTime() {
        return this.OffsetTime;
    }

    public void setNightCWIPrefix(String NightCWIPrefix) {
        this.NightCWIPrefix = NightCWIPrefix;
    }

    public void setOffsetTime(String OffsetTime) {
        this.OffsetTime = OffsetTime;
    }

    public void setPrefix(String Prefix) {
        this.Prefix = Prefix;
    }

    public String getNightCWIPrefix() {
        return this.NightCWIPrefix;
    }

    public String getPrefix() {
        return this.Prefix;
    }

    public void setSrc(String Src) {
        this.Src = Src;
    }

    public String getSrc() {
        return this.Src;
    }

    protected SkinRect measureDrawRect() {
        if (this.mFileName == null && this.mFileNames == null || this.skin == null) {
            return new SkinRect(0, 0);
        }
        SkinRect rect = null;
        if (this.mFileName != null) {
            if (this.mDrawRect != null) {
                rect = new SkinRect();
                rect.right = this.mDrawRect.right - this.mDrawRect.left;
                rect.bottom = this.mDrawRect.bottom - this.mDrawRect.top;
            } else {
                try {
                    Picture p = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.mFileName, this.skin.isPortrait());
                    rect = p != null ? p.getSkinRect() : new SkinRect(0, 0);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.FunctionId != null && (this.FunctionId.equals("clock_hourhand") || this.FunctionId.equals("clock_minutehand"))) {
                this.DatumPoint = 9;
            }
        } else if (this.mDrawRect != null) {
            rect = new SkinRect();
            rect.right = this.mDrawRect.right - this.mDrawRect.left;
            rect.bottom = this.mDrawRect.bottom - this.mDrawRect.top;
        } else {
            int[] rect2 = new int[]{0, 0};
            try {
                for (String file : this.mFileNames) {
                    SkinRect temp = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), file, this.skin.isPortrait()).getSkinRect();
                    rect2[0] = rect2[0] + temp.width();
                    if (rect2[1] > temp.height()) continue;
                    rect2[1] = temp.height();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            rect = new SkinRect(0, 0, rect2[0], rect2[1]);
        }
        return rect;
    }

    protected void setWeatherInfo(WeatherInfo wi) {
        this.mFileName = null;
        this.mFileNames = null;
        if (this.Src != null) {
            this.mFileName = this.Src;
            try {
                this.loadImageCache();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (this.FunctionId != null) {
            String tmp;
            int temp;
            String type;
            String warnPrefix;
            int offsetDay = 0;
            int daySign = 1;
            if (this.OffsetTime != null) {
                if (this.OffsetTime.startsWith("-")) {
                    daySign = -1;
                    this.OffsetTime = this.OffsetTime.substring(1);
                } else if (this.OffsetTime.startsWith("+")) {
                    daySign = 1;
                    this.OffsetTime = this.OffsetTime.substring(1);
                } else {
                    daySign = 1;
                    this.OffsetTime = this.OffsetTime.substring(0);
                }
                if (this.OffsetTime.endsWith("d")) {
                    offsetDay = daySign * Integer.parseInt(this.OffsetTime.substring(0, this.OffsetTime.length() - 1));
                }
            }
            String fnWithoutPrefix = null;
            ForecastWeather careForecast = null;
            ForecastWeather[] fcs = wi.getForecastsForCurrent(5);
            if (offsetDay < fcs.length) {
                careForecast = fcs[offsetDay];
            }
            int ycode = 48;
            if (this.FunctionId.equals("c_weather_icon")) {
                ycode = wi.getYCodeUsingSunRiseAndSet();
                fnWithoutPrefix = SkinImage.getFn(ycode);
            } else if (this.FunctionId.equals("day_weather_icon")) {
                if (careForecast != ForecastWeather.EMPTY) {
                    ycode = careForecast.getYcode();
                }
                fnWithoutPrefix = SkinImage.getFn(ycode);
            } else if (this.FunctionId.equals("night_weather_icon")) {
                if (careForecast != ForecastWeather.EMPTY) {
                    ycode = careForecast.getYcode2();
                }
                fnWithoutPrefix = SkinImage.getFn(ycode);
            } else if (this.FunctionId.equals("f_weather_icon")) {
                if (careForecast != ForecastWeather.EMPTY) {
                    ycode = WeatherHelper.getForecastYcode(wi, offsetDay);
                }
                fnWithoutPrefix = SkinImage.getFn(ycode);
            }
            if (fnWithoutPrefix != null) {
                this.setFileName(fnWithoutPrefix, "wi", wi);
                return;
            }
            if (this.FunctionId.equals("warn") && !(warnPrefix = SkinImage.getWarnFn(type = wi.getWarning().getWarningLevel())).equals("")) {
                this.setFileName(warnPrefix, "warn", wi);
                return;
            }
            String[] fnWithoutPrefixs = null;
            String defaultPrefix = null;
            String backUpPrefix = null;
            if (this.FunctionId.equals("temperature")) {
                temp = wi.getCondition().getTemperature();
                tmp = temp + "c";
                fnWithoutPrefixs = SkinImage.getTemStrings(tmp);
                defaultPrefix = "centigrade";
            } else if (this.FunctionId.equals("humidity")) {
                int humidity = wi.getCondition().getHumidity();
                tmp = humidity + "p";
                fnWithoutPrefixs = SkinImage.getTemStrings(tmp);
                defaultPrefix = "humidity";
            } else if (this.FunctionId.equals("htemperature")) {
                if (careForecast != ForecastWeather.EMPTY) {
                    temp = careForecast.getHigh();
                    tmp = temp + "c";
                    fnWithoutPrefixs = SkinImage.getTemStrings(tmp);
                    defaultPrefix = "htem";
                    backUpPrefix = "centigrade";
                }
            } else if (this.FunctionId.equals("ltemperature") && careForecast != ForecastWeather.EMPTY) {
                temp = careForecast.getLow();
                tmp = temp + "c";
                fnWithoutPrefixs = SkinImage.getTemStrings(tmp);
                defaultPrefix = "ltem";
                backUpPrefix = "centigrade";
            }
            careForecast = null;
            if (null != fnWithoutPrefixs && fnWithoutPrefixs.length > 0) {
                this.setFilesName(fnWithoutPrefixs, defaultPrefix, backUpPrefix);
                return;
            }
            Calendar c = Calendar.getInstance();
            if (this.FunctionId.equals("clock_ampm")) {
                int ampm = c.get(9);
                fnWithoutPrefix = ampm == 0 ? "_am.png" : "_pm.png";
            } else if (this.FunctionId.equals("clock_hourhand")) {
                fnWithoutPrefix = "_hourhand.png";
            } else if (this.FunctionId.equals("clock_minutehand")) {
                fnWithoutPrefix = "_minutehand.png";
            }
            if (fnWithoutPrefix != null) {
                this.setFileName(fnWithoutPrefix, "clock", wi);
                return;
            }
            c = Calendar.getInstance();
            long curtime = System.currentTimeMillis();
            c.setTimeInMillis(curtime += (long)offsetDay * 3600000L * 24L);
            int year = c.get(1);
            int month = c.get(2);
            int day = c.get(5);
            int week = c.get(7);
            int hour = -1;
            int h12 = -1;
            int h24 = -1;
            hour = c.get(11);
            h24 = c.get(11);
            h12 = c.get(10);
            if (h12 == 0) {
                h12 = 12;
            }
            int minute = c.get(12);
            String strNum = null;
            if (this.FunctionId.equals("clock_h")) {
                strNum = SkinHelper.num(hour);
            } else if (this.FunctionId.equals("clock_h24")) {
                strNum = SkinHelper.num(h24);
            } else if (this.FunctionId.equals("clock_h12")) {
                strNum = SkinHelper.num(h12);
            } else if (this.FunctionId.equals("clock_m")) {
                strNum = SkinHelper.num(minute);
            } else if (this.FunctionId.equals("clock_hd")) {
                strNum = hour / 10 + "";
            } else if (this.FunctionId.equals("clock_h24d")) {
                strNum = h24 / 10 + "";
            } else if (this.FunctionId.equals("clock_h12d")) {
                strNum = h12 / 10 + "";
            } else if (this.FunctionId.equals("clock_hu")) {
                strNum = hour % 10 + "";
            } else if (this.FunctionId.equals("clock_h24u")) {
                strNum = h24 % 10 + "";
            } else if (this.FunctionId.equals("clock_h12u")) {
                strNum = h12 % 10 + "";
            } else if (this.FunctionId.equals("clock_md")) {
                strNum = minute / 10 + "";
            } else if (this.FunctionId.equals("clock_mu")) {
                strNum = minute % 10 + "";
            } else if (this.FunctionId.equals("yyyy")) {
                fnWithoutPrefixs = SkinImage.getTemStrings(year + "");
                defaultPrefix = "yyyy";
            } else if (this.FunctionId.equals("yy")) {
                fnWithoutPrefixs = SkinImage.getTemStrings((year + "").substring(2));
                defaultPrefix = "yy";
            } else if (this.FunctionId.equals("mm")) {
                fnWithoutPrefixs = SkinImage.getTemStrings(SkinHelper.num(month + 1));
                defaultPrefix = "mm";
            } else if (this.FunctionId.equals("m")) {
                fnWithoutPrefixs = SkinImage.getTemStrings(month + 1 + "");
                defaultPrefix = "m";
            } else if (this.FunctionId.equals("dd")) {
                fnWithoutPrefixs = SkinImage.getTemStrings(SkinHelper.num(day));
                defaultPrefix = "dd";
            } else if (this.FunctionId.equals("d")) {
                fnWithoutPrefixs = SkinImage.getTemStrings(day + "");
                defaultPrefix = "d";
            } else if (this.FunctionId.equals("week")) {
                fnWithoutPrefix = SkinImage.getTemStrings(week - 1 + "")[0];
                defaultPrefix = "week";
                if (fnWithoutPrefix != null) {
                    this.setFileName(fnWithoutPrefix, "week", wi);
                    return;
                }
            }
            Lunar cd = LunarHelper.getLunar(c);
            if (cd != null) {
                String chny = "";
                String chnm = "";
                String chnd = "";
                String chnZodiacs = "";
                if (cd != null) {
                    chny = LunarHelper.getYearStr2(cd);
                    chnm = LunarHelper.getMonthStr2(cd);
                    chnd = LunarHelper.getDayStr2(cd);
                    chnZodiacs = LunarHelper.getChineseZodiacStr2(cd);
                }
                if (this.FunctionId.equals("chn_y")) {
                    fnWithoutPrefixs = SkinImage.getChnStrings(chny);
                    defaultPrefix = "chn_y";
                } else if (this.FunctionId.equals("chn_m")) {
                    fnWithoutPrefixs = SkinImage.getChnStrings(chnm);
                    defaultPrefix = "chn_m";
                } else if (this.FunctionId.equals("chn_d")) {
                    fnWithoutPrefix = SkinImage.getChnStrings(chnd)[0];
                    defaultPrefix = "chn_d";
                    if (fnWithoutPrefix != null) {
                        this.setFileName(fnWithoutPrefix, "chn_d", wi);
                        return;
                    }
                } else if (this.FunctionId.equals("chn_zodiacs")) {
                    fnWithoutPrefix = SkinImage.getChnStrings(chnZodiacs)[0];
                    defaultPrefix = "chn_zodiacs";
                    if (fnWithoutPrefix != null) {
                        this.setFileName(fnWithoutPrefix, "chn_zodiacs", wi);
                        return;
                    }
                }
            } else {
                fnWithoutPrefixs = null;
            }
            if (strNum != null) {
                fnWithoutPrefix = "_" + strNum + ".png";
                if (fnWithoutPrefix != null) {
                    this.setFileName(fnWithoutPrefix, "clock", wi);
                    return;
                }
            } else {
                this.mFileName = null;
            }
            if (null != fnWithoutPrefixs && fnWithoutPrefixs.length > 0) {
                this.setFilesName(fnWithoutPrefixs, defaultPrefix, backUpPrefix);
                return;
            }
        }
    }

    protected boolean setValue(String attrName, String attrValue) {
        if (attrName.equals("Src")) {
            this.Src = attrValue;
        } else if (attrName.equals("FunctionId")) {
            this.FunctionId = attrValue;
        } else if (attrName.equals("Prefix")) {
            this.Prefix = attrValue;
        } else if (attrName.equals("NightCWIPrefix")) {
            this.NightCWIPrefix = attrValue;
        } else if (attrName.equals("OffsetTime")) {
            this.OffsetTime = attrValue;
        } else if (!super.setValue(attrName, attrValue)) {
            return false;
        }
        return true;
    }

    public static String getFn(int ycode) {
        String[] fns = new String[]{"_06.png", "_10.png", "_10.png", "_10.png", "_10.png", "_13.png", "_14.png", "_14.png", "_14.png", "_08.png", "_14.png", "_08.png", "_09.png", "_11.png", "_11.png", "_11.png", "_12.png", "_14.png", "_14.png", "_06.png", "_05.png", "_06.png", "_06.png", "_06.png", "_06.png", "_04.png", "_04.png", "_16.png", "_03.png", "_16.png", "_02.png", "_15.png", "_01.png", "_15.png", "_01.png", "_14.png", "_01.png", "_10.png", "_10.png", "_07.png", "_07.png", "_12.png", "_11.png", "_12.png", "_02.png", "_10.png", "_11.png", "_10.png", "_17.png", "_17.png"};
        return fns[ycode];
    }

    public static String[] getTemStrings(String tem) {
        String[] temp = new String[tem.length()];
        for (int i = 0; i < tem.length(); ++i) {
            char c = tem.charAt(i);
            temp[i] = "_" + (c == '-' ? "belowzero" : Character.valueOf(c)) + ".png";
        }
        return temp;
    }

    public static String[] getChnStrings(String chnString) {
        if (!chnString.equals("")) {
            String[] temp = chnString.split("/");
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = "_" + temp[i] + ".png";
            }
            return temp;
        }
        return null;
    }

    public static String getWarnFn(String type) {
        if (type != null) {
            String pre = "_";
            if (type.contains("\u9ec4")) {
                return pre + "0.png";
            }
            if (type.contains("\u6a59")) {
                return pre + "1.png";
            }
            if (type.contains("\u7ea2")) {
                return pre + "2.png";
            }
            if (type.contains("\u84dd")) {
                return pre + "3.png";
            }
            return "";
        }
        return "";
    }

    private void setFileName(String fnWithoutPrefix, String defaultPrefix, WeatherInfo wi) {
        try {
            this.mFileName = null;
            if (this.FunctionId != null && this.FunctionId.equals("c_weather_icon") && this.NightCWIPrefix != null && !wi.isDay()) {
                this.mFileName = this.NightCWIPrefix + fnWithoutPrefix;
                if (!this.skin.checkImage(this.mFileName)) {
                    this.mFileName = null;
                }
            }
            if (this.mFileName == null) {
                this.mFileName = this.Prefix != null ? this.Prefix + fnWithoutPrefix : defaultPrefix + fnWithoutPrefix;
                if (!this.skin.checkImage(this.mFileName)) {
                    this.mFileName = null;
                }
            }
            this.loadImageCache();
        }
        catch (FileNotFoundException e) {
            this.mFileName = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.mFileName = null;
            e.printStackTrace();
        }
    }

    private void setFilesName(String[] fnWithoutPrefixs, String defaultPrefix, String backUpPrefix) {
        try {
            this.mFileNames = null;
            if (this.FunctionId != null) {
                ArrayList<String> fileNames;
                int i;
                if (this.Prefix != null) {
                    i = 0;
                    fileNames = new ArrayList<String>();
                    for (String file : fnWithoutPrefixs) {
                        if (!this.skin.checkImage(this.Prefix + file)) continue;
                        fileNames.add(this.Prefix + file);
                        ++i;
                    }
                    if (i > 0) {
                        this.mFileNames = fileNames.toArray(new String[i]);
                    }
                }
                if (this.mFileNames == null) {
                    i = 0;
                    fileNames = new ArrayList();
                    for (String file : fnWithoutPrefixs) {
                        if (this.skin.checkImage(defaultPrefix + file)) {
                            fileNames.add(defaultPrefix + file);
                            ++i;
                            continue;
                        }
                        if (backUpPrefix == null || !this.skin.checkImage(backUpPrefix + file)) continue;
                        fileNames.add(backUpPrefix + file);
                        ++i;
                    }
                    if (i > 0) {
                        this.mFileNames = fileNames.toArray(new String[i]);
                    }
                }
            }
            this.loadImagesCache();
        }
        catch (FileNotFoundException e) {
            this.mFileNames = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.mFileNames = null;
            e.printStackTrace();
        }
    }

    protected void draw(SkinRender c) {
        if (this.mFileName == null && this.mFileNames == null) {
            return;
        }
        if (this.mFileName != null) {
            Picture p;
            Picture bmp = null;
            if (!this.mFileName.equals(this.mOldFileName)) {
                try {
                    this.mShowPicture = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.mFileName, this.skin.isPortrait());
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.mOldFileName = this.mFileName;
            bmp = this.mShowPicture;
            if (bmp == null) {
                return;
            }
            if (this.FunctionId != null && this.FunctionId.equals("clock_hourhand")) {
                p = PictureHelper.resize(bmp, this.mDrawRect.width(), this.mDrawRect.height());
                int w = p.getWidth();
                int h = p.getHeight();
                int px = this.mDrawRect.left;
                int py = this.mDrawRect.top;
                Calendar calendar = Calendar.getInstance();
                int hour = calendar.get(10);
                int minute = calendar.get(12);
                float time = (float)hour + (float)minute / 60.0f;
                float degrees = time * 360.0f / 12.0f;
                SkinTransform.rotate(Math.toRadians(degrees), px, py);
                SkinTransform.translate(this.mDrawRect.left - w / 2, this.mDrawRect.top - h / 2);
                c.drawSkinImage(p.getPicture(), SkinTransform.getTransform(), null);
            } else if (this.FunctionId != null && this.FunctionId.equals("clock_minutehand")) {
                p = PictureHelper.resize(bmp, this.mDrawRect.width(), this.mDrawRect.height());
                int w = p.getWidth();
                int h = p.getHeight();
                int px = this.mDrawRect.left;
                int py = this.mDrawRect.top;
                Calendar calendar = Calendar.getInstance();
                int minute = calendar.get(12);
                float degrees = (float)minute * 360.0f / 60.0f;
                SkinTransform.rotate(Math.toRadians(degrees), px, py);
                SkinTransform.translate(this.mDrawRect.left - w / 2, this.mDrawRect.top - h / 2);
                c.drawSkinImage(p.getPicture(), SkinTransform.getTransform(), null);
            } else {
                c.drawSkinImage(bmp.getPicture(), this.mDrawRect.left, this.mDrawRect.top, this.mDrawRect.width(), this.mDrawRect.height(), null);
            }
            return;
        }
        if (this.mFileNames != null) {
            double scaleH;
            double scaleW;
            Picture[] tempBitmaps = new Picture[this.mFileNames.length];
            int[] rect2 = new int[]{0, 0};
            try {
                for (int i = 0; i < tempBitmaps.length; ++i) {
                    tempBitmaps[i] = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.mFileNames[i], this.skin.isPortrait());
                    SkinRect temp = tempBitmaps[i].getSkinRect();
                    rect2[0] = rect2[0] + temp.width();
                    if (rect2[1] > temp.height()) continue;
                    rect2[1] = temp.height();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mScaleWidth = scaleW = (double)this.mDrawRect.width() * 1.0 / (double)rect2[0];
            this.mScaleHeight = scaleH = (double)this.mDrawRect.height() * 1.0 / (double)rect2[1];
            SkinPaint p = new SkinPaint();
            int dw = this.mDrawRect.left;
            for (int i = 0; i < tempBitmaps.length; ++i) {
                if (i > 0) {
                    dw = (int)(scaleW * (double)tempBitmaps[i - 1].getWidth()) + dw;
                }
                c.drawSkinImage(tempBitmaps[i].getPicture(), dw, this.mDrawRect.top, (int)(scaleW * (double)tempBitmaps[i].getWidth()), (int)(scaleH * (double)tempBitmaps[i].getHeight()), p);
            }
            return;
        }
    }

    public void recycle() {
        this.Src = null;
        this.Prefix = null;
        this.NightCWIPrefix = null;
        this.OffsetTime = null;
        this.mFileName = null;
        this.mFileNames = null;
        Iterator iterator = this.getImageCacheMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Picture pic = (Picture)entry.getValue();
            if (pic == null) continue;
            PictureAdapter picAdapter = (PictureAdapter)pic.getPicture();
            picAdapter.setBufferedImage(null);
        }
        this.mImageCacheMap.clear();
        this.mShowPicture = null;
        this.mOldFileName = null;
    }
}

