/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import sina.mobile.skin.Lunar;

public final class LunarHelper {
    private static final String[] heavenly_stems = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] earthly_branches = new String[]{"\u5b50", "\u4e11", "\u6f14", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] chinese_zodiacs = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] chinese_months = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u51ac\u6708", "\u814a\u6708"};
    private static final String[] chinese_days = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    private static final String[] solar_terms = new String[]{"\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2"};
    private static final int START_YEAR = 2010;
    private static final byte START_ERA = 27;
    private static final int YEAR_COUNT = 20;
    private static final long MILLISECONDS_FOR_ONE_DAY = 86400000L;
    private static final String CHN_SEPERATER = "/";
    private static final byte[] SOLAR_TERMS_IDX_IN_YEAR = new byte[]{22, 23, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private static final byte[] CHINESE_FESTIVALS_IDX_IN_YEAR = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final byte[][] SOLAR_TERMS = new byte[][]{{5, 20, 4, 19, 6, 21, 5, 20, 5, 21, 6, 21, 7, 23, 7, 23, 8, 23, 8, 23, 7, 22, 7, 22}, {6, 20, 4, 19, 6, 21, 5, 20, 6, 21, 6, 22, 7, 23, 8, 23, 8, 23, 8, 24, 8, 23, 7, 22}, {6, 21, 4, 19, 5, 20, 4, 20, 5, 20, 5, 21, 7, 22, 7, 23, 7, 22, 8, 23, 7, 22, 7, 21}, {5, 20, 4, 18, 5, 20, 4, 20, 5, 21, 5, 21, 7, 22, 7, 23, 7, 23, 8, 23, 7, 22, 7, 22}, {5, 20, 4, 19, 6, 21, 5, 20, 5, 21, 6, 21, 7, 23, 7, 23, 8, 23, 8, 23, 7, 22, 7, 22}, {6, 20, 4, 19, 6, 21, 5, 20, 6, 21, 6, 22, 7, 23, 8, 23, 8, 23, 8, 24, 8, 22, 7, 22}, {6, 20, 4, 19, 5, 20, 4, 19, 5, 20, 5, 21, 7, 22, 7, 23, 7, 22, 8, 23, 7, 22, 7, 21}, {5, 20, 3, 18, 5, 20, 4, 20, 5, 21, 5, 21, 7, 22, 7, 23, 7, 23, 8, 23, 7, 22, 7, 22}, {5, 20, 4, 19, 5, 21, 5, 20, 5, 21, 6, 21, 7, 23, 7, 23, 8, 23, 8, 23, 7, 22, 7, 22}, {5, 20, 4, 19, 6, 21, 5, 20, 6, 21, 6, 21, 7, 23, 8, 23, 8, 23, 8, 24, 8, 22, 7, 22}, {6, 20, 4, 19, 5, 20, 4, 19, 5, 20, 5, 21, 6, 22, 7, 22, 7, 22, 8, 23, 7, 22, 7, 21}, {5, 20, 3, 18, 5, 20, 4, 20, 5, 21, 5, 21, 7, 22, 7, 23, 7, 23, 8, 23, 7, 22, 7, 21}, {5, 20, 4, 19, 5, 20, 5, 20, 5, 21, 6, 21, 7, 23, 7, 23, 7, 23, 8, 23, 7, 22, 7, 22}, {5, 20, 4, 19, 6, 21, 5, 20, 6, 21, 6, 21, 7, 23, 8, 23, 8, 23, 8, 24, 8, 22, 7, 22}, {6, 20, 4, 19, 5, 20, 4, 19, 5, 20, 5, 21, 6, 22, 7, 22, 7, 22, 8, 23, 7, 22, 6, 21}, {5, 20, 3, 18, 5, 20, 4, 20, 5, 21, 5, 21, 7, 22, 7, 23, 7, 23, 8, 23, 7, 22, 7, 21}, {5, 20, 4, 18, 5, 20, 5, 20, 5, 21, 5, 21, 7, 23, 7, 23, 7, 23, 8, 23, 7, 22, 7, 22}, {5, 20, 4, 19, 6, 21, 5, 20, 6, 21, 6, 21, 7, 23, 8, 23, 8, 23, 8, 23, 7, 22, 7, 22}, {6, 20, 4, 19, 5, 20, 4, 19, 5, 20, 5, 21, 6, 22, 7, 22, 7, 22, 8, 23, 7, 22, 6, 21}, {5, 20, 3, 18, 5, 20, 4, 20, 5, 21, 5, 21, 7, 22, 7, 23, 7, 23, 8, 23, 7, 22, 7, 21}};
    private static final byte[][] CHINESE_FESTIVALS = new byte[][]{{1, 29, 2, 10, 2, 13, 2, 14, 2, 28, 6, 16, 8, 16, 8, 25, 9, 19, 9, 22, 10, 16, 1, 22, -1, -1}, {1, 18, 1, 30, 2, 2, 2, 3, 2, 17, 6, 6, 8, 6, 8, 14, 9, 9, 9, 12, 10, 5, 1, 11, -1, -1}, {1, 7, 1, 19, 1, 22, 1, 23, 2, 6, 6, 23, 8, 23, 8, 31, 9, 27, 9, 30, 10, 23, 1, 1, -1, -1}, {1, 26, 2, 6, 2, 9, 2, 10, 2, 24, 6, 12, 8, 13, 8, 21, 9, 16, 9, 19, 10, 13, 1, 19, -1, -1}, {1, 15, 1, 27, 1, 30, 1, 31, 2, 14, 6, 2, 8, 2, 8, 10, 9, 5, 9, 8, 10, 2, 1, 8, -1, -1}, {2, 3, 2, 15, 2, 18, 2, 19, 3, 5, 6, 20, 8, 20, 8, 28, 9, 24, 9, 27, 10, 21, 1, 27, -1, -1}, {1, 24, 2, 4, 2, 7, 2, 8, 5, 22, 6, 9, 8, 9, 8, 17, 9, 12, 9, 15, 10, 9, 1, 17, -1, -1}, {1, 12, 1, 24, 1, 27, 1, 28, 2, 11, 5, 30, 8, 28, 9, 5, 10, 1, 10, 4, 10, 28, 1, 5, -1, -1}, {1, 31, 2, 12, 2, 15, 2, 16, 3, 2, 6, 18, 8, 17, 8, 25, 9, 21, 9, 24, 10, 17, 1, 24, -1, -1}, {1, 21, 2, 1, 2, 4, 2, 5, 5, 2, 19, 6, 7, 8, 7, 8, 15, 9, 10, 9, 13, 10, 7, 1, 13, -1, -1}, {1, 9, 1, 21, 1, 24, 1, 25, 2, 8, 6, 25, 8, 25, 9, 2, 9, 28, 10, 1, 10, 25, 1, 2, -1, -1}, {1, 28, 2, 8, 2, 11, 2, 12, 2, 26, 6, 14, 8, 14, 8, 22, 9, 18, 9, 21, 10, 14, 1, 20, -1, -1}, {1, 16, 1, 28, 1, 31, 2, 1, 2, 15, 6, 3, 8, 4, 8, 12, 9, 7, 9, 10, 10, 4, 1, 10, 12, 30}, {1, 6, 1, 18, 1, 21, 1, 22, 2, 5, 6, 22, 8, 22, 8, 30, 9, 26, 9, 29, 10, 23, -1, -1, -1, -1}, {1, 26, 2, 6, 2, 9, 2, 10, 2, 24, 6, 10, 8, 10, 8, 18, 9, 14, 9, 17, 10, 11, 1, 18, -1, -1}, {1, 13, 1, 25, 1, 28, 1, 29, 2, 12, 5, 31, 8, 29, 9, 6, 10, 3, 10, 6, 10, 29, 1, 7, -1, -1}, {2, 1, 2, 13, 2, 16, 2, 17, 3, 3, 6, 19, 8, 19, 8, 27, 9, 22, 9, 25, 10, 18, 1, 26, -1, -1}, {1, 22, 2, 2, 2, 5, 2, 6, 5, 2, 20, 6, 9, 8, 8, 8, 16, 9, 12, 9, 15, 10, 8, 1, 15, -1, -1}, {1, 10, 1, 22, 1, 25, 1, 26, 2, 9, 5, 28, 8, 26, 9, 3, 9, 30, 10, 3, 10, 26, 1, 4, -1, -1}, {1, 29, 2, 9, 2, 12, 2, 13, 2, 27, 6, 16, 8, 16, 8, 24, 9, 19, 9, 22, 10, 16, 1, 22, -1, -1}};
    public static final int DATE_FORMAT_DEFAULT = 0;
    public static final int DATE_FORMAT_YMD = 1;
    public static final int DATE_FORMAT_AMD = 2;
    public static final int DATE_FORMAT_MIX = 3;
    public static final int DATE_FORMAT_GREG = 4;
    public static final int DATE_FORMATE_MIXSHORT = 5;
    public static final int DATE_FORMAT_20110323_APPWIDGET = 6;
    public static final int DATE_FORMAT_20120720_APPWIDGET = 7;
    private static final String leap = "\u95f0";
    private static final String year = "\u5e74";
    private static final String chinese_calendar = "\u519c\u5386";
    private static SoftReference<byte[][][]> gChineseCalendarTable;
    private static final String FILE_NAME = "chineseCalendar";

    /*
     * Unable to fully structure code
     */
    private static Lunar getLunar(int yearNum, byte monthIdx, int dayNum) {
        calendarTable = LunarHelper.getCalendarTable();
        if (yearNum >= 2010 && yearNum < 2030) {
            cd = new Lunar();
            yearIdx = (byte)(yearNum - 2010);
            dayIdx = dayNum - 1;
            currentYearIdx = yearIdx;
            currentMonthIdx = monthIdx;
            currentDayIdx = dayIdx;
            cd.m_dayNum = calendarTable[currentYearIdx][currentMonthIdx][currentDayIdx];
            if (cd.m_dayNum < 0) {
                cd.m_dayNum = 1;
            }
            block0: while (true) {
                if ((tmp = calendarTable[currentYearIdx][currentMonthIdx][currentDayIdx]) < 0) {
                    cd.m_monthIdx = (byte)(-tmp - 1);
                    if (tmp < -100) {
                        cd.m_isLeapMonth = true;
                        cd.m_monthIdx = (byte)(cd.m_monthIdx - 100);
                    }
                    cd.m_yearNum = (byte)(currentYearIdx + 27);
                    if (cd.m_monthIdx < 10 || currentMonthIdx > 1) break;
                    cd.m_yearNum = (byte)(cd.m_yearNum - 1);
                    break;
                }
                if ((currentDayIdx = (byte)(currentDayIdx - 1)) >= 0) continue;
                currentDayIdx = 30;
                if ((currentMonthIdx = (byte)(currentMonthIdx - 1)) >= 0) continue;
                currentMonthIdx = 11;
                if ((currentYearIdx = (byte)(currentYearIdx - 1)) >= 0) continue;
                cd.m_yearNum = (byte)26;
                i = 0;
                while (true) {
                    if (i < 31) ** break;
                    continue block0;
                    ttttt = calendarTable[0][0][i];
                    if (ttttt < 0) {
                        cd.m_monthIdx = (byte)(-ttttt - 1);
                        if (tmp < -100) {
                            cd.m_monthIdx = (byte)(cd.m_monthIdx - 100);
                        }
                        cd.m_monthIdx = (byte)(cd.m_monthIdx - 1);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            for (i = monthIdx * 2; i < monthIdx * 2 + 2; ++i) {
                if (dayIdx + 1 != LunarHelper.SOLAR_TERMS[yearIdx][i]) continue;
                cd.m_solarTermIdx = LunarHelper.SOLAR_TERMS_IDX_IN_YEAR[i];
                break;
            }
            if (monthIdx != 3 && monthIdx != 6 && monthIdx != 10) {
                for (i = 0; i < LunarHelper.CHINESE_FESTIVALS_IDX_IN_YEAR.length; ++i) {
                    if (monthIdx + 1 != LunarHelper.CHINESE_FESTIVALS[yearIdx][i * 2] || dayIdx + 1 != LunarHelper.CHINESE_FESTIVALS[yearIdx][i * 2 + 1]) continue;
                    cd.m_chieseFestivalIdx = LunarHelper.CHINESE_FESTIVALS_IDX_IN_YEAR[i];
                    break;
                }
            }
            return cd;
        }
        return null;
    }

    public static Lunar getLunar(Calendar calendar) {
        int yearNum = calendar.get(1);
        byte monthIdx = (byte)calendar.get(2);
        int dayNum = calendar.get(5);
        return LunarHelper.getLunar(yearNum, monthIdx, dayNum);
    }

    public static String getYearStr(Lunar cd) {
        if (!cd.hasYear()) {
            return "";
        }
        StringBuilder re = new StringBuilder();
        int t = (cd.getYearNum() - 1) % 10;
        re.append(heavenly_stems[t]);
        t = (cd.getYearNum() - 1) % 12;
        re.append(earthly_branches[t]);
        return re.toString();
    }

    public static String getYearStr2(Lunar cd) {
        if (!cd.hasYear()) {
            return "";
        }
        StringBuilder re = new StringBuilder();
        int t = (cd.getYearNum() - 1) % 10;
        re.append("hs_");
        re.append(t);
        re.append(CHN_SEPERATER);
        t = (cd.getYearNum() - 1) % 12;
        re.append("eb_");
        re.append(t);
        return re.toString();
    }

    public static String getMonthStr(Lunar cd) {
        StringBuilder re = new StringBuilder();
        if (cd.isLeapMonth()) {
            re.append(leap);
        }
        re.append(chinese_months[cd.getMonthIdx()]);
        return re.toString();
    }

    public static String getMonthStr2(Lunar cd) {
        StringBuilder re = new StringBuilder();
        if (cd.isLeapMonth()) {
            re.append("run");
            re.append(CHN_SEPERATER);
        }
        re.append(cd.getMonthIdx());
        return re.toString();
    }

    public static String getDayStr(Lunar cd) {
        return chinese_days[cd.getDayNum() - 1];
    }

    public static String getDayStr2(Lunar cd) {
        return cd.getDayNum() - 1 + "";
    }

    public static String getChineseZodiacStr(Lunar cd) {
        if (!cd.hasYear()) {
            return null;
        }
        int t = cd.getYearNum() % 12;
        return chinese_zodiacs[t - 1];
    }

    public static String getChineseZodiacStr2(Lunar cd) {
        if (!cd.hasYear()) {
            return null;
        }
        return cd.getYearNum() % 12 - 1 + "";
    }

    public static String getSorlarTermStr(Lunar cd) {
        if (!cd.hasYear()) {
            return "";
        }
        return solar_terms[cd.getSolarTermIdx()];
    }

    public static String toString(Lunar cd, int format) {
        StringBuilder sb = new StringBuilder();
        switch (format) {
            case 0: {
                sb.append(chinese_calendar);
                break;
            }
            case 1: {
                if (!cd.hasYear()) break;
                sb.append(LunarHelper.getYearStr(cd));
                sb.append(year);
                break;
            }
            case 2: {
                if (!cd.hasYear()) break;
                sb.append(LunarHelper.getChineseZodiacStr(cd));
                sb.append(year);
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                return "";
            }
            case 6: {
                if (cd.hasYear()) {
                    sb.append("[");
                    if (cd.isSolarTerm()) {
                        sb.append(LunarHelper.getSorlarTermStr(cd));
                    } else {
                        sb.append(LunarHelper.getYearStr(cd));
                    }
                    sb.append("]");
                }
                sb.append(LunarHelper.getMonthStr(cd));
                sb.append(LunarHelper.getDayStr(cd));
                return sb.toString();
            }
            case 7: {
                if (cd.hasYear()) {
                    sb.append("[");
                    sb.append(LunarHelper.getYearStr(cd));
                    sb.append("] ");
                }
                sb.append(LunarHelper.getMonthStr(cd));
                sb.append(LunarHelper.getDayStr(cd));
                if (cd.isSolarTerm()) {
                    sb.append(" ").append(LunarHelper.getSorlarTermStr(cd));
                }
                return sb.toString();
            }
        }
        sb.append(LunarHelper.getMonthStr(cd));
        sb.append(LunarHelper.getDayStr(cd));
        if (cd.hasYear() && cd.isSolarTerm()) {
            sb.append(" ");
            sb.append(LunarHelper.getSorlarTermStr(cd));
        }
        return sb.toString();
    }

    public static int calcDistance(Calendar today, Lunar target) {
        int yearNum = today.get(1);
        byte yearIdx = (byte)(yearNum - 2010);
        byte monthIdx = (byte)today.get(2);
        byte dayIdx = (byte)(today.get(5) - 1);
        byte[][][] calendarTable = LunarHelper.getCalendarTable();
        Lunar cd = LunarHelper.getLunar(yearNum, monthIdx, dayIdx + 1);
        if (cd == null) {
            return -1;
        }
        byte tMonthIdx = cd.getMonthIdx();
        boolean tIsLeap = cd.isLeapMonth();
        int r = 0;
        while (true) {
            byte tdayNum;
            if ((tdayNum = calendarTable[yearIdx][monthIdx][dayIdx]) < 0) {
                tMonthIdx = (byte)(-tdayNum - 1);
                if (tdayNum < -100) {
                    tIsLeap = true;
                    tMonthIdx = (byte)(cd.m_monthIdx - 100);
                }
                tdayNum = 1;
            }
            if (tMonthIdx == target.m_monthIdx && tIsLeap == target.m_isLeapMonth && tdayNum == target.m_dayNum) {
                return r;
            }
            dayIdx = (byte)(dayIdx + 1);
            ++r;
            if (dayIdx <= 30 && calendarTable[yearIdx][monthIdx][dayIdx] != 0) continue;
            monthIdx = (byte)(monthIdx + 1);
            dayIdx = 0;
            if (monthIdx <= 11) continue;
            monthIdx = 0;
            if ((yearIdx = (byte)(yearIdx + 1)) >= calendarTable.length) break;
        }
        return -1;
    }

    public static byte[][][] initCalendarTable() {
        byte[][][] calendarTable = new byte[20][12][31];
        try {
            FileInputStream inputStream = new FileInputStream("resource" + File.separator + FILE_NAME);
            BufferedInputStream inputReader = new BufferedInputStream(inputStream);
            DataInputStream in = new DataInputStream(inputReader);
            for (int i = 0; i < calendarTable.length; ++i) {
                for (int j = 0; j < calendarTable[0].length; ++j) {
                    for (int k = 0; k < calendarTable[0][0].length; ++k) {
                        calendarTable[i][j][k] = in.readByte();
                    }
                }
            }
            ((InputStream)inputStream).close();
            inputReader.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return calendarTable;
    }

    public static byte[][][] getCalendarTable() {
        if (gChineseCalendarTable == null || gChineseCalendarTable.get() == null) {
            gChineseCalendarTable = new SoftReference<byte[][][]>(LunarHelper.initCalendarTable());
        }
        return gChineseCalendarTable.get();
    }

    public static int calNextTermDistance(Calendar calendar) {
        int[] dates;
        int distance = -1;
        int yearNum = calendar.get(1);
        if (yearNum > 2029) {
            return -1;
        }
        int yearIdx = yearNum - 2010;
        byte monthIdx = (byte)calendar.get(2);
        int dayNum = calendar.get(5);
        if (dayNum < (dates = new int[]{SOLAR_TERMS[yearIdx][monthIdx * 2], SOLAR_TERMS[yearIdx][monthIdx * 2 + 1]})[0]) {
            distance = dates[0] - dayNum;
        } else if (dayNum >= dates[0] && dayNum < dates[1]) {
            distance = dates[1] - dayNum;
        } else if (monthIdx == 0 || monthIdx == 2 || monthIdx == 4 || monthIdx == 6 || monthIdx == 7 || monthIdx == 9) {
            byte nextMonth1stTerm = SOLAR_TERMS[yearIdx][monthIdx * 2 + 2];
            distance = nextMonth1stTerm + 31 - dayNum;
        } else if (monthIdx == 3 || monthIdx == 5 || monthIdx == 8 || monthIdx == 10) {
            byte nextMonth1stTerm = SOLAR_TERMS[yearIdx][monthIdx * 2 + 2];
            distance = nextMonth1stTerm + 30 - dayNum;
        } else if (monthIdx == 1 && yearNum % 4 == 0) {
            byte nextMonth1stTerm = SOLAR_TERMS[yearIdx][monthIdx * 2 + 2];
            distance = nextMonth1stTerm + 29 - dayNum;
        } else if (monthIdx == 1 && yearNum % 4 != 0) {
            byte nextMonth1stTerm = SOLAR_TERMS[yearIdx][monthIdx * 2 + 2];
            distance = nextMonth1stTerm + 28 - dayNum;
        } else if (monthIdx == 11) {
            if (yearNum == 2029) {
                return -1;
            }
            byte nextYear1stTerm = SOLAR_TERMS[yearIdx + 1][0];
            distance = nextYear1stTerm + 31 - dayNum;
        }
        return distance;
    }

    public static String calNextTerm(Calendar calendar) {
        String nextTerm = "";
        int distance = LunarHelper.calNextTermDistance(calendar);
        if (distance < 0) {
            return nextTerm;
        }
        Calendar mCalendar = Calendar.getInstance();
        mCalendar.setTimeInMillis(calendar.getTimeInMillis() + (long)distance * 86400000L);
        Lunar cd = LunarHelper.getLunar(mCalendar);
        if (cd == null) {
            return nextTerm;
        }
        if (cd.isSolarTerm()) {
            nextTerm = LunarHelper.getSorlarTermStr(cd);
        }
        return nextTerm;
    }
}

