/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import org.keplerproject.luajava.CPtr;
import org.keplerproject.luajava.JavaFunction;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaObject;
import org.keplerproject.luajava.LuaStateFactory;

public class LuaState {
    private static final String LUAJAVA_LIB = "luajava-1.1";
    public static final Integer LUA_GLOBALSINDEX = new Integer(-10002);
    public static final Integer LUA_REGISTRYINDEX = new Integer(-10000);
    public static final Integer LUA_TNONE = new Integer(-1);
    public static final Integer LUA_TNIL = new Integer(0);
    public static final Integer LUA_TBOOLEAN = new Integer(1);
    public static final Integer LUA_TLIGHTUSERDATA = new Integer(2);
    public static final Integer LUA_TNUMBER = new Integer(3);
    public static final Integer LUA_TSTRING = new Integer(4);
    public static final Integer LUA_TTABLE = new Integer(5);
    public static final Integer LUA_TFUNCTION = new Integer(6);
    public static final Integer LUA_TUSERDATA = new Integer(7);
    public static final Integer LUA_TTHREAD = new Integer(8);
    public static final Integer LUA_MULTRET = new Integer(-1);
    public static final Integer LUA_ERRRUN = new Integer(1);
    public static final Integer LUA_YIELD = new Integer(2);
    public static final Integer LUA_ERRSYNTAX = new Integer(3);
    public static final Integer LUA_ERRMEM = new Integer(4);
    public static final Integer LUA_ERRERR = new Integer(5);
    private CPtr luaState;
    private int stateId;
    public static final Integer LUA_GCSTOP;
    public static final Integer LUA_GCRESTART;
    public static final Integer LUA_GCCOLLECT;
    public static final Integer LUA_GCCOUNT;
    public static final Integer LUA_GCCOUNTB;
    public static final Integer LUA_GCSTEP;
    public static final Integer LUA_GCSETPAUSE;
    public static final Integer LUA_GCSETSTEPMUL;

    protected LuaState(int n) {
        this.luaState = this._open();
        this.luajava_open(this.luaState, n);
        this.stateId = n;
    }

    protected LuaState(CPtr cPtr) {
        this.luaState = cPtr;
        this.stateId = LuaStateFactory.insertLuaState(this);
        this.luajava_open(cPtr, this.stateId);
    }

    public synchronized void close() {
        LuaStateFactory.removeLuaState(this.stateId);
        this._close(this.luaState);
        this.luaState = null;
    }

    public synchronized boolean isClosed() {
        return this.luaState == null;
    }

    public long getCPtrPeer() {
        return this.luaState != null ? this.luaState.getPeer() : 0L;
    }

    private synchronized native CPtr _open();

    private synchronized native void _close(CPtr var1);

    private synchronized native CPtr _newthread(CPtr var1);

    private synchronized native int _getTop(CPtr var1);

    private synchronized native void _setTop(CPtr var1, int var2);

    private synchronized native void _pushValue(CPtr var1, int var2);

    private synchronized native void _remove(CPtr var1, int var2);

    private synchronized native void _insert(CPtr var1, int var2);

    private synchronized native void _replace(CPtr var1, int var2);

    private synchronized native int _checkStack(CPtr var1, int var2);

    private synchronized native void _xmove(CPtr var1, CPtr var2, int var3);

    private synchronized native int _isNumber(CPtr var1, int var2);

    private synchronized native int _isString(CPtr var1, int var2);

    private synchronized native int _isCFunction(CPtr var1, int var2);

    private synchronized native int _isUserdata(CPtr var1, int var2);

    private synchronized native int _type(CPtr var1, int var2);

    private synchronized native String _typeName(CPtr var1, int var2);

    private synchronized native int _equal(CPtr var1, int var2, int var3);

    private synchronized native int _rawequal(CPtr var1, int var2, int var3);

    private synchronized native int _lessthan(CPtr var1, int var2, int var3);

    private synchronized native double _toNumber(CPtr var1, int var2);

    private synchronized native int _toInteger(CPtr var1, int var2);

    private synchronized native int _toBoolean(CPtr var1, int var2);

    private synchronized native String _toString(CPtr var1, int var2);

    private synchronized native int _objlen(CPtr var1, int var2);

    private synchronized native CPtr _toThread(CPtr var1, int var2);

    private synchronized native void _pushNil(CPtr var1);

    private synchronized native void _pushNumber(CPtr var1, double var2);

    private synchronized native void _pushInteger(CPtr var1, int var2);

    private synchronized native void _pushString(CPtr var1, String var2);

    private synchronized native void _pushString(CPtr var1, byte[] var2, int var3);

    private synchronized native void _pushBoolean(CPtr var1, int var2);

    private synchronized native void _getTable(CPtr var1, int var2);

    private synchronized native void _getField(CPtr var1, int var2, String var3);

    private synchronized native void _rawGet(CPtr var1, int var2);

    private synchronized native void _rawGetI(CPtr var1, int var2, int var3);

    private synchronized native void _createTable(CPtr var1, int var2, int var3);

    private synchronized native int _getMetaTable(CPtr var1, int var2);

    private synchronized native void _getFEnv(CPtr var1, int var2);

    private synchronized native void _setTable(CPtr var1, int var2);

    private synchronized native void _setField(CPtr var1, int var2, String var3);

    private synchronized native void _rawSet(CPtr var1, int var2);

    private synchronized native void _rawSetI(CPtr var1, int var2, int var3);

    private synchronized native int _setMetaTable(CPtr var1, int var2);

    private synchronized native int _setFEnv(CPtr var1, int var2);

    private synchronized native void _call(CPtr var1, int var2, int var3);

    private synchronized native int _pcall(CPtr var1, int var2, int var3, int var4);

    private synchronized native int _yield(CPtr var1, int var2);

    private synchronized native int _resume(CPtr var1, int var2);

    private synchronized native int _status(CPtr var1);

    private synchronized native int _gc(CPtr var1, int var2, int var3);

    private synchronized native int _error(CPtr var1);

    private synchronized native int _next(CPtr var1, int var2);

    private synchronized native void _concat(CPtr var1, int var2);

    private synchronized native void _pop(CPtr var1, int var2);

    private synchronized native void _newTable(CPtr var1);

    private synchronized native int _strlen(CPtr var1, int var2);

    private synchronized native int _isFunction(CPtr var1, int var2);

    private synchronized native int _isTable(CPtr var1, int var2);

    private synchronized native int _isNil(CPtr var1, int var2);

    private synchronized native int _isBoolean(CPtr var1, int var2);

    private synchronized native int _isThread(CPtr var1, int var2);

    private synchronized native int _isNone(CPtr var1, int var2);

    private synchronized native int _isNoneOrNil(CPtr var1, int var2);

    private synchronized native void _setGlobal(CPtr var1, String var2);

    private synchronized native void _getGlobal(CPtr var1, String var2);

    private synchronized native int _getGcCount(CPtr var1);

    private synchronized native int _LdoFile(CPtr var1, String var2);

    private synchronized native int _LdoString(CPtr var1, String var2);

    private synchronized native int _LgetMetaField(CPtr var1, int var2, String var3);

    private synchronized native int _LcallMeta(CPtr var1, int var2, String var3);

    private synchronized native int _Ltyperror(CPtr var1, int var2, String var3);

    private synchronized native int _LargError(CPtr var1, int var2, String var3);

    private synchronized native String _LcheckString(CPtr var1, int var2);

    private synchronized native String _LoptString(CPtr var1, int var2, String var3);

    private synchronized native double _LcheckNumber(CPtr var1, int var2);

    private synchronized native double _LoptNumber(CPtr var1, int var2, double var3);

    private synchronized native int _LcheckInteger(CPtr var1, int var2);

    private synchronized native int _LoptInteger(CPtr var1, int var2, int var3);

    private synchronized native void _LcheckStack(CPtr var1, int var2, String var3);

    private synchronized native void _LcheckType(CPtr var1, int var2, int var3);

    private synchronized native void _LcheckAny(CPtr var1, int var2);

    private synchronized native int _LnewMetatable(CPtr var1, String var2);

    private synchronized native void _LgetMetatable(CPtr var1, String var2);

    private synchronized native void _Lwhere(CPtr var1, int var2);

    private synchronized native int _Lref(CPtr var1, int var2);

    private synchronized native void _LunRef(CPtr var1, int var2, int var3);

    private synchronized native int _LgetN(CPtr var1, int var2);

    private synchronized native void _LsetN(CPtr var1, int var2, int var3);

    private synchronized native int _LloadFile(CPtr var1, String var2);

    private synchronized native int _LloadBuffer(CPtr var1, byte[] var2, long var3, String var5);

    private synchronized native int _LloadString(CPtr var1, String var2);

    private synchronized native String _Lgsub(CPtr var1, String var2, String var3, String var4);

    private synchronized native String _LfindTable(CPtr var1, int var2, String var3, int var4);

    private synchronized native void _openBase(CPtr var1);

    private synchronized native void _openTable(CPtr var1);

    private synchronized native void _openIo(CPtr var1);

    private synchronized native void _openOs(CPtr var1);

    private synchronized native void _openString(CPtr var1);

    private synchronized native void _openMath(CPtr var1);

    private synchronized native void _openDebug(CPtr var1);

    private synchronized native void _openPackage(CPtr var1);

    private synchronized native void _openLibs(CPtr var1);

    public LuaState newThread() {
        LuaState luaState = new LuaState(this._newthread(this.luaState));
        LuaStateFactory.insertLuaState(luaState);
        return luaState;
    }

    public int getTop() {
        return this._getTop(this.luaState);
    }

    public void setTop(int n) {
        this._setTop(this.luaState, n);
    }

    public void pushValue(int n) {
        this._pushValue(this.luaState, n);
    }

    public void remove(int n) {
        this._remove(this.luaState, n);
    }

    public void insert(int n) {
        this._insert(this.luaState, n);
    }

    public void replace(int n) {
        this._replace(this.luaState, n);
    }

    public int checkStack(int n) {
        return this._checkStack(this.luaState, n);
    }

    public void xmove(LuaState luaState, int n) {
        this._xmove(this.luaState, luaState.luaState, n);
    }

    public boolean isNumber(int n) {
        return this._isNumber(this.luaState, n) != 0;
    }

    public boolean isString(int n) {
        return this._isString(this.luaState, n) != 0;
    }

    public boolean isFunction(int n) {
        return this._isFunction(this.luaState, n) != 0;
    }

    public boolean isCFunction(int n) {
        return this._isCFunction(this.luaState, n) != 0;
    }

    public boolean isUserdata(int n) {
        return this._isUserdata(this.luaState, n) != 0;
    }

    public boolean isTable(int n) {
        return this._isTable(this.luaState, n) != 0;
    }

    public boolean isBoolean(int n) {
        return this._isBoolean(this.luaState, n) != 0;
    }

    public boolean isNil(int n) {
        return this._isNil(this.luaState, n) != 0;
    }

    public boolean isThread(int n) {
        return this._isThread(this.luaState, n) != 0;
    }

    public boolean isNone(int n) {
        return this._isNone(this.luaState, n) != 0;
    }

    public boolean isNoneOrNil(int n) {
        return this._isNoneOrNil(this.luaState, n) != 0;
    }

    public int type(int n) {
        return this._type(this.luaState, n);
    }

    public String typeName(int n) {
        return this._typeName(this.luaState, n);
    }

    public int equal(int n, int n2) {
        return this._equal(this.luaState, n, n2);
    }

    public int rawequal(int n, int n2) {
        return this._rawequal(this.luaState, n, n2);
    }

    public int lessthan(int n, int n2) {
        return this._lessthan(this.luaState, n, n2);
    }

    public double toNumber(int n) {
        return this._toNumber(this.luaState, n);
    }

    public int toInteger(int n) {
        return this._toInteger(this.luaState, n);
    }

    public boolean toBoolean(int n) {
        return this._toBoolean(this.luaState, n) != 0;
    }

    public String toString(int n) {
        return this._toString(this.luaState, n);
    }

    public int strLen(int n) {
        return this._strlen(this.luaState, n);
    }

    public int objLen(int n) {
        return this._objlen(this.luaState, n);
    }

    public LuaState toThread(int n) {
        return new LuaState(this._toThread(this.luaState, n));
    }

    public void pushNil() {
        this._pushNil(this.luaState);
    }

    public void pushNumber(double d) {
        this._pushNumber(this.luaState, d);
    }

    public void pushInteger(int n) {
        this._pushInteger(this.luaState, n);
    }

    public void pushString(String string) {
        if (string == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, string);
        }
    }

    public void pushString(byte[] byArray) {
        if (byArray == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, byArray, byArray.length);
        }
    }

    public void pushBoolean(boolean bl) {
        this._pushBoolean(this.luaState, bl ? 1 : 0);
    }

    public void getTable(int n) {
        this._getTable(this.luaState, n);
    }

    public void getField(int n, String string) {
        this._getField(this.luaState, n, string);
    }

    public void rawGet(int n) {
        this._rawGet(this.luaState, n);
    }

    public void rawGetI(int n, int n2) {
        this._rawGetI(this.luaState, n, n2);
    }

    public void createTable(int n, int n2) {
        this._createTable(this.luaState, n, n2);
    }

    public void newTable() {
        this._newTable(this.luaState);
    }

    public int getMetaTable(int n) {
        return this._getMetaTable(this.luaState, n);
    }

    public void getFEnv(int n) {
        this._getFEnv(this.luaState, n);
    }

    public void setTable(int n) {
        this._setTable(this.luaState, n);
    }

    public void setField(int n, String string) {
        this._setField(this.luaState, n, string);
    }

    public void rawSet(int n) {
        this._rawSet(this.luaState, n);
    }

    public void rawSetI(int n, int n2) {
        this._rawSetI(this.luaState, n, n2);
    }

    public int setMetaTable(int n) {
        return this._setMetaTable(this.luaState, n);
    }

    public int setFEnv(int n) {
        return this._setFEnv(this.luaState, n);
    }

    public void call(int n, int n2) {
        this._call(this.luaState, n, n2);
    }

    public int pcall(int n, int n2, int n3) {
        return this._pcall(this.luaState, n, n2, n3);
    }

    public int yield(int n) {
        return this._yield(this.luaState, n);
    }

    public int resume(int n) {
        return this._resume(this.luaState, n);
    }

    public int status() {
        return this._status(this.luaState);
    }

    public int gc(int n, int n2) {
        return this._gc(this.luaState, n, n2);
    }

    public int getGcCount() {
        return this._getGcCount(this.luaState);
    }

    public int next(int n) {
        return this._next(this.luaState, n);
    }

    public int error() {
        return this._error(this.luaState);
    }

    public void concat(int n) {
        this._concat(this.luaState, n);
    }

    public int LdoFile(String string) {
        return this._LdoFile(this.luaState, string);
    }

    public int LdoString(String string) {
        return this._LdoString(this.luaState, string);
    }

    public int LgetMetaField(int n, String string) {
        return this._LgetMetaField(this.luaState, n, string);
    }

    public int LcallMeta(int n, String string) {
        return this._LcallMeta(this.luaState, n, string);
    }

    public int Ltyperror(int n, String string) {
        return this._Ltyperror(this.luaState, n, string);
    }

    public int LargError(int n, String string) {
        return this._LargError(this.luaState, n, string);
    }

    public String LcheckString(int n) {
        return this._LcheckString(this.luaState, n);
    }

    public String LoptString(int n, String string) {
        return this._LoptString(this.luaState, n, string);
    }

    public double LcheckNumber(int n) {
        return this._LcheckNumber(this.luaState, n);
    }

    public double LoptNumber(int n, double d) {
        return this._LoptNumber(this.luaState, n, d);
    }

    public int LcheckInteger(int n) {
        return this._LcheckInteger(this.luaState, n);
    }

    public int LoptInteger(int n, int n2) {
        return this._LoptInteger(this.luaState, n, n2);
    }

    public void LcheckStack(int n, String string) {
        this._LcheckStack(this.luaState, n, string);
    }

    public void LcheckType(int n, int n2) {
        this._LcheckType(this.luaState, n, n2);
    }

    public void LcheckAny(int n) {
        this._LcheckAny(this.luaState, n);
    }

    public int LnewMetatable(String string) {
        return this._LnewMetatable(this.luaState, string);
    }

    public void LgetMetatable(String string) {
        this._LgetMetatable(this.luaState, string);
    }

    public void Lwhere(int n) {
        this._Lwhere(this.luaState, n);
    }

    public int Lref(int n) {
        return this._Lref(this.luaState, n);
    }

    public void LunRef(int n, int n2) {
        this._LunRef(this.luaState, n, n2);
    }

    public int LgetN(int n) {
        return this._LgetN(this.luaState, n);
    }

    public void LsetN(int n, int n2) {
        this._LsetN(this.luaState, n, n2);
    }

    public int LloadFile(String string) {
        return this._LloadFile(this.luaState, string);
    }

    public int LloadString(String string) {
        return this._LloadString(this.luaState, string);
    }

    public int LloadBuffer(byte[] byArray, String string) {
        return this._LloadBuffer(this.luaState, byArray, byArray.length, string);
    }

    public String Lgsub(String string, String string2, String string3) {
        return this._Lgsub(this.luaState, string, string2, string3);
    }

    public String LfindTable(int n, String string, int n2) {
        return this._LfindTable(this.luaState, n, string, n2);
    }

    public void pop(int n) {
        this._pop(this.luaState, n);
    }

    public synchronized void getGlobal(String string) {
        this._getGlobal(this.luaState, string);
    }

    public synchronized void setGlobal(String string) {
        this._setGlobal(this.luaState, string);
    }

    public void openBase() {
        this._openBase(this.luaState);
    }

    public void openTable() {
        this._openTable(this.luaState);
    }

    public void openIo() {
        this._openIo(this.luaState);
    }

    public void openOs() {
        this._openOs(this.luaState);
    }

    public void openString() {
        this._openString(this.luaState);
    }

    public void openMath() {
        this._openMath(this.luaState);
    }

    public void openDebug() {
        this._openDebug(this.luaState);
    }

    public void openPackage() {
        this._openPackage(this.luaState);
    }

    public void openLibs() {
        this._openLibs(this.luaState);
    }

    private synchronized native void luajava_open(CPtr var1, int var2);

    private synchronized native Object _getObjectFromUserdata(CPtr var1, int var2) throws LuaException;

    private synchronized native boolean _isObject(CPtr var1, int var2);

    private synchronized native void _pushJavaObject(CPtr var1, Object var2);

    private synchronized native void _pushJavaFunction(CPtr var1, JavaFunction var2) throws LuaException;

    private synchronized native boolean _isJavaFunction(CPtr var1, int var2);

    public Object getObjectFromUserdata(int n) throws LuaException {
        return this._getObjectFromUserdata(this.luaState, n);
    }

    public boolean isObject(int n) {
        return this._isObject(this.luaState, n);
    }

    public void pushJavaObject(Object object) {
        this._pushJavaObject(this.luaState, object);
    }

    public void pushJavaFunction(JavaFunction javaFunction) throws LuaException {
        this._pushJavaFunction(this.luaState, javaFunction);
    }

    public boolean isJavaFunction(int n) {
        return this._isJavaFunction(this.luaState, n);
    }

    public void pushObjectValue(Object object) throws LuaException {
        if (object == null) {
            this.pushNil();
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            this.pushBoolean(bl);
        } else if (object instanceof Number) {
            this.pushNumber(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.pushString((String)object);
        } else if (object instanceof JavaFunction) {
            JavaFunction javaFunction = (JavaFunction)object;
            this.pushJavaFunction(javaFunction);
        } else if (object instanceof LuaObject) {
            LuaObject luaObject = (LuaObject)object;
            luaObject.push();
        } else if (object instanceof byte[]) {
            this.pushString((byte[])object);
        } else {
            this.pushJavaObject(object);
        }
    }

    public synchronized Object toJavaObject(int n) throws LuaException {
        Object object = null;
        if (this.isBoolean(n)) {
            object = new Boolean(this.toBoolean(n));
        } else if (this.type(n) == LUA_TSTRING.intValue()) {
            object = this.toString(n);
        } else if (this.isFunction(n)) {
            object = this.getLuaObject(n);
        } else if (this.isTable(n)) {
            object = this.getLuaObject(n);
        } else if (this.type(n) == LUA_TNUMBER.intValue()) {
            object = new Double(this.toNumber(n));
        } else if (this.isUserdata(n)) {
            object = this.isObject(n) ? this.getObjectFromUserdata(n) : this.getLuaObject(n);
        } else if (this.isNil(n)) {
            object = null;
        }
        return object;
    }

    public LuaObject getLuaObject(String string) {
        return new LuaObject(this, string);
    }

    public LuaObject getLuaObject(LuaObject luaObject, String string) throws LuaException {
        if (luaObject.L.getCPtrPeer() != this.luaState.getPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(luaObject, string);
    }

    public LuaObject getLuaObject(LuaObject luaObject, Number number) throws LuaException {
        if (luaObject.L.getCPtrPeer() != this.luaState.getPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(luaObject, number);
    }

    public LuaObject getLuaObject(LuaObject luaObject, LuaObject luaObject2) throws LuaException {
        if (luaObject.getLuaState().getCPtrPeer() != this.luaState.getPeer() || luaObject.getLuaState().getCPtrPeer() != luaObject2.getLuaState().getCPtrPeer()) {
            throw new LuaException("Object must have the same LuaState as the parent!");
        }
        return new LuaObject(luaObject, luaObject2);
    }

    public LuaObject getLuaObject(int n) {
        return new LuaObject(this, n);
    }

    public static Number convertLuaNumber(Double d, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(d.intValue());
            }
            if (clazz == Long.TYPE) {
                return new Long(d.longValue());
            }
            if (clazz == Float.TYPE) {
                return new Float(d.floatValue());
            }
            if (clazz == Double.TYPE) {
                return d;
            }
            if (clazz == Byte.TYPE) {
                return new Byte(d.byteValue());
            }
            if (clazz == Short.TYPE) {
                return new Short(d.shortValue());
            }
        } else if (clazz.isAssignableFrom(Number.class)) {
            if (clazz.isAssignableFrom(Integer.class)) {
                return new Integer(d.intValue());
            }
            if (clazz.isAssignableFrom(Long.class)) {
                return new Long(d.longValue());
            }
            if (clazz.isAssignableFrom(Float.class)) {
                return new Float(d.floatValue());
            }
            if (clazz.isAssignableFrom(Double.class)) {
                return d;
            }
            if (clazz.isAssignableFrom(Byte.class)) {
                return new Byte(d.byteValue());
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return new Short(d.shortValue());
            }
        }
        return null;
    }

    static {
        System.loadLibrary(LUAJAVA_LIB);
        LUA_GCSTOP = new Integer(0);
        LUA_GCRESTART = new Integer(1);
        LUA_GCCOLLECT = new Integer(2);
        LUA_GCCOUNT = new Integer(3);
        LUA_GCCOUNTB = new Integer(4);
        LUA_GCSTEP = new Integer(5);
        LUA_GCSETPAUSE = new Integer(6);
        LUA_GCSETSTEPMUL = new Integer(7);
    }
}

