/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.StringTokenizer;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaInvocationHandler;
import org.keplerproject.luajava.LuaState;

public class LuaObject {
    protected Integer ref;
    protected LuaState L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaState luaState, String string) {
        LuaState luaState2 = luaState;
        synchronized (luaState2) {
            this.L = luaState;
            luaState.getGlobal(string);
            this.registerValue(-1);
            luaState.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject luaObject, String string) throws LuaException {
        LuaState luaState = luaObject.getLuaState();
        synchronized (luaState) {
            this.L = luaObject.getLuaState();
            if (!luaObject.isTable() && !luaObject.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            luaObject.push();
            this.L.pushString(string);
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject luaObject, Number number) throws LuaException {
        LuaState luaState = luaObject.getLuaState();
        synchronized (luaState) {
            this.L = luaObject.getLuaState();
            if (!luaObject.isTable() && !luaObject.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            luaObject.push();
            this.L.pushNumber(number.doubleValue());
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaObject luaObject, LuaObject luaObject2) throws LuaException {
        if (luaObject.getLuaState() != luaObject2.getLuaState()) {
            throw new LuaException("LuaStates must be the same!");
        }
        LuaState luaState = luaObject.getLuaState();
        synchronized (luaState) {
            if (!luaObject.isTable() && !luaObject.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            this.L = luaObject.getLuaState();
            luaObject.push();
            luaObject2.push();
            this.L.getTable(-2);
            this.L.remove(-2);
            this.registerValue(-1);
            this.L.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaObject(LuaState luaState, int n) {
        LuaState luaState2 = luaState;
        synchronized (luaState2) {
            this.L = luaState;
            this.registerValue(n);
        }
    }

    public LuaState getLuaState() {
        return this.L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerValue(int n) {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.L.pushValue(n);
            int n2 = this.L.Lref(LuaState.LUA_REGISTRYINDEX);
            this.ref = new Integer(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            LuaState luaState = this.L;
            synchronized (luaState) {
                if (this.L.getCPtrPeer() != 0L) {
                    this.L.LunRef(LuaState.LUA_REGISTRYINDEX, this.ref);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to release object " + this.ref);
        }
    }

    public void push() {
        this.L.rawGetI(LuaState.LUA_REGISTRYINDEX, this.ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNil() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isNil(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBoolean() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isBoolean(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumber() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isNumber(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isString(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFunction() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isFunction(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaObject() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isObject(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaFunction() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isJavaFunction(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTable() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isTable(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserdata() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.isUserdata(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int type() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            int n = this.L.type(-1);
            this.L.pop(1);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            boolean bl = this.L.toBoolean(-1);
            this.L.pop(1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNumber() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            double d = this.L.toNumber(-1);
            this.L.pop(1);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            String string = this.L.toString(-1);
            this.L.pop(1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            this.push();
            Object object = this.L.getObjectFromUserdata(-1);
            this.L.pop(1);
            return object;
        }
    }

    public LuaObject getField(String string) throws LuaException {
        return this.L.getLuaObject(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] call(Object[] objectArray, int n) throws LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            Object object;
            int n2;
            int n3;
            if (!(this.isFunction() || this.isTable() || this.isUserdata())) {
                throw new LuaException("Invalid object. Not a function, table or userdata .");
            }
            int n4 = this.L.getTop();
            this.push();
            if (objectArray != null) {
                n3 = objectArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    this.L.pushObjectValue(object);
                }
            } else {
                n3 = 0;
            }
            if ((n2 = this.L.pcall(n3, n, 0)) != 0) {
                if (this.L.isString(-1)) {
                    object = this.L.toString(-1);
                    this.L.pop(1);
                } else {
                    object = "";
                }
                object = n2 == LuaState.LUA_ERRRUN ? "Runtime error. " + (String)object : (n2 == LuaState.LUA_ERRMEM ? "Memory allocation error. " + (String)object : (n2 == LuaState.LUA_ERRERR ? "Error while running the error handler function. " + (String)object : "Lua Error code " + n2 + ". " + (String)object));
                throw new LuaException((String)object);
            }
            if (n == LuaState.LUA_MULTRET) {
                n = this.L.getTop() - n4;
            }
            if (this.L.getTop() - n4 < n) {
                throw new LuaException("Invalid Number of Results .");
            }
            object = new Object[n];
            for (int i = n; i > 0; --i) {
                object[i - 1] = this.L.toJavaObject(-1);
                this.L.pop(1);
            }
            return object;
        }
    }

    public Object call(Object[] objectArray) throws LuaException {
        return this.call(objectArray, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LuaState luaState = this.L;
        synchronized (luaState) {
            try {
                if (this.isNil()) {
                    return "nil";
                }
                if (this.isBoolean()) {
                    return String.valueOf(this.getBoolean());
                }
                if (this.isNumber()) {
                    return String.valueOf(this.getNumber());
                }
                if (this.isString()) {
                    return this.getString();
                }
                if (this.isFunction()) {
                    return "Lua Function";
                }
                if (this.isJavaObject()) {
                    return this.getObject().toString();
                }
                if (this.isUserdata()) {
                    return "Userdata";
                }
                if (this.isTable()) {
                    return "Lua Table";
                }
                if (this.isJavaFunction()) {
                    return "Java Function";
                }
                return null;
            }
            catch (LuaException luaException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createProxy(String string) throws ClassNotFoundException, LuaException {
        LuaState luaState = this.L;
        synchronized (luaState) {
            if (!this.isTable()) {
                throw new LuaException("Invalid Object. Must be Table.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Class[] classArray = new Class[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                classArray[n] = Class.forName(stringTokenizer.nextToken());
                ++n;
            }
            LuaInvocationHandler luaInvocationHandler = new LuaInvocationHandler(this);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), classArray, (InvocationHandler)luaInvocationHandler);
        }
    }
}

