/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaObject;
import org.keplerproject.luajava.LuaState;
import org.keplerproject.luajava.LuaStateFactory;

public final class LuaJavaAPI {
    private LuaJavaAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int objectIndex(int n, Object object, String string) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Object object2;
            int n2 = luaState.getTop();
            Object[] objectArray = new Object[n2 - 1];
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            Method[] methodArray = clazz.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray;
                if (!methodArray[i].getName().equals(string) || (classArray = methodArray[i].getParameterTypes()).length != n2 - 1) continue;
                boolean bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    try {
                        objectArray[j] = LuaJavaAPI.compareTypes(luaState, classArray[j], j + 2);
                        continue;
                    }
                    catch (Exception exception) {
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                throw new LuaException("Invalid method call. No such method.");
            }
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                object2 = object instanceof Class ? method.invoke(null, objectArray) : method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                throw new LuaException(exception);
            }
            if (object2 == null) {
                return 0;
            }
            luaState.pushObjectValue(object2);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int classIndex(int n, Class clazz, String string) throws LuaException {
        LuaState luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState) {
            int n2 = LuaJavaAPI.checkField(n, clazz, string);
            if (n2 != 0) {
                return 1;
            }
            n2 = LuaJavaAPI.checkMethod(n, clazz, string);
            if (n2 != 0) {
                return 2;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int javaNewInstance(int n, String string) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LuaException(classNotFoundException);
            }
            Object object = LuaJavaAPI.getObjInstance(luaState, clazz);
            luaState.pushJavaObject(object);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int javaNew(int n, Class clazz) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Object object = LuaJavaAPI.getObjInstance(luaState, clazz);
            luaState.pushJavaObject(object);
            return 1;
        }
    }

    public static int javaLoadLib(int n, String string, String string2) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LuaException(classNotFoundException);
            }
            try {
                Method method = clazz.getMethod(string2, LuaState.class);
                Object object = method.invoke(null, luaState);
                if (object != null && object instanceof Integer) {
                    return (Integer)object;
                }
                return 0;
            }
            catch (Exception exception) {
                throw new LuaException("Error on calling method. Library could not be loaded. " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getObjInstance(LuaState luaState, Class clazz) throws LuaException {
        LuaState luaState2 = luaState;
        synchronized (luaState2) {
            Object t;
            int n = luaState.getTop();
            Object[] objectArray = new Object[n - 1];
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length != n - 1) continue;
                boolean bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    try {
                        objectArray[j] = LuaJavaAPI.compareTypes(luaState, classArray[j], j + 2);
                        continue;
                    }
                    catch (Exception exception) {
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                constructor = constructorArray[i];
                break;
            }
            if (constructor == null) {
                throw new LuaException("Invalid method call. No such method.");
            }
            try {
                t = constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new LuaException(exception);
            }
            if (t == null) {
                throw new LuaException("Couldn't instantiate java Object");
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkField(int n, Object object, String string) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Field field = null;
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            try {
                field = clazz.getField(string);
            }
            catch (Exception exception) {
                return 0;
            }
            if (field == null) {
                return 0;
            }
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (Exception exception) {
                return 0;
            }
            if (object == null) {
                return 0;
            }
            luaState.pushObjectValue(object2);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkMethod(int n, Object object, String string) {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string)) continue;
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createProxyObject(int n, String string) throws LuaException {
        LuaState luaState;
        LuaState luaState2 = luaState = LuaStateFactory.getExistingState(n);
        synchronized (luaState2) {
            try {
                if (!luaState.isTable(2)) {
                    throw new LuaException("Parameter is not a table. Can't create proxy.");
                }
                LuaObject luaObject = luaState.getLuaObject(2);
                Object object = luaObject.createProxy(string);
                luaState.pushJavaObject(object);
            }
            catch (Exception exception) {
                throw new LuaException(exception);
            }
            return 1;
        }
    }

    private static Object compareTypes(LuaState luaState, Class clazz, int n) throws LuaException {
        boolean bl = true;
        Object object = null;
        if (luaState.isBoolean(n)) {
            if (clazz.isPrimitive()) {
                if (clazz != Boolean.TYPE) {
                    bl = false;
                }
            } else if (!clazz.isAssignableFrom(Boolean.class)) {
                bl = false;
            }
            object = new Boolean(luaState.toBoolean(n));
        } else if (luaState.type(n) == LuaState.LUA_TSTRING.intValue()) {
            if (!clazz.isAssignableFrom(String.class)) {
                bl = false;
            } else {
                object = luaState.toString(n);
            }
        } else if (luaState.isFunction(n)) {
            if (!clazz.isAssignableFrom(LuaObject.class)) {
                bl = false;
            } else {
                object = luaState.getLuaObject(n);
            }
        } else if (luaState.isTable(n)) {
            if (!clazz.isAssignableFrom(LuaObject.class)) {
                bl = false;
            } else {
                object = luaState.getLuaObject(n);
            }
        } else if (luaState.type(n) == LuaState.LUA_TNUMBER.intValue()) {
            Double d = new Double(luaState.toNumber(n));
            object = LuaState.convertLuaNumber(d, clazz);
            if (object == null) {
                bl = false;
            }
        } else if (luaState.isUserdata(n)) {
            if (luaState.isObject(n)) {
                Object object2 = luaState.getObjectFromUserdata(n);
                if (!clazz.isAssignableFrom(object2.getClass())) {
                    bl = false;
                } else {
                    object = object2;
                }
            } else if (!clazz.isAssignableFrom(LuaObject.class)) {
                bl = false;
            } else {
                object = luaState.getLuaObject(n);
            }
        } else if (luaState.isNil(n)) {
            object = null;
        } else {
            throw new LuaException("Invalid Parameters.");
        }
        if (!bl) {
            throw new LuaException("Invalid Parameter.");
        }
        return object;
    }
}

