/*
 * Decompiled with CFR 0.152.
 */
package org.keplerproject.luajava;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.keplerproject.luajava.LuaException;
import org.keplerproject.luajava.LuaState;
import org.keplerproject.luajava.LuaStateFactory;

public class Console {
    public static void main(String[] stringArray) {
        try {
            String string;
            LuaState luaState = LuaStateFactory.newLuaState();
            luaState.openLibs();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = luaState.LloadFile(stringArray[i]);
                    if (n == 0) {
                        n = luaState.pcall(0, 0, 0);
                    }
                    if (n == 0) continue;
                    throw new LuaException("Error on file: " + stringArray[i] + ". " + luaState.toString(-1));
                }
                return;
            }
            System.out.println("API Lua Java - console mode.");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> ");
            while ((string = bufferedReader.readLine()) != null && !string.equals("exit")) {
                int n = luaState.LloadBuffer(string.getBytes(), "from console");
                if (n == 0) {
                    n = luaState.pcall(0, 0, 0);
                }
                if (n != 0) {
                    System.err.println("Error on line: " + string);
                    System.err.println(luaState.toString(-1));
                }
                System.out.print("> ");
            }
            luaState.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

