/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import sina.mobile.tianqitong.constants.AppPreferences;
import sina.mobile.tianqitong.util.MacAddressUtil;
import sina.mobile.tianqitong.util.NetworkUtil;
import sina.mobile.tianqitong.util.SystemInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    public static void sendMessage() {
        new Thread(new Runnable(){

            public void run() {
                String oldVersion = AppPreferences.getVersion("version");
                String curVersion = "2.3.1";
                String oldDate = AppPreferences.getDate("date");
                String curDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
                if (!oldVersion.equals(curVersion) || !oldDate.equals(curDate)) {
                    NetworkUtil.sendHttp("http://api.weibo.cn/interface/f/ttt/v3/deallog.php", MessageUtil.getInstallParamMap(), MessageUtil.getInstallPostData());
                    AppPreferences.putVersion("version", curVersion);
                    AppPreferences.putDate("date", curDate);
                }
            }
        }).start();
    }

    public static void sendFeedBack(final String msg, final String contact) {
        new Thread(new Runnable(){

            public void run() {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("pd", "pf");
                NetworkUtil.sendHttp("http://forecast.sina.cn/app/feed.php", paramsMap, MessageUtil.getFeedbackPostData(msg, contact));
            }
        }).start();
    }

    private static HashMap<String, String> getInstallParamMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wm", "free");
        StringBuilder from = new StringBuilder();
        from.append("pf");
        from.append("231");
        from.append("1");
        from.append("5010");
        params.put("from", from.toString());
        StringBuilder ua = new StringBuilder();
        ua.append("PC__SkinDIY__");
        ua.append("2.3.1");
        ua.append("__");
        ua.append(SystemInformation.osName.replace(" ", ""));
        params.put("ua", ua.toString());
        params.put("act", "minfo");
        return params;
    }

    private static byte[] getInstallPostData() {
        byte[] bs = new byte[]{};
        String from = "pf23115010";
        String os = SystemInformation.osName.replace(" ", "");
        String ua = "PC__SkinDIY__2.3.1__" + os;
        String macAddress = MacAddressUtil.getLocalMac(SystemInformation.userLanguage);
        String imei = "";
        imei = SystemInformation.osName.toLowerCase().startsWith("windows") ? macAddress.replace("-", "") : macAddress.replace(":", "");
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        qparams.add(new BasicNameValuePair("wm", "free"));
        qparams.add(new BasicNameValuePair("from", from));
        qparams.add(new BasicNameValuePair("ua", ua));
        qparams.add(new BasicNameValuePair("imei", imei));
        qparams.add(new BasicNameValuePair("os", os));
        qparams.add(new BasicNameValuePair("mac", macAddress));
        String content = URLEncodedUtils.format(qparams, (String)"UTF-8");
        try {
            bs = content.getBytes("utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bs;
    }

    private static byte[] getFeedbackPostData(String msg, String contact) {
        byte[] bs = new byte[]{};
        String macAddress = MacAddressUtil.getLocalMac(SystemInformation.userLanguage);
        String imei = "";
        imei = SystemInformation.osName.toLowerCase().startsWith("windows") ? macAddress.replace("-", "") : macAddress.replace(":", "");
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        qparams.add(new BasicNameValuePair("pd", "pf"));
        qparams.add(new BasicNameValuePair("pt", "5010"));
        qparams.add(new BasicNameValuePair("pv", "2.3.1"));
        qparams.add(new BasicNameValuePair("sv", SystemInformation.osName));
        qparams.add(new BasicNameValuePair("device", SystemInformation.osName));
        qparams.add(new BasicNameValuePair("uid", imei));
        qparams.add(new BasicNameValuePair("content", msg));
        qparams.add(new BasicNameValuePair("addition", "\u8fd9\u662f\u6765\u81ea\u5929\u6c14\u901aAndroid\u7248\u684c\u9762\u63d2\u4ef6\u76ae\u80a4\u7f16\u8f91\u5668\u7684\u53cd\u9988."));
        qparams.add(new BasicNameValuePair("contact", contact));
        qparams.add(new BasicNameValuePair("config", ""));
        String content = URLEncodedUtils.format(qparams, (String)"UTF-8");
        try {
            bs = content.getBytes("utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bs;
    }
}

