/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import sina.mobile.tianqitong.util.Log;

public class MacAddressUtil {
    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getLocalIp() {
        String localIp = null;
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Log.error("\u83b7\u53d6IP\u5730\u5740\u5931\u8d25!");
            Log.error(e);
        }
        return localIp;
    }

    public static String getLocalMac(String language) {
        String os = MacAddressUtil.getOSName();
        String mac = null;
        try {
            mac = os.startsWith("windows") ? MacAddressUtil.getWindowsMACAddress(language) : (os.startsWith("mac") ? MacAddressUtil.getUnixMACAddress() : MacAddressUtil.getLinuxMACAddress(language));
            if (null == mac) {
                Log.error("\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25!");
                return "";
            }
        }
        catch (Exception e) {
            Log.error("\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25!");
            e.printStackTrace();
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWindowsMACAddress(String language) {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ipconfig /all");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
            String line = "";
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.indexOf("\u7269\u7406\u5730\u5740");
                if (-1 == index) {
                    index = line.toLowerCase().indexOf("physical address");
                }
                if (index < 0 || (index = line.indexOf(":")) < 0 || null == (mac = line.substring(index + 1).trim()) || "".equals(mac)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnixMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("ether");
                if (index >= 0) {
                    mac = line.substring(index + "ether".length()).trim();
                }
                if (null == mac || "".equals(mac)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.error(e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                Log.error(e1);
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxMACAddress(String language) {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                if ("zh".equals(language)) {
                    if (line.contains("\u786c\u4ef6\u5730\u5740")) {
                        mac = line.substring(line.lastIndexOf("\u786c\u4ef6\u5730\u5740") + "\u786c\u4ef6\u5730\u5740".length(), line.length()).trim();
                    }
                } else if ("en".equals(language) && (index = line.toLowerCase().indexOf("hwaddr")) >= 0) {
                    mac = line.substring(index + "hwaddr".length()).trim();
                }
                if (null == mac || "".equals(mac)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.error(e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                Log.error(e1);
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }
}

