/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static void createThumbnail(File file, String path) {
        try {
            int w;
            int h;
            BufferedImage image = ImageIO.read(file);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            double scale = (double)width * 1.0 / (double)height;
            if (scale < 1.0) {
                h = 100;
                w = Math.max(1, (int)((double)h * scale));
            } else {
                w = 100;
                h = Math.max(1, (int)((double)w / scale));
            }
            BufferedImage bufferedImage = new BufferedImage(w, h, 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image.getScaledInstance(w, h, 4), null, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(path + file.getName()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isImage(File file) {
        boolean result = false;
        try {
            if (null == file || !file.exists()) {
                return result;
            }
            BufferedImage img = ImageIO.read(file);
            result = img != null && ((Image)img).getWidth(null) > 0 && ((Image)img).getHeight(null) > 0;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

