/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static File createFileDir(String fileDir) {
        File file = new File(fileDir);
        file.mkdirs();
        return file;
    }

    public static File createFile(String filePath, String fileName) {
        FileUtil.createFileDir(filePath);
        File file = new File(filePath, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream inputStream = new FileInputStream(src);
        FileOutputStream outputStream = new FileOutputStream(dst);
        FileChannel inChannel = inputStream.getChannel();
        FileChannel outChannel = outputStream.getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != outputStream) {
                outputStream.close();
            }
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void copyDir(File srcDir, File dstDir) throws IOException {
        if (null == srcDir) {
            return;
        }
        if (!srcDir.isDirectory()) {
            return;
        }
        if (!dstDir.exists()) {
            dstDir.mkdirs();
        }
        File[] listFiles = srcDir.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(dstDir.getPath() + File.separator + file.getName()));
                continue;
            }
            if (!file.isFile()) continue;
            FileUtil.copyFile(file, new File(dstDir.getPath() + File.separator + file.getName()));
        }
    }

    public static boolean isFileExits(String filePath, String fileName) {
        File file = new File(filePath, fileName);
        return file.exists();
    }

    public static boolean deleteFile(String filePathAndName) {
        try {
            if (filePathAndName == null) {
                return false;
            }
            File file = new File(filePathAndName);
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(String filePath, String fileName) {
        boolean isExits = FileUtil.isFileExits(filePath, fileName);
        if (isExits) {
            File file = new File(filePath, fileName);
            return FileUtil.deleteFile(file);
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        boolean isSuccess = false;
        if (file.isFile()) {
            isSuccess = file.delete();
        } else if (file.isDirectory()) {
            isSuccess = FileUtil.deleteFolder(file.getAbsolutePath());
        }
        return isSuccess;
    }

    public static boolean deleteFolder(String folderPath) {
        try {
            if (folderPath == null) {
                return false;
            }
            FileUtil.deleteAllFile(folderPath);
            File file = new File(folderPath);
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void deleteAllFile(String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] list = file.list();
        File tempFile = null;
        for (int i = 0; i < list.length; ++i) {
            tempFile = path.endsWith(File.separator) ? new File(path + list[i]) : new File(path + File.separator + list[i]);
            if (tempFile.isFile()) {
                tempFile.delete();
                continue;
            }
            if (!tempFile.isDirectory()) continue;
            FileUtil.deleteAllFile(path + File.separator + list[i]);
            FileUtil.deleteFolder(path + File.separator + list[i]);
        }
    }

    public static void renameFileOrFolder(String filePath, String newName) {
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        File newFile = new File(file.getParent() + File.separator + newName);
        file.renameTo(newFile);
    }

    public static String getExtensionWithoutPoint(File file) {
        if (null == file) {
            throw new NullPointerException("The param file is null");
        }
        String name = file.getName();
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(extensionIndex + 1).toLowerCase();
        }
        return null;
    }

    public static String getExtension(File file) {
        if (null == file) {
            throw new NullPointerException("The param file is null");
        }
        String name = file.getName();
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(extensionIndex).toLowerCase();
        }
        return null;
    }

    public static String getNameWithoutExten(File file) {
        if (null == file) {
            throw new NullPointerException("The param file is null");
        }
        String name = file.getName();
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(0, extensionIndex).toLowerCase();
        }
        return null;
    }

    public static ArrayList<String> getFileNamesInDir(File dir) {
        ArrayList<String> names = new ArrayList<String>();
        if (null == dir || !dir.isDirectory()) {
            return names;
        }
        File[] files = dir.listFiles();
        if (null == files || files.length <= 0) {
            return names;
        }
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }
}

