/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CharUtil {
    public static String ISO2GB(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("ISO-8859-1"), "GB2312");
        }
        catch (UnsupportedEncodingException ex) {
            result = ex.toString();
        }
        return result;
    }

    public static String GB2ISO(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("GB2312"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String Utf8URLencode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return text;
        }
    }

    public static String Utf8URLdecode(String text) {
        String result = "";
        int p = 0;
        if (null != text && text.length() > 0) {
            p = (text = text.toLowerCase()).indexOf("%e");
            if (p == -1) {
                return text;
            }
            while (p != -1) {
                result = result + text.substring(0, p);
                if ("".equals(text = text.substring(p, text.length())) || text.length() < 9) {
                    return result;
                }
                result = result + CharUtil.CodeToWord(text.substring(0, 9));
                text = text.substring(9, text.length());
                p = text.indexOf("%e");
            }
        }
        return result + text;
    }

    private static String CodeToWord(String text) {
        String result;
        if (CharUtil.Utf8codeCheck(text)) {
            byte[] code = new byte[]{(byte)(Integer.parseInt(text.substring(1, 3), 16) - 256), (byte)(Integer.parseInt(text.substring(4, 6), 16) - 256), (byte)(Integer.parseInt(text.substring(7, 9), 16) - 256)};
            try {
                result = new String(code, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                result = null;
            }
        } else {
            result = text;
        }
        return result;
    }

    private static boolean Utf8codeCheck(String text) {
        String sign = "";
        if (text.startsWith("%e")) {
            int i = 0;
            int p = 0;
            while (p != -1) {
                if ((p = text.indexOf("%", p)) != -1) {
                    ++p;
                }
                sign = sign + p;
                ++i;
            }
        }
        return sign.equals("147-1");
    }

    public static boolean isUtf8Url(String text) {
        int p = (text = text.toLowerCase()).indexOf("%");
        if (p != -1 && text.length() - p > 9) {
            text = text.substring(p, p + 9);
        }
        return CharUtil.Utf8codeCheck(text);
    }
}

