/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ButtonColorsHelper {
    private static final File COLORS_CONFIG_FILE = new File("resource" + File.separator + "Colors.xml");
    private static HashMap<String, Color> mButtonColorMap = new HashMap();
    private static final String BUTTON_NODE = "Button";
    private static final Color DEFAULT_COLOR = new Color(16727702);

    public static void readConfig() {
        try {
            if (!COLORS_CONFIG_FILE.exists() || COLORS_CONFIG_FILE.isDirectory() || !COLORS_CONFIG_FILE.canRead()) {
                return;
            }
            FileReader fileReader = new FileReader(COLORS_CONFIG_FILE);
            BufferedReader br = new BufferedReader(fileReader);
            StringBuilder sb = new StringBuilder();
            String tempStr = "";
            while ((tempStr = br.readLine()) != null) {
                sb.append(tempStr);
            }
            Document document = DocumentHelper.parseText(sb.toString());
            Element element = document.getRootElement();
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element button = (Element)iterator.next();
                if (!BUTTON_NODE.equals(button.getName()) || button.attributeValue("FunctionId") == null || button.attributeValue("Color") == null) continue;
                Color color = new Color(Integer.parseInt(button.attributeValue("Color"), 16));
                mButtonColorMap.put(button.attributeValue("FunctionId"), color);
            }
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Color getButtonColor(String functionId) {
        if (mButtonColorMap.containsKey(functionId)) {
            return mButtonColorMap.get(functionId);
        }
        return DEFAULT_COLOR;
    }
}

