/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.util;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class BufferedImagePool {
    private static Map<String, BufferedImage> imageZipCache = new HashMap<String, BufferedImage>();

    public static void clearImageCache() {
        imageZipCache.clear();
    }

    public static void putZipImage(String filePath, BufferedImage image) {
        imageZipCache.put(filePath, image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getZipImage(File zipFile, String fileName) {
        String path = zipFile.getAbsolutePath() + File.separator + fileName;
        BufferedImage bReference = imageZipCache.get(path);
        if (bReference != null) {
            return bReference;
        }
        BufferedImage image = null;
        InputStream inputStream = null;
        BufferedInputStream ibis = null;
        try {
            ZipFile izf = new ZipFile(zipFile);
            ZipEntry ize = izf.getEntry(fileName);
            inputStream = izf.getInputStream(ize);
            ibis = new BufferedInputStream(inputStream);
            image = ImageIO.read(ibis);
            BufferedImagePool.putZipImage(path, image);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (ibis != null) {
                try {
                    ibis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return image;
    }

    public static BufferedImage getImage(String filePath) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(filePath));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return image;
    }
}

