/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.uodoredo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import sina.mobile.tianqitong.adapter.SkinAdapter;

public class SkinEdit
extends AbstractUndoableEdit {
    protected SkinAdapter mEditedSkinAdapter;
    protected SkinAdapter mSkinAdapterUndo;
    protected SkinAdapter mSkinAdapterRedo;
    protected boolean mInProgress;
    protected String mName;

    public SkinEdit(SkinAdapter SkinAdapter2) {
        this.mEditedSkinAdapter = SkinAdapter2;
    }

    public SkinEdit(SkinAdapter SkinAdapter2, SkinAdapter before) {
        this(SkinAdapter2);
        this.start(before);
    }

    public SkinEdit(SkinAdapter SkinAdapter2, SkinAdapter before, SkinAdapter after) {
        this(SkinAdapter2, before);
        this.end(after);
    }

    private void start(SkinAdapter fml) {
        this.mSkinAdapterUndo = fml;
        this.mInProgress = true;
    }

    public void end(SkinAdapter fml) {
        if (!this.mInProgress) {
            throw new IllegalStateException("end called before start");
        }
        if (fml != null) {
            this.mSkinAdapterRedo = fml;
            this.mInProgress = false;
        }
    }

    public void undo() throws CannotUndoException {
        if (this.mEditedSkinAdapter == null) {
            throw new CannotUndoException();
        }
        this.mEditedSkinAdapter.setSkin(this.mSkinAdapterUndo.getSkin());
    }

    public void redo() throws CannotRedoException {
        if (this.mEditedSkinAdapter == null) {
            throw new CannotRedoException();
        }
        this.mEditedSkinAdapter.setSkin(this.mSkinAdapterRedo.getSkin());
    }

    public boolean canUndo() {
        return this.mSkinAdapterUndo != null && this.mEditedSkinAdapter != null;
    }

    public boolean canRedo() {
        return this.mSkinAdapterRedo != null && this.mEditedSkinAdapter != null;
    }

    public void die() {
        this.mSkinAdapterUndo = null;
        this.mSkinAdapterRedo = null;
        this.mInProgress = false;
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (!this.mInProgress || anEdit.getClass() == this.getClass()) {
            // empty if block
        }
        return false;
    }

    public void setPresentationName(String s) {
        this.mName = s;
    }

    public String getPresentationName() {
        return this.mName;
    }
}

