/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin.moji;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xmlpull.v1.XmlPullParserException;
import sina.mobile.tianqitong.skin.moji.DrawPicture;
import sina.mobile.tianqitong.skin.moji.DrawSetting;
import sina.mobile.tianqitong.skin.moji.DrawText;
import sina.mobile.tianqitong.skin.moji.MojiWidget;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.Log;
import sina.mobile.tianqitong.util.ZipUtil;

public class MojiToTQT {
    public static final String SUFFIX = "-TQT";
    public static final String SUFFIX4X2 = "-4x2";
    public static final String SUFFIX4X1 = "-4x1";
    private static final String[] TEXT_KEYS = new String[]{"w_fd1_night_temp", "w_fd2_night_temp", "w_fd3_night_temp", "w_fd4_night_temp", "w_fd5_night_temp", "w_fd1_day_temp", "w_fd2_day_temp", "w_fd3_day_temp", "w_fd4_day_temp", "w_fd5_day_temp", "w_cd_temp_type1", "date_short_type1", "date_short_type2", "date_short_type3", "date_nl", "date_jq", "w_fd2_week", "w_fd3_week", "w_fd4_week", "w_fd5_week", "week", "w_cd_desp", "w_cd_uv", "w_cd_Humidity", "w_cd_wind", "w_cd_time", "w_cd_update_time", "city_name", "w_fd1_night_desp", "w_fd2_night_desp", "w_fd3_night_desp", "w_fd4_night_desp", "w_fd5_night_desp", "w_fd1_day_desp", "w_fd2_day_desp", "w_fd3_day_desp", "w_fd4_day_desp", "w_fd5_day_desp", "aqi_quality_desp_type1"};
    private static final HashMap<String, String> mWidths = new HashMap();
    private static final HashMap<String, String> mPngs = new HashMap();
    private static final HashMap<String, String> mKeys = new HashMap();
    private static final int LDPI_WIDTH = 240;
    private static final int MDPI_WIDTH = 320;
    private static final int HDPI_WIDTH = 480;

    public static void main(String[] args) {
        MojiToTQT test = new MojiToTQT();
        String testKey = "$date_short_type3 $week \u519c\u5386$date_nl";
        String[] values = test.analyzeTextKey(testKey);
        for (int i = 0; i < values.length; ++i) {
            Log.info("\"" + values[i] + "\"");
        }
    }

    public void transformMojiToTQT(File file) throws IOException {
        MojiWidget widget = this.readMoji(file);
        this.writeTQT(widget);
    }

    private void uncompressMojiZip(File file) throws IOException {
        String name = FileUtil.getNameWithoutExten(file);
        ZipUtil.uncompress(file.getAbsolutePath(), "temp/" + name);
    }

    public MojiWidget readMoji(File path) throws IOException {
        this.uncompressMojiZip(path);
        MojiWidget widget = new MojiWidget("temp/" + FileUtil.getNameWithoutExten(path));
        try {
            widget.parseLayoutXml();
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        return widget;
    }

    public void writeTQT(MojiWidget widget) throws IOException {
        File dir = new File(widget.getDir() + SUFFIX);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        for (int i = 0; i < widget.getDrawSettings().size(); ++i) {
            File dir2;
            DrawSetting setting = widget.getDrawSettings().get(i);
            if (setting.getOrientation() == 0) {
                dir2 = null;
                if (setting.getWidgetType() == 0) {
                    dir2 = new File(dir, widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X2);
                    if (!dir2.exists() || !dir2.isDirectory()) {
                        dir2.mkdirs();
                    }
                    this.preCreate(widget, "4x2");
                    if (!setting.getResolution().equals("320*480")) continue;
                    this.writeXML(setting, dir2.getPath() + "/layout-port-mdpi.xml");
                    continue;
                }
                if (setting.getWidgetType() != 1) continue;
                dir2 = new File(dir, widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X1);
                if (!dir2.exists() || !dir2.isDirectory()) {
                    dir2.mkdirs();
                }
                this.preCreate(widget, "4x1");
                if (!setting.getResolution().equals("320*480")) continue;
                this.writeXML(setting, dir2.getPath() + "/layout-port-mdpi.xml");
                continue;
            }
            dir2 = null;
            if (setting.getWidgetType() == 0) {
                dir2 = new File(dir, widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X2);
                if (!dir2.exists() || !dir2.isDirectory()) {
                    dir2.mkdirs();
                }
                this.preCreate(widget, "4x2");
                if (!setting.getResolution().equals("320*480")) continue;
                this.writeXML(setting, dir2.getPath() + "/layout-land-mdpi.xml");
                continue;
            }
            if (setting.getWidgetType() != 1) continue;
            dir2 = new File(dir, widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X1);
            if (!dir2.exists() || !dir2.isDirectory()) {
                dir2.mkdirs();
            }
            this.preCreate(widget, "4x1");
            if (!setting.getResolution().equals("320*480")) continue;
            this.writeXML(setting, dir2.getPath() + "/layout-land-mdpi.xml");
        }
    }

    private void preCreate(MojiWidget widget, String types) throws IOException {
        File drawableDir3;
        File drawableDir2;
        String temp = types.equals("4x2") ? widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X2 : widget.getDir().substring(widget.getDir().lastIndexOf("/")) + SUFFIX4X1;
        File drawableDir = new File(widget.getDir() + SUFFIX + "/" + temp + "/drawable-hdpi");
        if (!drawableDir.exists() || !drawableDir.isDirectory()) {
            drawableDir.mkdirs();
        }
        if (!(drawableDir2 = new File(widget.getDir() + SUFFIX + "/" + temp + "/drawable-mdpi")).exists() || !drawableDir2.isDirectory()) {
            drawableDir2.mkdirs();
        }
        if (!(drawableDir3 = new File(widget.getDir() + SUFFIX + "/" + temp + "/drawable-ldpi")).exists() || !drawableDir3.isDirectory()) {
            drawableDir3.mkdirs();
        }
        for (Map.Entry<String, String> entry : mPngs.entrySet()) {
            File file = new File(widget.getDir(), entry.getKey().toString());
            if (!file.exists() || !file.isFile()) continue;
            FileUtil.copyFile(new File(widget.getDir(), entry.getKey().toString()), new File(widget.getDir() + SUFFIX + "/" + temp + entry.getValue().toString()));
        }
        File file = new File(widget.getDir(), "widget_" + types + "_bkg.png");
        if (file.isFile() && file.exists()) {
            BufferedImage img = ImageIO.read(file);
            if (img.getWidth() >= 480 || img.getWidth() < 480 && img.getWidth() > 320 && Math.abs(img.getWidth() - 480) < Math.abs(img.getWidth() - 320)) {
                FileUtil.copyFile(file, new File(drawableDir.getPath() + "/widget_" + types + "_bkg.png"));
            } else if (Math.abs(img.getWidth() - 320) < Math.abs(img.getWidth() - 240)) {
                FileUtil.copyFile(file, new File(drawableDir2.getPath() + "/widget_" + types + "_bkg.png"));
            } else {
                FileUtil.copyFile(file, new File(drawableDir3.getPath() + "/widget_" + types + "_bkg.png"));
            }
        }
        File wDir = new File(widget.getDir());
        for (int i = 0; i < wDir.listFiles().length; ++i) {
            Pattern pattern3;
            Matcher matcher3;
            Pattern pattern2;
            Matcher matcher2;
            Pattern pattern = Pattern.compile("\\bw\\d\\.png\\b");
            Matcher matcher = pattern.matcher(wDir.listFiles()[i].getName());
            if (matcher.matches() || (matcher2 = (pattern2 = Pattern.compile("\\bw\\d\\d\\.png\\b")).matcher(wDir.listFiles()[i].getName())).matches() || (matcher3 = (pattern3 = Pattern.compile("\\bn\\d\\.png\\b")).matcher(wDir.listFiles()[i].getName())).matches() || !wDir.listFiles()[i].getName().endsWith(".png") || wDir.listFiles()[i].getName().equals("widget_4x2_bkg.png") || wDir.listFiles()[i].getName().equals("widget_4x1_bkg.png")) continue;
            FileUtil.copyFile(wDir.listFiles()[i], new File(drawableDir.getPath() + "/" + wDir.listFiles()[i].getName()));
        }
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("AppWidget");
        root.addAttribute("Name", widget.getName());
        root.addAttribute("Author", "\u5929\u6c14\u901a\u7f51\u53cb");
        root.addAttribute("Version", "1");
        root.addAttribute("Type", types);
        root.addAttribute("ButtonFrame", types.equals("4x2") ? "1" : "0");
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter xmlw = new XMLWriter(new FileOutputStream(widget.getDir() + SUFFIX + "/" + temp + "/cfg.xml"), format);
        xmlw.write(doc);
        xmlw.close();
    }

    private void addDefaultButton(Element root, int type) {
        int leng = 0;
        switch (type) {
            case 1: {
                leng = 32;
                break;
            }
            case 0: {
                leng = 70;
                break;
            }
            case 2: {
                leng = 24;
                break;
            }
            case 3: {
                leng = 40;
            }
        }
        for (int i = 0; i < leng; ++i) {
            Element defaultButton = root.addElement("Button");
            defaultButton.addAttribute("Idx", i + "");
            defaultButton.addAttribute("FunctionId", "app");
            defaultButton.addAttribute("PkgName", "sina.mobile.tianqitong");
            defaultButton.addAttribute("ActivityName", "sina.mobile.tianqitong.main.MainActivity");
        }
    }

    private void writeXML(DrawSetting setting, String file) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Layout");
        setting.setBgPictureFirst();
        for (int dp = 0; dp < setting.getDrawPicturesCount(); ++dp) {
            DrawPicture drawPicture = setting.getDrawPicture(dp);
            this.writePicture(setting, drawPicture, root);
        }
        for (int dt = 0; dt < setting.getDrawTextsCount(); ++dt) {
            DrawText drawText = setting.getDrawText(dt);
            this.writeText(setting, drawText, root);
        }
        this.addDefaultButton(root, setting.getWidgetType());
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter xmlw = new XMLWriter(new FileOutputStream(file), format);
            xmlw.write(doc);
            xmlw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writePicture(DrawSetting setting, DrawPicture drawPicture, Element root) {
        if (drawPicture.getType().equals("CT_TIME_HOUR_TENS")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "clock_hd");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_TIME_HOUR_UNITS")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "clock_hu");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_TIME_COLON")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("Src", "colon_b.png");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_TIME_MINUTE_TENS")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "clock_md");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_TIME_MINUTE_UNITS")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "clock_mu");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_WEATHER_ICON_CURRENT")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "c_weather_icon");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_WEATHER_ICON_FORECAST_DAY_2")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "day_weather_icon");
            imageE.addAttribute("OffsetTime", "+1d");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_WEATHER_ICON_FORECAST_DAY_3")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "day_weather_icon");
            imageE.addAttribute("OffsetTime", "+2d");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_WEATHER_ICON_FORECAST_DAY_4")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "day_weather_icon");
            imageE.addAttribute("OffsetTime", "+3d");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_WEATHER_ICON_FORECAST_DAY_5")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("FunctionId", "day_weather_icon");
            imageE.addAttribute("OffsetTime", "+4d");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        } else if (drawPicture.getType().equals("CT_BACKGROUND")) {
            Element imageE = root.addElement("Image");
            imageE.addAttribute("LayoutId", "Image" + setting.getDrawPictureIndex(drawPicture) + 0);
            imageE.addAttribute("Src", setting.getWidgetType() == 1 ? "widget_4x1_bkg.png" : "widget_4x2_bkg.png");
            imageE.addAttribute("x", "" + drawPicture.getX());
            imageE.addAttribute("y", "" + drawPicture.getY());
        }
    }

    private void writeText(DrawSetting setting, DrawText drawText, Element root) {
        String[] values = this.analyzeTextKey(drawText.getTextKey());
        if (values.length == 1) {
            if (values[0].equals("$date_short_type1")) {
                this.writeTextArea(setting, drawText, root);
            } else if (values[0].equals("$date_short_type2")) {
                this.writeTextArea(setting, drawText, root);
            } else if (values[0].equals("$date_short_type3")) {
                this.writeTextArea(setting, drawText, root);
            } else if (values[0].equals("$date_nl")) {
                this.writeTextArea(setting, drawText, root);
            } else {
                this.writeSingleText(setting, drawText, root);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            Element textE = root.addElement("TextArea");
            for (int i = 0; i < values.length; ++i) {
                String s = values[i];
                if (!mKeys.containsKey(s)) {
                    sb.append(s);
                    continue;
                }
                if (s.equals("$date_short_type1")) {
                    sb.append(mKeys.get(s));
                    continue;
                }
                if (s.equals("$date_short_type2")) {
                    sb.append(mKeys.get(s));
                    continue;
                }
                if (s.equals("$date_short_type3")) {
                    sb.append(mKeys.get(s));
                    continue;
                }
                if (s.equals("$date_nl")) {
                    sb.append(mKeys.get(s));
                    continue;
                }
                if (mKeys.get(s).equals("")) continue;
                sb.append("{");
                if (s.equals("$w_fd2_night_desp")) {
                    sb.append(mKeys.get(s)).append(":+1d");
                } else if (s.equals("$w_fd3_night_desp")) {
                    sb.append(mKeys.get(s)).append(":+2d");
                } else if (s.equals("$w_fd4_night_desp")) {
                    sb.append(mKeys.get(s)).append(":+3d");
                } else if (s.equals("$w_fd5_night_desp")) {
                    sb.append(mKeys.get(s)).append(":+4d");
                } else if (s.equals("$w_fd2_night_temp")) {
                    sb.append(mKeys.get(s)).append(":+1d");
                } else if (s.equals("$w_fd3_night_temp")) {
                    sb.append(mKeys.get(s)).append(":+2d");
                } else if (s.equals("$w_fd4_night_temp")) {
                    sb.append(mKeys.get(s)).append(":+3d");
                } else if (s.equals("$w_fd5_night_temp")) {
                    sb.append(mKeys.get(s)).append(":+4d");
                } else if (s.equals("$w_fd2_day_temp")) {
                    sb.append(mKeys.get(s)).append(":+1d");
                } else if (s.equals("$w_fd3_day_temp")) {
                    sb.append(mKeys.get(s)).append(":+2d");
                } else if (s.equals("$w_fd4_day_temp")) {
                    sb.append(mKeys.get(s)).append(":+3d");
                } else if (s.equals("$w_fd5_day_temp")) {
                    sb.append(mKeys.get(s)).append(":+4d");
                } else if (s.equals("$w_fd2_day_desp")) {
                    sb.append(mKeys.get(s)).append(":+1d");
                } else if (s.equals("$w_fd3_day_desp")) {
                    sb.append(mKeys.get(s)).append(":+2d");
                } else if (s.equals("$w_fd4_day_desp")) {
                    sb.append(mKeys.get(s)).append(":+3d");
                } else if (s.equals("$w_fd5_day_desp")) {
                    sb.append(mKeys.get(s)).append(":+4d");
                } else {
                    sb.append(mKeys.get(s));
                }
                sb.append("}");
            }
            textE.addAttribute("LayoutId", "TextArea" + setting.getDrawTextIndex(drawText) + 0);
            textE.addAttribute("x", "" + drawText.getX());
            textE.addAttribute("y", "" + drawText.getY());
            if (drawText.getAlign().equals("left")) {
                textE.addAttribute("DatumPoint", "left|top");
            } else if (drawText.getAlign().equals("center")) {
                textE.addAttribute("DatumPoint", "hcenter|top");
            } else if (drawText.getAlign().equals("right")) {
                textE.addAttribute("DatumPoint", "right|top");
            }
            textE.addAttribute("Text", sb.toString());
            this.writeTextProperties(drawText, textE);
        }
    }

    private void writeSingleText(DrawSetting setting, DrawText drawText, Element root) {
        Element textE = root.addElement("Text");
        textE.addAttribute("LayoutId", "Text" + setting.getDrawTextIndex(drawText) + 0);
        textE.addAttribute("x", "" + drawText.getX());
        textE.addAttribute("y", "" + drawText.getY());
        if (drawText.getAlign().equals("left")) {
            textE.addAttribute("DatumPoint", "left|top");
        } else if (drawText.getAlign().equals("center")) {
            textE.addAttribute("DatumPoint", "hcenter|top");
        } else if (drawText.getAlign().equals("right")) {
            textE.addAttribute("DatumPoint", "right|top");
        }
        if (!mKeys.containsKey(drawText.getTextKey())) {
            textE.addAttribute("Text", drawText.getTextKey());
        } else {
            textE.addAttribute("FunctionId", mKeys.get(drawText.getTextKey()));
        }
        this.writeTextProperties(drawText, textE);
    }

    private void writeTextArea(DrawSetting setting, DrawText drawText, Element root) {
        Element textE = root.addElement("TextArea");
        textE.addAttribute("LayoutId", "TextArea" + setting.getDrawTextIndex(drawText) + 0);
        textE.addAttribute("x", "" + drawText.getX());
        textE.addAttribute("y", "" + drawText.getY());
        if (drawText.getAlign().equals("left")) {
            textE.addAttribute("DatumPoint", "left|top");
        } else if (drawText.getAlign().equals("center")) {
            textE.addAttribute("DatumPoint", "hcenter|top");
        } else if (drawText.getAlign().equals("right")) {
            textE.addAttribute("DatumPoint", "right|top");
        }
        if (!mKeys.containsKey(drawText.getTextKey())) {
            textE.addAttribute("Text", drawText.getTextKey());
        } else {
            textE.addAttribute("Text", mKeys.get(drawText.getTextKey()));
        }
        this.writeTextProperties(drawText, textE);
    }

    private void writeTextProperties(DrawText drawText, Element textE) {
        if (drawText.isUseShadow()) {
            textE.addAttribute("HasShadow", "true");
            textE.addAttribute("Shadow_pos_x", "" + drawText.getShadowOffsetX());
            textE.addAttribute("Shadow_pos_y", "" + drawText.getShadowOffsetY());
            if (drawText.getShadowColor().equals("0")) {
                textE.addAttribute("Shadow_color", "ff000000");
            } else if (drawText.getShadowColor().length() == 4) {
                textE.addAttribute("Shadow_color", "ff00" + drawText.getShadowColor());
            } else if (drawText.getShadowColor().length() == 6) {
                textE.addAttribute("Shadow_color", "ff" + drawText.getShadowColor());
            } else {
                textE.addAttribute("Shadow_color", "ff000000");
            }
        }
        textE.addAttribute("TextSize", "" + drawText.getSize());
        if (drawText.getColor().equals("0")) {
            textE.addAttribute("TextColor", "ff000000");
        } else if (drawText.getColor().length() == 4) {
            textE.addAttribute("TextColor", "ff00" + drawText.getColor());
        } else if (drawText.getColor().length() == 6) {
            textE.addAttribute("TextColor", "ff" + drawText.getColor());
        } else {
            textE.addAttribute("TextColor", "ff000000");
        }
    }

    public String[] analyzeTextKey(String textKey) {
        ArrayList<String> strings = new ArrayList<String>();
        String[] splits = textKey.split("\\$");
        for (int i = 0; i < splits.length; ++i) {
            String split = splits[i];
            boolean find = false;
            for (int j = 0; j < TEXT_KEYS.length; ++j) {
                if (!split.startsWith(TEXT_KEYS[j])) continue;
                find = true;
                strings.add("$" + TEXT_KEYS[j]);
                if (split.split(TEXT_KEYS[j]).length <= 1) break;
                strings.add(split.split(TEXT_KEYS[j])[1]);
                break;
            }
            if (find || split.equals("")) continue;
            strings.add(split);
        }
        return strings.toArray(new String[strings.size()]);
    }

    static {
        mWidths.put("$w_fd1_night_desp", "\u96f7\u9635\u96e8");
        mWidths.put("$w_fd2_night_desp", "\u96f7\u9635\u96e8");
        mWidths.put("$w_fd3_night_desp", "\u96f7\u9635\u96e8");
        mWidths.put("$w_fd4_night_desp", "\u96f7\u9635\u96e8");
        mWidths.put("$w_fd5_night_desp", "\u96f7\u9635\u96e8");
        mWidths.put("$w_fd1_day_desp", "\u591a\u4e91");
        mWidths.put("$w_fd2_day_desp", "\u591a\u4e91");
        mWidths.put("$w_fd3_day_desp", "\u591a\u4e91");
        mWidths.put("$w_fd4_day_desp", "\u591a\u4e91");
        mWidths.put("$w_fd5_day_desp", "\u591a\u4e91");
        mWidths.put("$w_fd1_night_temp", "19");
        mWidths.put("$w_fd2_night_temp", "19");
        mWidths.put("$w_fd3_night_temp", "19");
        mWidths.put("$w_fd4_night_temp", "19");
        mWidths.put("$w_fd5_night_temp", "19");
        mWidths.put("$w_fd1_day_temp", "19");
        mWidths.put("$w_fd2_day_temp", "19");
        mWidths.put("$w_fd3_day_temp", "19");
        mWidths.put("$w_fd4_day_temp", "19");
        mWidths.put("$w_fd5_day_temp", "19");
        mWidths.put("$w_cd_temp_type1", "8");
        mWidths.put("$date_short_type1", "10\u670810\u65e5");
        mWidths.put("$date_short_type2", "09-06");
        mWidths.put("$date_short_type3", "08/13");
        mWidths.put("$date_nl", "\u4e8c\u6708\u5eff\u4e03");
        mWidths.put("$date_jq", "");
        mWidths.put("$w_fd2_week", "\u5468\u4e8c");
        mWidths.put("$w_fd3_week", "\u5468\u4e09");
        mWidths.put("$w_fd4_week", "\u5468\u56db");
        mWidths.put("$w_fd5_week", "\u5468\u4e94");
        mWidths.put("$week", "\u5468\u4e00");
        mWidths.put("$w_cd_desp", "\u591a\u4e91");
        mWidths.put("$w_cd_uv", "\u5f3a");
        mWidths.put("$w_cd_Humidity", "88");
        mWidths.put("$w_cd_wind", "\u897f\u5317\u98ce3\u7ea7");
        mWidths.put("$w_cd_time", "2012-07-17 00:00");
        mWidths.put("$w_cd_update_time", "");
        mWidths.put("$city_name", "\u5317\u4eac");
        mWidths.put("$aqi_quality_desp_type1", "\u826f");
        mKeys.put("$aqi_quality_desp_type1", "Api_qulity");
        mKeys.put("$w_cd_temp_type1", "temperature");
        mKeys.put("$date_short_type1", "{mm}\u6708{dd}\u65e5");
        mKeys.put("$date_short_type2", "{mm}-{dd}");
        mKeys.put("$date_short_type3", "{mm}/{dd}");
        mKeys.put("$date_nl", "{chn_m}{chn_d}");
        mKeys.put("$week", "w1");
        mKeys.put("$w_cd_desp", "c_weather");
        mKeys.put("$w_cd_uv", "uv");
        mKeys.put("$w_cd_Humidity", "humidity");
        mKeys.put("$w_cd_wind", "wind");
        mKeys.put("$city_name", "city_name");
        mKeys.put("$w_fd1_day_desp", "day_weather");
        mKeys.put("$w_fd2_day_desp", "day_weather");
        mKeys.put("$w_fd3_day_desp", "day_weather");
        mKeys.put("$w_fd4_day_desp", "day_weather");
        mKeys.put("$w_fd5_day_desp", "day_weather");
        mKeys.put("$w_fd1_night_desp", "night_weather");
        mKeys.put("$w_fd2_night_desp", "night_weather");
        mKeys.put("$w_fd3_night_desp", "night_weather");
        mKeys.put("$w_fd4_night_desp", "night_weather");
        mKeys.put("$w_fd5_night_desp", "night_weather");
        mKeys.put("$w_fd1_night_temp", "ltemperature");
        mKeys.put("$w_fd2_night_temp", "ltemperature");
        mKeys.put("$w_fd3_night_temp", "ltemperature");
        mKeys.put("$w_fd4_night_temp", "ltemperature");
        mKeys.put("$w_fd5_night_temp", "ltemperature");
        mKeys.put("$w_fd1_day_temp", "htemperature");
        mKeys.put("$w_fd2_day_temp", "htemperature");
        mKeys.put("$w_fd3_day_temp", "htemperature");
        mKeys.put("$w_fd4_day_temp", "htemperature");
        mKeys.put("$w_fd5_day_temp", "htemperature");
        mKeys.put("$date_jq", "chn_solar_term");
        mKeys.put("$w_cd_time", "pub_time_brief");
        mKeys.put("$w_cd_update_time", "");
        mPngs.put("preview.jpg", "/icon.png");
        mPngs.put("w0.png", "/drawable-hdpi/wi_01.png");
        mPngs.put("w18.png", "/drawable-hdpi/wi_02.png");
        mPngs.put("w1.png", "/drawable-hdpi/wi_03.png");
        mPngs.put("w2.png", "/drawable-hdpi/wi_04.png");
        mPngs.put("w29.png", "/drawable-hdpi/wi_05.png");
        mPngs.put("w20.png", "/drawable-hdpi/wi_06.png");
        mPngs.put("w9.png", "/drawable-hdpi/wi_07.png");
        mPngs.put("w8.png", "/drawable-hdpi/wi_08.png");
        mPngs.put("w7.png", "/drawable-hdpi/wi_09.png");
        mPngs.put("w4.png", "/drawable-hdpi/wi_10.png");
        mPngs.put("w14.png", "/drawable-hdpi/wi_11.png");
        mPngs.put("w16.png", "/drawable-hdpi/wi_12.png");
        mPngs.put("w6.png", "/drawable-hdpi/wi_13.png");
        mPngs.put("w5.png", "/drawable-hdpi/wi_14.png");
        mPngs.put("w30.png", "/drawable-hdpi/wi_15.png");
        mPngs.put("w32.png", "/drawable-hdpi/wi_16.png");
        mPngs.put("w21.png", "/drawable-hdpi/wi_17.png");
        mPngs.put("n0.png", "/drawable-hdpi/clock_0.png");
        mPngs.put("n1.png", "/drawable-hdpi/clock_1.png");
        mPngs.put("n2.png", "/drawable-hdpi/clock_2.png");
        mPngs.put("n3.png", "/drawable-hdpi/clock_3.png");
        mPngs.put("n4.png", "/drawable-hdpi/clock_4.png");
        mPngs.put("n5.png", "/drawable-hdpi/clock_5.png");
        mPngs.put("n6.png", "/drawable-hdpi/clock_6.png");
        mPngs.put("n7.png", "/drawable-hdpi/clock_7.png");
        mPngs.put("n8.png", "/drawable-hdpi/clock_8.png");
        mPngs.put("n9.png", "/drawable-hdpi/clock_9.png");
    }
}

