/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.skin.go;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import sina.mobile.tianqitong.skin.go.GoWidgetImage;
import sina.mobile.tianqitong.skin.go.GoWidgetText;
import sina.mobile.tianqitong.skin.go.ICallBack;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.Log;
import sina.mobile.tianqitong.util.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoWidget2TQT
implements ICallBack {
    private HashMap<String, String> mNodeMap = new HashMap();
    private String mSkinTempPath;
    private String mSkinName;
    private String mPkgName;
    private boolean mFlag1 = false;
    private boolean mFlag2 = false;
    private boolean mFlag3 = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HashMap<String, Boolean> map) {
        if (map.containsKey("LayoutPort")) {
            this.mFlag1 = map.get("LayoutPort");
        } else if (map.containsKey("LayoutLand")) {
            this.mFlag2 = map.get("LayoutLand");
        } else if (map.containsKey("Drawable")) {
            this.mFlag3 = map.get("Drawable");
        }
        if (this.mFlag1 && this.mFlag2 && this.mFlag3) {
            this.mPkgName = "temp" + File.separator + this.mSkinName + ".zip";
            ZipUtil.compress(this.mSkinTempPath, this.mPkgName, new String[0]);
            GoWidget2TQT goWidget2TQT = this;
            synchronized (goWidget2TQT) {
                this.notify();
            }
        }
    }

    public String decompileGoWidjetApk(File srcFile) {
        try {
            Properties properties = System.getProperties();
            String currentDir = properties.getProperty("user.dir") + File.separator;
            File tempDir = new File(currentDir + File.separator + "temp");
            if (!tempDir.exists() || !tempDir.isDirectory()) {
                tempDir.mkdirs();
            }
            String name = "temp";
            int count = 1;
            File newFile = new File(tempDir.getPath() + File.separator + name + ".apk");
            String newName = name;
            while (newFile.exists()) {
                newName = name + count++;
                newFile = new File(tempDir.getPath() + File.separator + newName + ".apk");
            }
            try {
                FileUtil.copyFile(srcFile, newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String toolPath = currentDir + "tool" + File.separator + "apktool.bat";
            String tempPath = tempDir.getPath() + File.separator + newName;
            String[] cmds = new String[]{toolPath, "d", newFile.getPath(), tempPath};
            Process process = Runtime.getRuntime().exec(cmds);
            if (0 == process.waitFor()) {
                // empty if block
            }
            return newName;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return FileUtil.getNameWithoutExten(srcFile);
    }

    public File transformSkin(String skinName, String type, String tempDir) {
        this.mSkinName = skinName;
        String path = "temp" + File.separator + tempDir + File.separator + "res" + File.separator;
        this.mSkinTempPath = this.createTempDir(path, tempDir);
        boolean result = this.createLayoutXml(path, type, this.mSkinTempPath);
        boolean result1 = this.createDrawableDir(path + File.separator + "drawable-hdpi" + File.separator, this.mSkinTempPath);
        if (result && result1) {
            this.createCfg(skinName, type, this.mSkinTempPath);
        }
        this.createLandLayout(this.mSkinTempPath, type, "layout-land-hdpi.xml");
        this.mPkgName = "temp" + File.separator + this.mSkinName + ".zip";
        ZipUtil.compress(this.mSkinTempPath, this.mPkgName, new String[0]);
        return new File(this.mPkgName);
    }

    private void parseElements(Element element, Element newRoot) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element el = (Element)iterator.next();
            String typeName = el.getName();
            if ("RelativeLayout".equals(typeName)) {
                this.parseElements(el, newRoot);
                continue;
            }
            if ("ImageView".equals(typeName)) {
                this.parseAttribute(el, newRoot);
                continue;
            }
            if (!"TextView".equals(typeName)) continue;
            this.parseAttribute(el, newRoot);
        }
    }

    private void parseAttribute(Element element, Element root) {
        Iterator iterator = element.attributeIterator();
        if ("ImageView".equals(element.getName())) {
            Element newElement = root.addElement("Image");
            this.tansformGo2TQT(iterator, newElement, root);
        } else if ("TextView".equals(element.getName())) {
            String id = this.getIdString(element.attributeValue("id"));
            Element newElement = GoWidgetText.DATE.equals(id) || GoWidgetText.DATE_NL.equals(id) || GoWidgetText.HIGH_TEMP.equals(id) || GoWidgetText.WEATHER_NOW_TEMP.equals(id) || GoWidgetText.WEATHER_NOW_TEMP_M.equals(id) ? root.addElement("TextArea") : root.addElement("Text");
            this.tansformGo2TQT(iterator, newElement, root);
        } else if ("RelativeLayout".equals(element.getName())) {
            // empty if block
        }
    }

    private void tansformGo2TQT(Iterator iterator, Element newElement, Element root) {
        String hPoint = null;
        String vPoint = null;
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String attributeName = attribute.getName();
            String attributeValue = attribute.getValue();
            if ("id".equals(attributeName)) {
                if (attributeValue.contains(GoWidgetImage.BACKGROUND)) {
                    newElement.addAttribute("LayoutId", "bg");
                    this.mNodeMap.put(this.getIdString(attributeValue), "bg");
                    newElement.addAttribute("DatumHLine", "hcenter");
                    newElement.addAttribute("DatumVLine", "vcenter");
                    newElement.addAttribute("DatumPoint", "hcenter|vcenter");
                    newElement.addAttribute("Src", "bg.png");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.BACKGROUND_M)) {
                    newElement.addAttribute("LayoutId", "bg");
                    this.mNodeMap.put(this.getIdString(attributeValue), "bg");
                    newElement.addAttribute("DatumHLine", "hcenter");
                    newElement.addAttribute("DatumVLine", "vcenter");
                    newElement.addAttribute("DatumPoint", "hcenter|vcenter");
                    newElement.addAttribute("Src", "widget_m_bg.png");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.WEATHER_ICON) || attributeValue.contains(GoWidgetImage.WEATHER_ICON_M)) {
                    newElement.addAttribute("FunctionId", "c_weather_icon");
                    newElement.addAttribute("LayoutId", "c_weather_icon");
                    this.mNodeMap.put(this.getIdString(attributeValue), "c_weather_icon");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "live_weather_icon");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.WEATHER_AM_PM)) {
                    newElement.addAttribute("FunctionId", "clock_ampm");
                    newElement.addAttribute("LayoutId", "clock_ampm");
                    this.mNodeMap.put(this.getIdString(attributeValue), "clock_ampm");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "clock_ampm");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_BG)) {
                    newElement.addAttribute("LayoutId", "timeboard");
                    this.mNodeMap.put(this.getIdString(attributeValue), "timeboard");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_DOT)) {
                    newElement.addAttribute("LayoutId", "timedot");
                    this.mNodeMap.put(this.getIdString(attributeValue), "timedot");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_NUM_1)) {
                    newElement.addAttribute("FunctionId", "clock_hd");
                    newElement.addAttribute("LayoutId", "clock_hd");
                    this.mNodeMap.put(this.getIdString(attributeValue), "clock_hd");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "clock_hd");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_NUM_2)) {
                    newElement.addAttribute("FunctionId", "clock_hu");
                    newElement.addAttribute("LayoutId", "clock_hu");
                    this.mNodeMap.put(this.getIdString(attributeValue), "clock_hu");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "clock_hu");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_NUM_3)) {
                    newElement.addAttribute("FunctionId", "clock_md");
                    newElement.addAttribute("LayoutId", "clock_md");
                    this.mNodeMap.put(this.getIdString(attributeValue), "clock_md");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "clock_md");
                    continue;
                }
                if (attributeValue.contains(GoWidgetImage.TIME_NUM_4)) {
                    newElement.addAttribute("FunctionId", "clock_mu");
                    newElement.addAttribute("LayoutId", "clock_mu");
                    this.mNodeMap.put(this.getIdString(attributeValue), "clock_mu");
                    newElement.addAttribute("DatumHLine", "left");
                    newElement.addAttribute("DatumVLine", "top");
                    newElement.addAttribute("DatumPoint", "left|top");
                    newElement.addAttribute("Prefix", "clock_mu");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.CITY) || attributeValue.contains(GoWidgetText.CITY_M)) {
                    newElement.addAttribute("FunctionId", "city_name");
                    newElement.addAttribute("LayoutId", "city_name");
                    this.mNodeMap.put(this.getIdString(attributeValue), "city_name");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.DATE)) {
                    newElement.addAttribute("Text", "{yyyy}-{mm}-{dd}");
                    newElement.addAttribute("LayoutId", "widget_date");
                    this.mNodeMap.put(this.getIdString(attributeValue), "widget_date");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.DATE_NL)) {
                    newElement.addAttribute("Text", "{chn_m}{chn_d}");
                    newElement.addAttribute("LayoutId", "widget_nl_date");
                    this.mNodeMap.put(this.getIdString(attributeValue), "widget_nl_date");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.HIGH_LOW_SEP)) {
                    root.remove(newElement);
                    return;
                }
                if (attributeValue.contains(GoWidgetText.HIGH_TEMP)) {
                    newElement.addAttribute("Text", "{hltemperature}\u2103");
                    newElement.addAttribute("LayoutId", "hltemperature");
                    this.mNodeMap.put(this.getIdString(attributeValue), "hltemperature");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.LOW_TEMP)) {
                    root.remove(newElement);
                    return;
                }
                if (attributeValue.contains(GoWidgetText.WEATHER)) {
                    newElement.addAttribute("FunctionId", "c_weather");
                    newElement.addAttribute("LayoutId", "c_weather");
                    this.mNodeMap.put(this.getIdString(attributeValue), "c_weather");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.WEATHER_NOW_TEMP) || attributeValue.contains(GoWidgetText.WEATHER_NOW_TEMP_M)) {
                    newElement.addAttribute("Text", "{temperature}\u2103");
                    newElement.addAttribute("LayoutId", "temperature");
                    this.mNodeMap.put(this.getIdString(attributeValue), "temperature");
                    continue;
                }
                if (attributeValue.contains(GoWidgetText.WEEK)) {
                    newElement.addAttribute("FunctionId", "w1");
                    newElement.addAttribute("LayoutId", "w1");
                    this.mNodeMap.put(this.getIdString(attributeValue), "w1");
                    continue;
                }
                root.remove(newElement);
                return;
            }
            if ("layout_width".equals(attributeName)) {
                if ("fill_parent".equals(attributeValue) || "wrap_content".equals(attributeValue) || "match_parent".equals(attributeValue)) continue;
                newElement.addAttribute("w", attributeValue.substring(0, attributeValue.lastIndexOf(".")));
                continue;
            }
            if ("layout_height".equals(attributeName)) {
                if ("fill_parent".equals(attributeValue) || "wrap_content".equals(attributeValue) || "match_parent".equals(attributeValue)) continue;
                newElement.addAttribute("h", attributeValue.substring(0, attributeValue.lastIndexOf(".")));
                continue;
            }
            if ("layout_centerHorizontal".equals(attributeName)) {
                if (!Boolean.parseBoolean(attributeValue)) continue;
                newElement.addAttribute("DatumHLine", "hcenter");
                continue;
            }
            if ("layout_centerVertical".equals(attributeName)) {
                if (!Boolean.parseBoolean(attributeValue)) continue;
                newElement.addAttribute("DatumVLine", "vcenter");
                continue;
            }
            if (attributeName.contains("layout_alignParent")) {
                if ("layout_alignParentBottom".equals(attributeName)) {
                    if (!Boolean.parseBoolean(attributeValue)) continue;
                    vPoint = "bottom";
                    continue;
                }
                if ("layout_alignParentLeft".equals(attributeName)) {
                    if (!Boolean.parseBoolean(attributeValue)) continue;
                    hPoint = "left";
                    continue;
                }
                if ("layout_alignParentTop".equals(attributeName)) {
                    if (!Boolean.parseBoolean(attributeValue)) continue;
                    vPoint = "top";
                    continue;
                }
                if (!"layout_alignParentRight".equals(attributeName) || !Boolean.parseBoolean(attributeValue)) continue;
                hPoint = "right";
                continue;
            }
            if ("layout_marginBottom".equals(attributeName)) {
                newElement.addAttribute("OffsetY", this.parseInt(attributeValue));
                newElement.addAttribute("DatumVLine", "bottom");
                newElement.addAttribute("DatumPoint", "left|bottom");
                vPoint = "bottom";
                continue;
            }
            if ("layout_marginLeft".equals(attributeName)) {
                newElement.addAttribute("OffsetX", attributeValue.substring(0, attributeValue.lastIndexOf(".")));
                newElement.addAttribute("DatumHLine", "left");
                newElement.addAttribute("DatumPoint", "left|top");
                hPoint = "left";
                continue;
            }
            if ("layout_marginRight".equals(attributeName)) {
                newElement.addAttribute("OffsetX", this.parseInt(attributeValue));
                newElement.addAttribute("DatumHLine", "right");
                newElement.addAttribute("DatumPoint", "right|top");
                hPoint = "right";
                continue;
            }
            if ("layout_marginTop".equals(attributeName)) {
                newElement.addAttribute("OffsetY", attributeValue.substring(0, attributeValue.lastIndexOf(".")));
                newElement.addAttribute("DatumVLine", "top");
                newElement.addAttribute("DatumPoint", "left|top");
                vPoint = "top";
                continue;
            }
            if (attributeName.contains("layout_to")) {
                if ("layout_toLeftOf".equals(attributeName)) {
                    if (this.mNodeMap.isEmpty() || !this.mNodeMap.containsKey(this.getIdString(attributeValue))) continue;
                    newElement.addAttribute("DatumHLineLayoutId", this.mNodeMap.get(this.getIdString(attributeValue)));
                    newElement.addAttribute("DatumHLine", "left");
                    hPoint = "right";
                    continue;
                }
                if ("layout_toTopOf".equals(attributeName)) {
                    if (this.mNodeMap.isEmpty() || !this.mNodeMap.containsKey(this.getIdString(attributeValue))) continue;
                    newElement.addAttribute("DatumVLineLayoutId", this.mNodeMap.get(this.getIdString(attributeValue)));
                    newElement.addAttribute("DatumVLine", "top");
                    vPoint = "top";
                    continue;
                }
                if ("layout_toRightOf".equals(attributeName)) {
                    if (this.mNodeMap.isEmpty() || !this.mNodeMap.containsKey(this.getIdString(attributeValue))) continue;
                    if (attributeValue.contains(GoWidgetText.DATE)) {
                        newElement.addAttribute("DatumHLineLayoutId", "dd");
                        newElement.addAttribute("DatumHLine", "right");
                    } else if (attributeValue.contains(GoWidgetText.DATE_NL)) {
                        newElement.addAttribute("DatumHLineLayoutId", "chn_d");
                        newElement.addAttribute("DatumHLine", "right");
                    } else if (attributeValue.contains(GoWidgetText.HIGH_TEMP)) {
                        newElement.addAttribute("DatumHLineLayoutId", newElement.attributeValue("LayoutId") + "_degree");
                        newElement.addAttribute("DatumHLine", "right");
                    } else {
                        newElement.addAttribute("DatumHLineLayoutId", this.mNodeMap.get(this.getIdString(attributeValue)));
                        newElement.addAttribute("DatumHLine", "right");
                    }
                    hPoint = "left";
                    continue;
                }
                if (!"layout_toBottomOf".equals(attributeName) || this.mNodeMap.isEmpty() || !this.mNodeMap.containsKey(this.getIdString(attributeValue))) continue;
                newElement.addAttribute("DatumVLineLayoutId", this.mNodeMap.get(this.getIdString(attributeValue)));
                newElement.addAttribute("DatumVLine", "bottom");
                vPoint = "bottom";
                continue;
            }
            if ("src".equals(attributeName)) {
                newElement.addAttribute("Src", this.getIdString(attributeValue) + ".png");
                continue;
            }
            if ("visibility".equals(attributeName)) {
                if (!"invisible".equals(attributeValue) && !"gone".equals(attributeValue)) continue;
                root.remove(newElement);
                return;
            }
            if ("textColor".equals(attributeName)) {
                newElement.addAttribute("TextColor", attributeValue.substring(1, attributeValue.length()));
                continue;
            }
            if (!"textSize".equals(attributeName)) continue;
            newElement.addAttribute("TextSize", attributeValue.substring(0, attributeValue.lastIndexOf(".")));
        }
        this.adapterAttribute(hPoint, vPoint, newElement);
    }

    private void adapterAttribute(String hPoint, String vPoint, Element newElement) {
        if (null != hPoint && null != vPoint) {
            newElement.addAttribute("DatumPoint", hPoint + "|" + vPoint);
        } else if (null == hPoint && null != vPoint) {
            newElement.addAttribute("DatumPoint", "left|" + vPoint);
        } else if (null != hPoint && null == vPoint) {
            newElement.addAttribute("DatumPoint", hPoint + "|top");
        }
    }

    private void createCfg(String skinName, String type, String path) {
        try {
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("AppWidget");
            root.addAttribute("Name", skinName);
            root.addAttribute("Author", "\u5929\u6c14\u901a\u7f51\u53cb");
            root.addAttribute("Version", "1");
            root.addAttribute("Type", type);
            root.addAttribute("ButtonFrame", "4x2".equals(type) ? "1" : "0");
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter xmlw = new XMLWriter(new FileOutputStream(path + "/cfg.xml"), format);
            xmlw.write(doc);
            xmlw.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void addDefaultButton(Element root, String type) {
        int leng = "4x2".equals(type) ? 70 : 32;
        for (int i = 0; i < leng; ++i) {
            Element defaultButton = root.addElement("Button");
            defaultButton.addAttribute("Idx", i + "");
            defaultButton.addAttribute("FunctionId", "app");
            defaultButton.addAttribute("PkgName", "sina.mobile.tianqitong");
            defaultButton.addAttribute("ActivityName", "sina.mobile.tianqitong.main.MainActivity");
        }
    }

    private boolean createLayoutXml(String path, String type, String skinTempPath) {
        try {
            String srcFile = "4x2".equals(type) ? "appwidget_provider_trans.xml" : "appwidget_m_provider_trans.xml";
            File layoutFile = new File(path + "layout-hdpi" + File.separator + srcFile);
            FileInputStream inputStream = new FileInputStream(layoutFile);
            byte[] bytes = this.inputstream2Byte(inputStream);
            String xmlString = new String(bytes);
            Document document = DocumentHelper.parseText(xmlString);
            Element element = document.getRootElement();
            Document doc = DocumentHelper.createDocument();
            Element newRoot = doc.addElement("Layout");
            this.parseElements(element, newRoot);
            this.addDefaultButton(newRoot, type);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            try {
                XMLWriter xmlWriter = new XMLWriter(new FileOutputStream(skinTempPath + "layout-port-hdpi.xml"), format);
                xmlWriter.write(doc);
                xmlWriter.close();
            }
            catch (Exception e) {
                Log.error(e);
            }
            return true;
        }
        catch (DocumentException ex) {
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return false;
    }

    private void createLandLayout(String path, String type, String fileName) {
        try {
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("Layout");
            Element text = root.addElement("Text");
            text.addAttribute("DatumHLine", "hcenter");
            text.addAttribute("DatumVLine", "vcenter");
            text.addAttribute("DatumPoint", "hcenter|vcenter");
            text.addAttribute("Text", "\u5929\u6c14\u901a\u731c\u6d4b\uff0c\u4f60\u7684\u624b\u673a\u662f\u6a2a\u7740\u4e86\uff0c\u62ff\u6b63\u4e86\u5c31\u80fd\u770b\u5230\u4e86");
            text.addAttribute("TextColor", "ffffffff");
            text.addAttribute("TextSize", "14");
            this.addDefaultButton(root, type);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter xmlw = new XMLWriter(new FileOutputStream(path + fileName), format);
            xmlw.write(doc);
            xmlw.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private boolean createDrawableDir(String srcPath, String dstPath) {
        try {
            File[] weatherIcons;
            File[] files;
            String newPath = dstPath + "drawable-port-hdpi" + File.separator;
            String newPath1 = dstPath + "drawable-land-hdpi" + File.separator;
            File newDir = new File(newPath);
            File newDir1 = new File(newPath1);
            if (!newDir1.exists() || !newDir1.isDirectory()) {
                newDir1.mkdirs();
            }
            if (!newDir.exists() || !newDir.isDirectory()) {
                newDir.mkdirs();
            }
            File dir = new File(srcPath);
            for (File file : files = dir.listFiles()) {
                if (file.getName().contains("widget_l_bg")) {
                    FileUtil.copyFile(file, new File(newPath + "bg.png"));
                    FileUtil.copyFile(file, new File(newPath1 + "bg.png"));
                    continue;
                }
                if (file.getName().contains("widget_num")) {
                    String name = FileUtil.getNameWithoutExten(file);
                    int num = Integer.parseInt(name.substring(name.lastIndexOf("_") + 1, name.length()));
                    switch (num) {
                        case 0: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hd_0.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_0.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_0.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_0.png"));
                            break;
                        }
                        case 1: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hd_1.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_1.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_1.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_1.png"));
                            break;
                        }
                        case 2: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hd_2.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_2.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_2.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_2.png"));
                            break;
                        }
                        case 3: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_3.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_3.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_3.png"));
                            break;
                        }
                        case 4: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_4.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_4.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_4.png"));
                            break;
                        }
                        case 5: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_5.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_md_5.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_5.png"));
                            break;
                        }
                        case 6: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_6.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_6.png"));
                            break;
                        }
                        case 7: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_7.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_7.png"));
                            break;
                        }
                        case 8: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_8.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_8.png"));
                            break;
                        }
                        case 9: {
                            FileUtil.copyFile(file, new File(newPath + "clock_hu_9.png"));
                            FileUtil.copyFile(file, new File(newPath + "clock_mu_9.png"));
                        }
                    }
                    continue;
                }
                if (file.getName().contains("wwam")) {
                    FileUtil.copyFile(file, new File(newPath + "clock_ampm_am.png"));
                    continue;
                }
                if (file.getName().contains("wwpm")) {
                    FileUtil.copyFile(file, new File(newPath + "clock_ampm_pm.png"));
                    continue;
                }
                FileUtil.copyFile(file, new File(newPath + file.getName()));
            }
            for (File icon : weatherIcons = new File("resource/weather_icon_for_go/").listFiles()) {
                String name = FileUtil.getNameWithoutExten(icon);
                String newName = "live_weather_icon_" + name.substring(name.lastIndexOf("_") + 1, name.length()) + ".png";
                FileUtil.copyFile(icon, new File(newPath + newName));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private byte[] inputstream2Byte(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
        return out.toByteArray();
    }

    private String parseInt(String str) {
        String temp = str.substring(0, str.lastIndexOf("."));
        int num = Integer.parseInt(temp);
        if (num >= 0) {
            return "-" + num;
        }
        return Math.abs(num) + "";
    }

    private String getIdString(String attributeValue) {
        return attributeValue.substring(attributeValue.lastIndexOf("/") + 1, attributeValue.length());
    }

    private String createTempDir(String path, String skinName) {
        String skinTempPath = path + skinName + File.separator;
        File skinTempDir = new File(skinTempPath);
        if (!skinTempDir.exists() || !skinTempDir.isDirectory()) {
            skinTempDir.mkdirs();
        }
        return skinTempPath;
    }

    private class CreateDrawableDirTask {
        private CreateDrawableDirTask() {
        }

        public void executeTask(final String path, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    boolean result = GoWidget2TQT.this.createDrawableDir(path + File.separator + "drawable-hdpi" + File.separator, GoWidget2TQT.this.mSkinTempPath);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("Drawable", result);
                    callBack.execute(map);
                }
            }.start();
        }
    }

    private class CreateLayoutLandXmlTask {
        private CreateLayoutLandXmlTask() {
        }

        public void executeTask(final String type, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    GoWidget2TQT.this.createLandLayout(GoWidget2TQT.this.mSkinTempPath, type, "layout-land-hdpi.xml");
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("LayoutLand", true);
                    callBack.execute(map);
                }
            }.start();
        }
    }

    private class CreateLayoutPortXmlTask {
        private CreateLayoutPortXmlTask() {
        }

        public void executeTask(final String path, final String type, final ICallBack callBack) {
            new Thread(){

                public void run() {
                    boolean result = GoWidget2TQT.this.createLayoutXml(path, type, GoWidget2TQT.this.mSkinTempPath);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                    map.put("LayoutPort", result);
                    callBack.execute(map);
                }
            }.start();
        }
    }
}

